/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.fileio;

import edu.uml.lgdc.fileio.DateMask;
import edu.uml.lgdc.fileio.DateMaskStringFilter;
import edu.uml.lgdc.fileio.Dir;
import edu.uml.lgdc.fileio.FileDesc;
import edu.uml.lgdc.fileio.FileFilterType;
import edu.uml.lgdc.fileio.FiledescFilter;
import edu.uml.lgdc.fileio.Filer;
import edu.uml.lgdc.fileio.Mask;
import edu.uml.lgdc.fileio.MaskBuilder;
import edu.uml.lgdc.fileio.MaskStringFilter;
import edu.uml.lgdc.time.TimeScale;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class FilerWithMask {
    private String sourcePath;
    protected Dir source;
    protected Dir target;
    private FiledescFilter filter;
    private TimeScale startTime;
    private TimeScale endTime;
    private Filer filer = new Filer();
    private String dirSeparator = File.separator;
    private boolean done = false;
    private List<String> errors = new ArrayList<String>();
    private List<FileDesc> vFileDesc;
    private FileDesc[] fileDesc;
    private int qtyOfCopied = 0;
    private int qtyOfSkipped = 0;
    private List<Integer> vIndOfNotCopied;
    private int[] indOfNotCopied;
    private long sizeCopied;
    private long totalInSeconds;

    public FilerWithMask() {
        this.source = new Dir();
        this.target = new Dir();
    }

    public FilerWithMask(String inFullAddress, String outFullAddress) {
        this(inFullAddress, outFullAddress, null);
    }

    public FilerWithMask(String inFullAddress, String outFullAddress, FiledescFilter filter) {
        this.sourcePath = this.source.getParsedAddr().path;
        this.source = new Dir(inFullAddress);
        this.target = new Dir(outFullAddress);
        this.filter = filter;
    }

    public FilerWithMask(Dir source, Dir target) {
        this(source, target, null);
    }

    public FilerWithMask(Dir source, Dir target, TimeScale startTime) {
        this(source, target, startTime, null);
    }

    public FilerWithMask(Dir source, Dir target, TimeScale startTime, TimeScale endTime) {
        this.sourcePath = source.getParsedAddr().path;
        this.source = source;
        this.target = target;
        this.filter = source.getFilter();
        this.startTime = startTime;
        this.endTime = endTime;
        this.filer = new Filer(source, target);
        source.setPath("");
    }

    public boolean copyFiles() {
        this.done = false;
        this.vFileDesc = new ArrayList<FileDesc>(100);
        this.fileDesc = new FileDesc[0];
        this.qtyOfCopied = 0;
        this.qtyOfSkipped = 0;
        this.errors = new ArrayList<String>();
        this.vIndOfNotCopied = new ArrayList<Integer>();
        this.indOfNotCopied = null;
        this.sizeCopied = 0L;
        this.totalInSeconds = 0L;
        this.dirSeparator = !this.source.isFTP ? File.separator : "/";
        if (!this.source.getParsedAddr().badFTPAddressSpecification && this.filer.connect()) {
            this.copyIt(this.sourcePath, 0);
        } else {
            this.errors.addAll(this.filer.errors);
        }
        this.filer.disconnect();
        this.fileDesc = new FileDesc[this.vFileDesc.size()];
        int i = 0;
        while (i < this.vFileDesc.size()) {
            this.fileDesc[i] = this.vFileDesc.get(i);
            ++i;
        }
        this.indOfNotCopied = new int[this.vIndOfNotCopied.size()];
        i = 0;
        while (i < this.vIndOfNotCopied.size()) {
            this.indOfNotCopied[i] = this.vIndOfNotCopied.get(i);
            ++i;
        }
        this.done = true;
        return this.getResult();
    }

    private boolean copyIt(String path, int pos) {
        boolean notAborted = true;
        if ((pos = this.getPosOfMaskedDir(path, pos)) > 0) {
            String tail;
            String head = path.substring(0, pos);
            int nextSlash = path.indexOf(this.dirSeparator, pos);
            if (nextSlash < 0) {
                nextSlash = path.length();
                tail = "";
            } else {
                tail = path.substring(nextSlash);
            }
            FiledescFilter filter = FilerWithMask.createFiledescFilterByMask(path.substring(pos, nextSlash), this.startTime, this.endTime, true);
            this.source.setPath(path.substring(0, pos - 1));
            this.source.setFilter(filter);
            pos = nextSlash + 1;
            if (this.source.readDir()) {
                FileDesc[] fileDesc = this.source.getFileDesc();
                if (fileDesc != null) {
                    int i = 0;
                    while (i < fileDesc.length) {
                        if (!this.copyIt(String.valueOf(head) + fileDesc[i].name + tail, head.length() + fileDesc[i].name.length())) {
                            notAborted = false;
                            break;
                        }
                        ++i;
                    }
                }
            } else {
                this.errors.add(this.source.error);
                notAborted = false;
            }
        } else {
            this.source.setPath(path);
            this.source.setFilter(this.filter);
            int prevSize = this.vFileDesc.size();
            this.filer.copyFiles();
            notAborted = !this.filer.isAborted();
            Collections.addAll(this.vFileDesc, this.source.getFileDesc());
            this.qtyOfCopied += this.filer.getQtyOfCopied();
            this.qtyOfSkipped += this.filer.getQtyOfSkipped();
            this.sizeCopied += this.filer.getSizeCopied();
            this.totalInSeconds += this.filer.getTotalInSeconds();
            int i = 0;
            while (i < this.filer.getIndOfNotCopied().length) {
                this.vIndOfNotCopied.add(new Integer(prevSize + this.filer.getIndOfNotCopied()[i]));
                ++i;
            }
            this.errors.addAll(this.filer.errors);
        }
        return notAborted;
    }

    private int getPosOfMaskedDir(String path, int pos) {
        int startPosOfMaskedDirectory = -1;
        int slashPos = path.indexOf(this.dirSeparator, pos);
        while (slashPos >= 0) {
            int nextSlashPos = path.indexOf(this.dirSeparator, slashPos + 1);
            String item = nextSlashPos > 0 ? path.substring(slashPos + 1, nextSlashPos) : path.substring(slashPos + 1);
            if (this.isMasked(item)) {
                startPosOfMaskedDirectory = slashPos + 1;
                break;
            }
            slashPos = nextSlashPos;
        }
        return startPosOfMaskedDirectory;
    }

    private boolean isMasked(String item) {
        boolean result = false;
        if (item != null) {
            int pos = item.indexOf(60);
            boolean bl = result = pos >= 0 && item.indexOf(62, pos) >= 0;
            if (!result) {
                pos = item.indexOf(91);
                boolean bl2 = result = pos >= 0 && item.indexOf(93, pos) >= 0;
            }
            if (!result) {
                result = item.indexOf(42) >= 0 || item.indexOf(63) >= 0;
            }
        }
        return result;
    }

    public static FiledescFilter createFiledescFilterByMask(String item, TimeScale startTime, TimeScale endTime, boolean isDir) {
        FiledescFilter filter = null;
        MaskStringFilter maskStringFilter = null;
        ArrayList<Mask> lstMask = new ArrayList<Mask>();
        int indOfDateMask = -1;
        String exact = "";
        int seq = 0;
        int pos = 0;
        boolean specialSymbol = false;
        int len = 1;
        while (pos < item.length()) {
            specialSymbol = false;
            char c = item.charAt(pos);
            len = 1;
            switch (c) {
                case '<': {
                    int tmpPos = item.indexOf(62, pos + 1);
                    if (tmpPos < 0) break;
                    len = tmpPos - pos + 1;
                    specialSymbol = true;
                    if (!exact.equals("")) {
                        lstMask.add(MaskBuilder.exactSymbolsMask(exact));
                        ++seq;
                        exact = "";
                    }
                    if (len <= 2) break;
                    lstMask.add(MaskBuilder.dateByMask(item.substring(pos + 1, tmpPos)));
                    indOfDateMask = seq++;
                    break;
                }
                case '*': {
                    int tmpPos;
                    specialSymbol = true;
                    if (!exact.equals("")) {
                        lstMask.add(MaskBuilder.exactSymbolsMask(exact));
                        ++seq;
                        exact = "";
                    }
                    if (pos < item.length() - 1 && item.charAt(pos + 1) == '(' && (tmpPos = item.indexOf(41, pos + 1)) >= 0 && tmpPos - pos > 2) {
                        len = tmpPos - pos + 1;
                        lstMask.add(MaskBuilder.anyNumberOfMaskMask(false, MaskBuilder.exactSymbolsMask(item.substring(pos + 2, tmpPos))));
                    } else {
                        lstMask.add(MaskBuilder.anyNumberOfAnySymbolsMask(false));
                    }
                    ++seq;
                    break;
                }
                case '?': {
                    specialSymbol = true;
                    int tmpPos = pos + 1;
                    while (tmpPos < item.length()) {
                        if (item.charAt(tmpPos) != '?') break;
                    }
                    len = tmpPos - pos;
                    if (!exact.equals("")) {
                        lstMask.add(MaskBuilder.exactSymbolsMask(exact));
                        ++seq;
                        exact = "";
                    }
                    lstMask.add(MaskBuilder.exactNumberOfAnySymbolsMask(len));
                    ++seq;
                    break;
                }
                case '[': {
                    int tmpPos = item.indexOf(93, pos);
                    if (tmpPos < 0) break;
                    specialSymbol = true;
                    len = tmpPos - pos + 1;
                    if (!exact.equals("")) {
                        lstMask.add(MaskBuilder.exactSymbolsMask(exact));
                        exact = "";
                        ++seq;
                    }
                    StringTokenizer tok = new StringTokenizer(item.substring(pos + 1, tmpPos), ",");
                    ArrayList<Mask> lstCaseMask = new ArrayList<Mask>();
                    while (tok.hasMoreTokens()) {
                        lstCaseMask.add(MaskBuilder.exactSymbolsMask(tok.nextToken()));
                    }
                    Mask[] aCaseMask = lstCaseMask.toArray(new Mask[lstCaseMask.size()]);
                    lstMask.add(MaskBuilder.anyOfLegalMasksMask(aCaseMask));
                    ++seq;
                }
            }
            pos += len;
            if (specialSymbol) continue;
            exact = String.valueOf(exact) + c;
        }
        if (!exact.equals("")) {
            lstMask.add(MaskBuilder.exactSymbolsMask(exact));
            ++seq;
            exact = "";
        }
        Mask[] aMask = lstMask.toArray(new Mask[lstMask.size()]);
        maskStringFilter = indOfDateMask >= 0 ? new DateMaskStringFilter(DateMask.createDateMask(aMask, indOfDateMask), startTime, endTime) : new MaskStringFilter(aMask);
        filter = new FiledescFilter(maskStringFilter, isDir ? FileFilterType.TYPE_DIR : FileFilterType.TYPE_FILE);
        return filter;
    }

    public boolean getResult() {
        return this.done && (this.errors == null || this.errors.size() == 0);
    }

    public List<String> getErros() {
        return this.errors;
    }

    public FileDesc[] getFileDesc() {
        return this.fileDesc;
    }

    public int getQtyOfCopied() {
        return this.qtyOfCopied;
    }

    public int getQtyOfSkipped() {
        return this.qtyOfSkipped;
    }

    public int[] getIndOfNotCopied() {
        return this.indOfNotCopied;
    }

    public long getSizeCopied() {
        return this.sizeCopied;
    }

    public long getTotalInSeconds() {
        return this.totalInSeconds;
    }
}

