/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.fileio;

import edu.uml.lgdc.fileio.LineInfo;
import java.io.IOException;
import java.io.PushbackInputStream;

public class LineStream {
    public static LineInfo readLine(PushbackInputStream pbis) throws IOException {
        int b;
        int c;
        StringBuffer store = new StringBuffer(2000);
        boolean twoEols = true;
        while ((c = pbis.read()) != -1 && c != 13 && c != 10) {
            store.append((char)c);
        }
        if (c == 13 && (b = pbis.read()) != -1 && b != 10) {
            pbis.unread(b);
            twoEols = false;
        }
        if (c == -1 && store.length() == 0) {
            return null;
        }
        LineInfo outcome = new LineInfo(store.toString(), store.length() + (twoEols ? 2 : 1));
        return outcome;
    }

    public static int readLine(StringBuilder store, PushbackInputStream pbis) throws IOException {
        int c;
        store.setLength(0);
        boolean twoEols = false;
        while ((c = pbis.read()) != -1 && c != 13 && c != 10) {
            store.append((char)c);
        }
        if (c == -1) {
            int len = store.length();
            return len == 0 ? -1 : len;
        }
        if (c == 10) {
            return store.length() + 1;
        }
        int b = pbis.read();
        if (b != -1) {
            if (b != 10) {
                pbis.unread(b);
            } else {
                twoEols = true;
            }
        }
        return store.length() + (twoEols ? 2 : 1);
    }

    public static boolean skipPossibleSecondEOL(PushbackInputStream pbStream) throws IOException {
        int nextChar = pbStream.read();
        if (nextChar != 10) {
            pbStream.unread(nextChar);
            return false;
        }
        return true;
    }
}

