/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.fileio;

import edu.uml.lgdc.fileio.DateMask;
import edu.uml.lgdc.fileio.Mask;
import edu.uml.lgdc.fileio.MaskInterface;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.format.StrUtil;
import edu.uml.lgdc.time.TimeScale;
import java.util.ArrayList;
import java.util.List;

public class MaskBuilder {
    public static Mask exactSymbolsMask(String exactMask) {
        return MaskBuilder.exactSymbolsMask(exactMask, false);
    }

    public static final Mask exactSymbolsMask(String exactMask, boolean insensitive) {
        if (!insensitive) {
            return new Mask(new ExactSymbolsMaskInterface(exactMask));
        }
        return new Mask(new InsensitiveExactSymbolsMaskInterface(exactMask));
    }

    public static Mask insensitiveExactSymbolsMask(String exactMask) {
        return new Mask(new InsensitiveExactSymbolsMaskInterface(exactMask));
    }

    public static Mask exactNumberOfAnySymbolsMask(int number) {
        return new Mask(new ExactNumberOfAnySymbolsMaskInterface(number));
    }

    public static Mask anyNumberOfAnySymbolsMask(boolean oneAtLeast) {
        return new Mask(new AnyNumberOfAnySymbolsMaskInterface(oneAtLeast));
    }

    public static Mask anyOfLegalSymbolsMask(String givenSymbols) {
        return MaskBuilder.exactNumberOfLegalSymbolsMask(1, givenSymbols);
    }

    public static Mask anyOfLegalMasksMask(Mask[] mask) {
        return new Mask(new AnyOfLegalMasksMaskInterface(mask));
    }

    public static DateMask anyOfLegalDateMasksDateMask(final DateMask[] masks) {
        final AnyOfLegalMasksMaskInterface m = new AnyOfLegalMasksMaskInterface(masks);
        return new DateMask(m){

            @Override
            protected int extractYear() {
                int ind = m.getMatched();
                if (ind >= 0) {
                    return masks[ind].extractYear();
                }
                return -1;
            }

            @Override
            protected int extractMonth() {
                int ind = m.getMatched();
                if (ind >= 0) {
                    return masks[ind].extractMonth();
                }
                return -1;
            }

            @Override
            protected int extractDayOfMonth() {
                int ind = m.getMatched();
                if (ind >= 0) {
                    return masks[ind].extractDayOfMonth();
                }
                return -1;
            }

            @Override
            protected int extractDayOfYear() {
                int ind = m.getMatched();
                if (ind >= 0) {
                    return masks[ind].extractDayOfYear();
                }
                return -1;
            }

            @Override
            protected int extractHour() {
                int ind = m.getMatched();
                if (ind >= 0) {
                    return masks[ind].extractHour();
                }
                return -1;
            }

            @Override
            protected int extractMinute() {
                int ind = m.getMatched();
                if (ind >= 0) {
                    return masks[ind].extractMinute();
                }
                return -1;
            }

            @Override
            protected int extractSecond() {
                int ind = m.getMatched();
                if (ind >= 0) {
                    return masks[ind].extractSecond();
                }
                return -1;
            }
        };
    }

    public static Mask exactNumberOfLegalSymbolsMask(int len, String legalSymbols) {
        return new Mask(new ExactNumberOfLegalSymbolsMaskInterface(len, legalSymbols));
    }

    public static Mask anyNumberOfLegalSymbolsMask(boolean oneAtLeast, String legalSymbols) {
        return MaskBuilder.anyNumberOfLegalSymbolsMask(oneAtLeast, legalSymbols, -1);
    }

    public static Mask anyNumberOfLegalSymbolsMask(boolean oneAtLeast, String legalSymbols, int maxNumber) {
        return new Mask(new AnyNumberOfLegalSymbolsMaskInterface(oneAtLeast, legalSymbols, maxNumber));
    }

    public static Mask exactArrayOfMasksMask(Mask[] mask) {
        return new Mask(new ExactArrayOfMasksMaskInterface(mask));
    }

    public static Mask startWithArrayOfMasksMask(Mask[] mask) {
        return new Mask(new StartWithArrayOfMasksMaskInterface(mask));
    }

    public static Mask exactNumberOfMaskMask(int qty, Mask givenMask) {
        Mask[] mask = new Mask[qty];
        int i = 0;
        while (i < qty) {
            mask[i] = (Mask)givenMask.clone();
            ++i;
        }
        return MaskBuilder.exactArrayOfMasksMask(mask);
    }

    public static Mask anyNumberOfMaskMask(boolean oneAtLeast, Mask mask) {
        return new Mask(new AnyNumberOfMaskMaskInterface(oneAtLeast, mask));
    }

    public static Mask exactNumberOfDigitsMask(int qty) {
        return MaskBuilder.exactNumberOfLegalSymbolsMask(qty, "0123456789");
    }

    public static Mask anyNumberOfDigitsMask(boolean atLeastOne) {
        return MaskBuilder.anyNumberOfLegalSymbolsMask(atLeastOne, "0123456789");
    }

    public static Mask exactNumberOfAlphasMask(int qty) {
        return MaskBuilder.exactNumberOfLegalSymbolsMask(qty, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
    }

    public static Mask anyNumberOfAlphasMask(boolean atLeastOne) {
        return MaskBuilder.anyNumberOfLegalSymbolsMask(atLeastOne, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
    }

    public static DateMask shortDateFileName() {
        return new ShortDateFileNameMask();
    }

    public static DateMask dateByMask(String dateMaskStr) {
        return MaskBuilder.dateByMask(dateMaskStr, false);
    }

    public static DateMask dateByMask(String dateMaskStr, boolean startWith) {
        return MaskBuilder.dateByMask(dateMaskStr, startWith, false);
    }

    public static DateMask dateByMask(String dateMaskStr, final boolean startWith, boolean insensitive) {
        ArrayList<Mask> vMask = new ArrayList<Mask>(64);
        int year2 = -1;
        int year4 = -1;
        int monthNumber = -1;
        int monthAlpha = -1;
        int dayInMonth = -1;
        int dayInYear = -1;
        int hourInDay = -1;
        int minute = -1;
        int second = -1;
        int shortDateInd = -1;
        boolean singleQuote = false;
        boolean previousWasSingleQuote = false;
        int seq = 0;
        String exact = "";
        boolean specialMask = false;
        int i = 0;
        while (i < dateMaskStr.length()) {
            int len = 1;
            char c = dateMaskStr.charAt(i);
            if (c != '\'') {
                previousWasSingleQuote = false;
                if (singleQuote) {
                    exact = String.valueOf(exact) + c;
                } else {
                    specialMask = false;
                    switch (c) {
                        case 'Y': 
                        case 'y': {
                            if (year2 != -1 || year4 != -1) break;
                            String tmp = dateMaskStr.substring(i).toUpperCase();
                            if (tmp.startsWith("YYYY")) {
                                len = 4;
                            } else if (tmp.startsWith("YY")) {
                                len = 2;
                            }
                            if (len <= 1) break;
                            specialMask = true;
                            if (!exact.equals("")) {
                                vMask.add(MaskBuilder.exactSymbolsMask(exact, insensitive));
                                exact = "";
                                ++seq;
                            }
                            vMask.add(MaskBuilder.exactNumberOfDigitsMask(len));
                            if (len == 2) {
                                year2 = seq;
                            } else {
                                year4 = seq;
                            }
                            ++seq;
                            break;
                        }
                        case 'M': {
                            if (monthNumber != -1 || monthAlpha != -1) break;
                            String tmp = dateMaskStr.substring(i);
                            if (tmp.startsWith("MMM")) {
                                len = 3;
                            } else if (tmp.startsWith("MM")) {
                                len = 2;
                            }
                            if (len <= 1) break;
                            specialMask = true;
                            if (!exact.equals("")) {
                                vMask.add(MaskBuilder.exactSymbolsMask(exact, insensitive));
                                exact = "";
                                ++seq;
                            }
                            if (len == 2) {
                                monthNumber = seq;
                                vMask.add(MaskBuilder.exactNumberOfDigitsMask(len));
                            } else {
                                monthAlpha = seq;
                                vMask.add(MaskBuilder.exactNumberOfAlphasMask(len));
                            }
                            ++seq;
                            break;
                        }
                        case 'd': {
                            if (dayInMonth != -1) break;
                            String tmp = dateMaskStr.substring(i);
                            if (tmp.startsWith("dd")) {
                                len = 2;
                            }
                            if (len <= 1) break;
                            specialMask = true;
                            if (!exact.equals("")) {
                                vMask.add(MaskBuilder.exactSymbolsMask(exact, insensitive));
                                exact = "";
                            }
                            vMask.add(MaskBuilder.exactNumberOfDigitsMask(len));
                            dayInMonth = ++seq;
                            ++seq;
                            break;
                        }
                        case 'D': {
                            if (dayInYear != -1) break;
                            String tmp = dateMaskStr.substring(i);
                            if (tmp.startsWith("DDD")) {
                                len = 3;
                            }
                            if (len <= 1) break;
                            specialMask = true;
                            if (!exact.equals("")) {
                                vMask.add(MaskBuilder.exactSymbolsMask(exact, insensitive));
                                exact = "";
                            }
                            vMask.add(MaskBuilder.exactNumberOfDigitsMask(len));
                            dayInYear = ++seq;
                            ++seq;
                            break;
                        }
                        case 'H': {
                            if (hourInDay != -1) break;
                            String tmp = dateMaskStr.substring(i);
                            if (tmp.startsWith("HH")) {
                                len = 2;
                            }
                            if (len <= 1) break;
                            specialMask = true;
                            if (!exact.equals("")) {
                                vMask.add(MaskBuilder.exactSymbolsMask(exact, insensitive));
                                exact = "";
                            }
                            vMask.add(MaskBuilder.exactNumberOfDigitsMask(len));
                            hourInDay = ++seq;
                            ++seq;
                            break;
                        }
                        case 'm': {
                            if (minute != -1) break;
                            String tmp = dateMaskStr.substring(i);
                            if (tmp.startsWith("mm")) {
                                len = 2;
                            }
                            if (len <= 1) break;
                            specialMask = true;
                            if (!exact.equals("")) {
                                vMask.add(MaskBuilder.exactSymbolsMask(exact, insensitive));
                                exact = "";
                            }
                            vMask.add(MaskBuilder.exactNumberOfDigitsMask(len));
                            minute = ++seq;
                            ++seq;
                            break;
                        }
                        case 's': {
                            if (second != -1) break;
                            String tmp = dateMaskStr.substring(i);
                            if (tmp.startsWith("ss")) {
                                len = 2;
                            }
                            if (len <= 1) break;
                            specialMask = true;
                            if (!exact.equals("")) {
                                vMask.add(MaskBuilder.exactSymbolsMask(exact, insensitive));
                                exact = "";
                            }
                            vMask.add(MaskBuilder.exactNumberOfDigitsMask(len));
                            second = ++seq;
                            ++seq;
                            break;
                        }
                        case '*': {
                            int tmpPos;
                            specialMask = true;
                            if (!exact.equals("")) {
                                vMask.add(MaskBuilder.exactSymbolsMask(exact, insensitive));
                                exact = "";
                                ++seq;
                            }
                            if (i < dateMaskStr.length() - 1 && dateMaskStr.charAt(i + 1) == '(' && (tmpPos = dateMaskStr.indexOf(41, i + 1)) >= 0 && tmpPos - i > 2) {
                                len = tmpPos - i + 1;
                                vMask.add(MaskBuilder.anyNumberOfMaskMask(false, MaskBuilder.exactSymbolsMask(dateMaskStr.substring(i + 2, tmpPos))));
                            } else {
                                vMask.add(MaskBuilder.anyNumberOfAnySymbolsMask(false));
                            }
                            ++seq;
                            break;
                        }
                        case '?': {
                            specialMask = true;
                            int tmpPos = i + 1;
                            len = 1;
                            while (tmpPos < dateMaskStr.length()) {
                                if (dateMaskStr.charAt(tmpPos) != '?') break;
                                ++len;
                                ++tmpPos;
                            }
                            if (!exact.equals("")) {
                                vMask.add(MaskBuilder.exactSymbolsMask(exact, insensitive));
                                exact = "";
                                ++seq;
                            }
                            vMask.add(MaskBuilder.exactNumberOfAnySymbolsMask(len));
                            ++seq;
                            break;
                        }
                        case '[': {
                            int tmpPos = dateMaskStr.indexOf(93, i);
                            if (tmpPos < 0) break;
                            specialMask = true;
                            len = tmpPos - i + 1;
                            if (!exact.equals("")) {
                                vMask.add(MaskBuilder.exactSymbolsMask(exact, insensitive));
                                exact = "";
                                ++seq;
                            }
                            String[] sym = StrUtil.listToArray(dateMaskStr.substring(i + 1, tmpPos), ',');
                            Mask[] aCaseMask = new Mask[sym.length];
                            int ii = 0;
                            while (ii < sym.length) {
                                aCaseMask[ii] = MaskBuilder.exactSymbolsMask(sym[ii]);
                                ++ii;
                            }
                            vMask.add(MaskBuilder.anyOfLegalMasksMask(aCaseMask));
                            ++seq;
                            break;
                        }
                        case '$': {
                            specialMask = true;
                            if (!exact.equals("")) {
                                vMask.add(MaskBuilder.exactSymbolsMask(exact, insensitive));
                                exact = "";
                            }
                            vMask.add(MaskBuilder.shortDateFileName());
                            shortDateInd = ++seq;
                            ++seq;
                            break;
                        }
                        default: {
                            specialMask = false;
                        }
                    }
                    if (!specialMask) {
                        exact = String.valueOf(exact) + c;
                    }
                }
            } else if (!singleQuote) {
                singleQuote = true;
                previousWasSingleQuote = true;
            } else {
                if (previousWasSingleQuote) {
                    exact = String.valueOf(exact) + c;
                }
                singleQuote = false;
                previousWasSingleQuote = false;
            }
            i += len;
        }
        if (!exact.equals("")) {
            vMask.add(MaskBuilder.exactSymbolsMask(exact, insensitive));
            ++seq;
        }
        final Mask[] aMask = vMask.toArray(new Mask[vMask.size()]);
        Mask m = !startWith ? MaskBuilder.exactArrayOfMasksMask(aMask) : MaskBuilder.startWithArrayOfMasksMask(aMask);
        final int y2 = year2;
        final int y4 = year4;
        final int mN = monthNumber;
        final int mA = monthAlpha;
        final int dIM = dayInMonth;
        final int dIY = dayInYear;
        final int hID = hourInDay;
        final int min = minute;
        final int sec = second;
        final int sDate = shortDateInd;
        return new DateMask(m){

            @Override
            protected int extractYear() {
                if (sDate != -1) {
                    return ((DateMask)aMask[sDate]).extractYear();
                }
                int year = -1;
                if (y2 >= 0 || y4 >= 0) {
                    String tmp = y4 >= 0 ? aMask[y4].lastMatchedString() : aMask[y2].lastMatchedString();
                    year = FC.StringToInteger(tmp);
                    if (y2 >= 0) {
                        year = year > 60 ? (year += 1900) : (year += 2000);
                    }
                }
                return year;
            }

            @Override
            protected int extractMonth() {
                if (sDate != -1) {
                    return ((DateMask)aMask[sDate]).extractMonth();
                }
                int month = -1;
                if (mN >= 0 || mA >= 0) {
                    if (mN >= 0) {
                        String tmp = aMask[mN].lastMatchedString();
                        if (tmp != null) {
                            month = FC.StringToInteger(tmp);
                        } else if (startWith) {
                            month = 1;
                        }
                    } else if (mA >= 0) {
                        String tmp = aMask[mA].lastMatchedString();
                        if (tmp != null) {
                            month = TimeScale.monthToNumber(tmp);
                        } else if (startWith) {
                            month = 1;
                        }
                    }
                }
                return month;
            }

            @Override
            protected int extractDayOfMonth() {
                if (sDate != -1) {
                    return ((DateMask)aMask[sDate]).extractDayOfMonth();
                }
                int dayOfMonth = -1;
                if (dIM >= 0) {
                    String tmp = aMask[dIM].lastMatchedString();
                    if (tmp != null) {
                        dayOfMonth = FC.StringToInteger(tmp);
                    } else if (startWith) {
                        dayOfMonth = 1;
                    }
                }
                return dayOfMonth;
            }

            @Override
            protected int extractDayOfYear() {
                if (sDate != -1) {
                    return ((DateMask)aMask[sDate]).extractDayOfYear();
                }
                int dayOfYear = -1;
                if (dIY >= 0) {
                    String tmp = aMask[dIY].lastMatchedString();
                    if (tmp != null) {
                        dayOfYear = FC.StringToInteger(tmp);
                    } else if (startWith) {
                        dayOfYear = 1;
                    }
                }
                return dayOfYear;
            }

            @Override
            protected int extractHour() {
                if (sDate != -1) {
                    return ((DateMask)aMask[sDate]).extractHour();
                }
                int hour = -1;
                if (hID >= 0) {
                    String tmp = aMask[hID].lastMatchedString();
                    if (tmp != null) {
                        hour = FC.StringToInteger(tmp);
                    } else if (startWith) {
                        hour = 0;
                    }
                }
                return hour;
            }

            @Override
            protected int extractMinute() {
                if (sDate != -1) {
                    return ((DateMask)aMask[sDate]).extractMinute();
                }
                int minute = -1;
                if (min >= 0) {
                    String tmp = aMask[min].lastMatchedString();
                    if (tmp != null) {
                        minute = FC.StringToInteger(tmp);
                    } else if (startWith) {
                        minute = 0;
                    }
                }
                return minute;
            }

            @Override
            protected int extractSecond() {
                if (sDate != -1) {
                    return ((DateMask)aMask[sDate]).extractSecond();
                }
                int second = -1;
                if (sec >= 0) {
                    String tmp = aMask[sec].lastMatchedString();
                    if (tmp != null) {
                        second = FC.StringToInteger(tmp);
                    } else if (startWith) {
                        second = 0;
                    }
                }
                return second;
            }
        };
    }

    static final class AnyNumberOfAnySymbolsMaskInterface
    extends MaskInterface {
        private boolean oneAtLeast = false;
        private int count = 0;

        AnyNumberOfAnySymbolsMaskInterface(boolean oneAtLeast) {
            this.oneAtLeast = oneAtLeast;
        }

        @Override
        public int firstMatch(String str) {
            this.count = 0;
            if (!this.oneAtLeast) {
                return this.count;
            }
            return this.nextMatch(str);
        }

        @Override
        public int nextMatch(String str) {
            int len = -1;
            ++this.count;
            if (str.length() >= this.count) {
                len = this.count;
            }
            return len;
        }
    }

    static class AnyNumberOfLegalSymbolsMaskInterface
    extends MaskInterface {
        private boolean oneAtLeast = false;
        private String legalSymbols = null;
        private int maxNumber = -1;
        private int count = -1;

        AnyNumberOfLegalSymbolsMaskInterface(boolean oneAtLeast, String legalSymbols, int maxNumber) {
            this.oneAtLeast = oneAtLeast;
            this.legalSymbols = legalSymbols;
            this.maxNumber = maxNumber;
        }

        @Override
        public int firstMatch(String str) {
            this.count = 0;
            if (!this.oneAtLeast) {
                return this.count;
            }
            return this.nextMatch(str);
        }

        @Override
        public int nextMatch(String str) {
            if (this.count == -1) {
                return -1;
            }
            if (this.maxNumber != -1 && this.count >= this.maxNumber) {
                this.count = -1;
                return -1;
            }
            ++this.count;
            if (this.legalSymbols.indexOf(str.charAt(this.count - 1)) >= 0) {
                return this.count;
            }
            this.count = -1;
            return -1;
        }
    }

    static class AnyNumberOfMaskMaskInterface
    extends MaskInterface {
        private final boolean oneAtLeast;
        private Mask mask;
        private List<Integer> nextPos;
        private List<Mask> vMask;
        private int next = 0;
        private boolean goForward = true;

        AnyNumberOfMaskMaskInterface(boolean oneAtLeast, Mask mask) {
            this.oneAtLeast = oneAtLeast;
            this.mask = mask;
        }

        @Override
        public int firstMatch(String str) {
            this.nextPos = new ArrayList<Integer>(64);
            this.vMask = new ArrayList<Mask>(64);
            this.next = 0;
            this.goForward = true;
            if (!this.oneAtLeast) {
                return 0;
            }
            return this.nextMatch(str);
        }

        @Override
        public int nextMatch(String str) {
            int matchedLength = -1;
            if (this.next < 0) {
                return matchedLength;
            }
            int len = 0;
            String tail = this.next > 0 ? str.substring(this.nextPos.get(this.next - 1)) : str;
            if (this.goForward) {
                this.insureSize();
            }
            if (this.goForward) {
                len = this.vMask.get(this.next).firstMatch(tail);
            }
            if (len == 0) {
                len = this.vMask.get(this.next).nextMatch(tail);
            }
            if (len >= 0) {
                int pos = this.next > 0 ? this.nextPos.get(this.next - 1) + len : len;
                this.nextPos.set(pos, this.next);
                matchedLength = pos;
                ++this.next;
                this.goForward = true;
            } else {
                --this.next;
                this.goForward = false;
                while (this.next >= 0) {
                    if (this.nextMatch(str) >= 0) {
                        matchedLength = this.nextPos.get(this.next - 1);
                        break;
                    }
                    --this.next;
                    this.goForward = false;
                }
            }
            return matchedLength;
        }

        @Override
        public Object clone() {
            AnyNumberOfMaskMaskInterface cloned = (AnyNumberOfMaskMaskInterface)super.clone();
            cloned.mask = (Mask)this.mask.clone();
            return cloned;
        }

        private void insureSize() {
            if (this.nextPos.size() < this.next + 1) {
                this.nextPos.add(null);
                this.vMask.add((Mask)this.mask.clone());
            }
        }
    }

    static final class AnyOfLegalMasksMaskInterface
    extends MaskInterface {
        Mask[] mask = null;
        int matched = -1;
        int count = 0;
        boolean firstMatchDone = false;
        boolean allDone = false;

        AnyOfLegalMasksMaskInterface(Mask[] mask) {
            this.mask = new Mask[mask.length];
            int i = 0;
            while (i < mask.length) {
                this.mask[i] = mask[i];
                ++i;
            }
        }

        @Override
        public int firstMatch(String str) {
            this.count = 0;
            this.firstMatchDone = false;
            this.allDone = false;
            return this.nextMatch(str);
        }

        @Override
        public int nextMatch(String str) {
            this.matched = -1;
            int len = -1;
            if (this.allDone) {
                return len;
            }
            boolean fullPass = false;
            while (true) {
                fullPass = this.count == 0;
                while (this.count < this.mask.length) {
                    len = this.firstMatchDone ? this.mask[this.count].nextMatch(str) : this.mask[this.count].firstMatch(str);
                    ++this.count;
                    if (len >= 0) break;
                }
                if (len >= 0) {
                    this.matched = this.count - 1;
                }
                if (this.count < this.mask.length) break;
                this.count = 0;
                if (len >= 0) {
                    this.firstMatchDone = true;
                    break;
                }
                if (this.firstMatchDone) {
                    if (!fullPass) continue;
                    this.allDone = true;
                    break;
                }
                this.firstMatchDone = true;
            }
            return len;
        }

        public int getMatched() {
            return this.matched;
        }

        @Override
        public Object clone() {
            AnyOfLegalMasksMaskInterface cloned = (AnyOfLegalMasksMaskInterface)super.clone();
            cloned.mask = new Mask[this.mask.length];
            int i = 0;
            while (i < this.mask.length) {
                cloned.mask[i] = (Mask)this.mask[i].clone();
                ++i;
            }
            return cloned;
        }
    }

    static class ExactArrayOfMasksMaskInterface
    extends MaskInterface {
        Mask[] mask = null;
        private int length = -1;
        private int[] nextPos = null;
        private int next = -1;
        private boolean goForward = true;

        ExactArrayOfMasksMaskInterface(Mask[] mask) {
            this.length = mask.length;
            this.mask = new Mask[this.length];
            int i = 0;
            while (i < this.length) {
                this.mask[i] = mask[i];
                ++i;
            }
            this.nextPos = new int[this.length];
        }

        @Override
        public int firstMatch(String str) {
            this.goForward = true;
            this.next = 0;
            return this.nextMatch(str);
        }

        @Override
        public int nextMatch(String str) {
            int matchedLength = -1;
            if (this.next == -1) {
                return matchedLength;
            }
            int len = 0;
            String tail = this.next > 0 ? str.substring(this.nextPos[this.next - 1]) : str;
            len = this.goForward ? this.mask[this.next].firstMatch(tail) : this.mask[this.next].nextMatch(tail);
            this.goForward = false;
            if (len >= 0) {
                this.nextPos[this.next] = this.next > 0 ? this.nextPos[this.next - 1] + len : len;
                if (this.next < this.length - 1) {
                    ++this.next;
                    this.goForward = true;
                    return this.nextMatch(str);
                }
                matchedLength = this.nextPos[this.length - 1];
            } else {
                --this.next;
                this.goForward = false;
                while (this.next >= 0) {
                    if (this.nextMatch(str) >= 0) {
                        matchedLength = this.nextPos[this.length - 1];
                        break;
                    }
                    --this.next;
                    this.goForward = false;
                }
            }
            return matchedLength;
        }

        @Override
        public Object clone() {
            ExactArrayOfMasksMaskInterface cloned = (ExactArrayOfMasksMaskInterface)super.clone();
            cloned.mask = new Mask[this.mask.length];
            int i = 0;
            while (i < this.length) {
                cloned.mask[i] = (Mask)this.mask[i].clone();
                ++i;
            }
            return cloned;
        }
    }

    static final class ExactNumberOfAnySymbolsMaskInterface
    extends MaskInterface {
        private int number = -1;

        ExactNumberOfAnySymbolsMaskInterface(int number) {
            this.number = number;
        }

        @Override
        public int firstMatch(String str) {
            int len = -1;
            if (str.length() >= this.number) {
                len = this.number;
            }
            return len;
        }

        @Override
        public int nextMatch(String str) {
            return -1;
        }
    }

    static class ExactNumberOfLegalSymbolsMaskInterface
    extends MaskInterface {
        private int len = -1;
        private String legalSymbols = null;

        ExactNumberOfLegalSymbolsMaskInterface(int len, String legalSymbols) {
            this.len = len;
            this.legalSymbols = legalSymbols;
        }

        @Override
        public int firstMatch(String str) {
            if (str.length() >= this.len && StrUtil.consistOf(str.substring(0, this.len), this.legalSymbols)) {
                return this.len;
            }
            return -1;
        }

        @Override
        public int nextMatch(String str) {
            return -1;
        }
    }

    static final class ExactSymbolsMaskInterface
    extends MaskInterface {
        private String exactMask = null;

        ExactSymbolsMaskInterface(String exactMask) {
            this.exactMask = exactMask;
        }

        @Override
        public int firstMatch(String str) {
            int len = -1;
            if (str.startsWith(this.exactMask)) {
                len = this.exactMask.length();
            }
            return len;
        }

        @Override
        public int nextMatch(String str) {
            return -1;
        }
    }

    static final class InsensitiveExactSymbolsMaskInterface
    extends MaskInterface {
        private String exactMask = null;
        private int length;

        InsensitiveExactSymbolsMaskInterface(String exactMask) {
            this.exactMask = exactMask.toLowerCase();
            this.length = exactMask.length();
        }

        @Override
        public int firstMatch(String str) {
            int len = -1;
            if (this.length <= str.length() && this.exactMask.equals(str.substring(0, this.length).toLowerCase())) {
                len = this.exactMask.length();
            }
            return len;
        }

        @Override
        public int nextMatch(String str) {
            return -1;
        }
    }

    static class ShortDateFileNameMask
    extends DateMask {
        private final String hourCodes = "ABCDEFGHIJKLMNOPQRSTUVWX";
        private final String secondCodes = "ABCDEFGHIJKL";
        private final Mask[] aMask = new Mask[5];
        Mask m = null;

        ShortDateFileNameMask() {
            this.aMask[0] = MaskBuilder.exactNumberOfDigitsMask(1);
            this.aMask[1] = MaskBuilder.exactNumberOfDigitsMask(3);
            this.aMask[2] = MaskBuilder.exactNumberOfLegalSymbolsMask(1, "ABCDEFGHIJKLMNOPQRSTUVWX");
            this.aMask[3] = MaskBuilder.exactNumberOfDigitsMask(2);
            this.aMask[4] = MaskBuilder.exactNumberOfLegalSymbolsMask(1, "ABCDEFGHIJKL");
            this.m = MaskBuilder.exactArrayOfMasksMask(this.aMask);
            this.mi = this.m.mi;
        }

        @Override
        protected int extractYear() {
            return 2000 + FC.StringToInteger(this.aMask[0].lastMatchedString());
        }

        @Override
        protected int extractMonth() {
            return -1;
        }

        @Override
        protected int extractDayOfMonth() {
            return -1;
        }

        @Override
        protected int extractDayOfYear() {
            return FC.StringToInteger(this.aMask[1].lastMatchedString());
        }

        @Override
        protected int extractHour() {
            return "ABCDEFGHIJKLMNOPQRSTUVWX".indexOf(this.aMask[2].lastMatchedString().charAt(0));
        }

        @Override
        protected int extractMinute() {
            return FC.StringToInteger(this.aMask[3].lastMatchedString());
        }

        @Override
        protected int extractSecond() {
            return 5 * "ABCDEFGHIJKL".indexOf(this.aMask[4].lastMatchedString().charAt(0));
        }
    }

    static class StartWithArrayOfMasksMaskInterface
    extends MaskInterface {
        Mask[] mask = null;
        private int length = -1;
        private int[] nextPos = null;
        private int next = -1;
        private boolean goForward = true;

        StartWithArrayOfMasksMaskInterface(Mask[] mask) {
            this.length = mask.length;
            this.mask = new Mask[this.length];
            int i = 0;
            while (i < this.length) {
                this.mask[i] = mask[i];
                ++i;
            }
            this.nextPos = new int[this.length];
        }

        @Override
        public int firstMatch(String str) {
            this.goForward = true;
            this.next = 0;
            return this.nextMatch(str);
        }

        @Override
        public int nextMatch(String str) {
            int matchedLength = -1;
            if (this.next == -1) {
                return matchedLength;
            }
            int len = 0;
            String tail = this.next > 0 ? str.substring(this.nextPos[this.next - 1]) : str;
            if (this.goForward) {
                len = this.mask[this.next].firstMatch(tail);
            }
            if (len == 0) {
                len = this.mask[this.next].nextMatch(tail);
            }
            this.goForward = false;
            if (len >= 0) {
                this.nextPos[this.next] = this.next > 0 ? this.nextPos[this.next - 1] + len : len;
                if (this.next < this.length - 1 && tail.length() > len) {
                    ++this.next;
                    this.goForward = true;
                    return this.nextMatch(str);
                }
                matchedLength = this.nextPos[this.next];
            } else {
                --this.next;
                while (this.next >= 0) {
                    if (this.nextMatch(str) >= 0) {
                        matchedLength = this.nextPos[this.length - 1];
                        break;
                    }
                    --this.next;
                    this.goForward = false;
                }
            }
            return matchedLength;
        }

        @Override
        public Object clone() {
            StartWithArrayOfMasksMaskInterface cloned = (StartWithArrayOfMasksMaskInterface)super.clone();
            cloned.mask = new Mask[this.mask.length];
            int i = 0;
            while (i < this.length) {
                cloned.mask[i] = (Mask)this.mask[i].clone();
                ++i;
            }
            return cloned;
        }
    }
}

