/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.fileio;

public class ParsedFTPAddr {
    public static final String FTP_PROTOCOL_STRING = "FTP://";
    public static final int FTP_PROTOCOL_STRING_LEN = "FTP://".length();
    public String address;
    public boolean isFTP = false;
    public String ftpAddress;
    public String path;
    public boolean badFTPAddressSpecification = false;
    public String userName;
    public String userPass;

    public ParsedFTPAddr() {
    }

    public ParsedFTPAddr(String fullAddress) {
        this.fill(fullAddress);
    }

    public void fill(String address) {
        this.clear();
        if (address != null) {
            this.address = address;
            this.isFTP = ParsedFTPAddr.isFTPProtocol(address);
            if (this.isFTP) {
                int pos = address.indexOf(64, FTP_PROTOCOL_STRING_LEN);
                int pos2 = address.indexOf(47, FTP_PROTOCOL_STRING_LEN);
                if (pos >= 0 && (pos2 < 0 || pos < pos2)) {
                    String user_pass = address.substring(FTP_PROTOCOL_STRING_LEN, pos);
                    int pos1 = user_pass.indexOf(58);
                    if (pos1 >= 0) {
                        this.userName = user_pass.substring(0, pos1);
                        this.userPass = user_pass.substring(pos1 + 1);
                    } else {
                        this.userName = user_pass;
                    }
                    ++pos;
                } else {
                    pos = FTP_PROTOCOL_STRING_LEN;
                }
                this.path = address.substring(pos);
                int slashPos = this.path.indexOf(47);
                if (slashPos >= 0) {
                    this.ftpAddress = this.path.substring(0, slashPos);
                    this.path = this.path.substring(slashPos);
                } else {
                    this.ftpAddress = this.path;
                    this.path = "/";
                }
                if (this.ftpAddress.length() == 0) {
                    this.badFTPAddressSpecification = true;
                }
            } else {
                this.path = address;
            }
        }
    }

    public static ParsedFTPAddr create(String address) {
        ParsedFTPAddr parsedFTPAddr = new ParsedFTPAddr();
        parsedFTPAddr.fill(address);
        if (parsedFTPAddr.path == null) {
            parsedFTPAddr = null;
        }
        return parsedFTPAddr;
    }

    private void clear() {
        this.address = null;
        this.isFTP = false;
        this.ftpAddress = null;
        this.path = null;
        this.badFTPAddressSpecification = false;
        this.userName = null;
        this.userPass = null;
    }

    public static boolean isFTPProtocol(String path) {
        boolean result = false;
        if (path.length() >= FTP_PROTOCOL_STRING_LEN) {
            result = path.substring(0, FTP_PROTOCOL_STRING_LEN).toUpperCase().equals(FTP_PROTOCOL_STRING);
        }
        return result;
    }
}

