/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.fileio;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class PartOfFileInputStream
extends FileInputStream {
    private final long length;
    private long bytesRead = 0L;

    public PartOfFileInputStream(File file, long offset, long length) throws IOException {
        this(file.getPath(), offset, length);
    }

    public PartOfFileInputStream(String fileName, long offset, long length) throws IOException {
        super(fileName);
        this.length = length;
        this.skip(offset);
    }

    @Override
    public int read() throws IOException {
        int byteRead = -1;
        if (this.bytesRead < this.length && (byteRead = super.read()) != -1) {
            ++this.bytesRead;
        }
        return byteRead;
    }

    @Override
    public int available() throws IOException {
        return (int)(this.length - this.bytesRead);
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read(byte[] bytes, int off, int length) throws IOException {
        int totalBytes = 0;
        int i = 0;
        while (i < length) {
            int currentByte = this.read();
            if (currentByte != -1) {
                bytes[i] = (byte)currentByte;
                ++totalBytes;
            } else {
                if (totalBytes != 0) break;
                totalBytes = -1;
                break;
            }
            ++i;
        }
        return totalBytes;
    }
}

