/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.fileio;

import edu.uml.lgdc.fileio.FileRW;
import edu.uml.lgdc.fileio.XmlAttribute;
import java.io.IOException;
import java.util.List;

public class XmlFile
extends FileRW {
    public XmlFile(String filename) throws IOException {
        super(filename);
    }

    public void writeOpenTag(String tag) throws IOException {
        this.writeOpenTag(tag, true);
    }

    public void writeOpenTag(String tag, boolean eol) throws IOException {
        this.write("<" + tag + ">");
        if (eol) {
            this.newLine();
        }
    }

    public void writeOpenTag(String tag, List<XmlAttribute> attributes) throws IOException {
        this.writeOpenTag(tag, attributes, true);
    }

    public void writeOpenTag(String tag, List<XmlAttribute> attributes, boolean eol) throws IOException {
        this.write("<" + tag);
        if (attributes != null && attributes.size() > 0) {
            this.write(" ");
            int i = 0;
            while (i < attributes.size()) {
                this.writeAttribute(attributes.get(i).getName(), attributes.get(i).getValue());
                ++i;
            }
        }
        this.write(">");
        if (eol) {
            this.newLine();
        }
    }

    public void writeCloseTag(String tag) throws IOException {
        this.write("</" + tag + ">");
        this.newLine();
    }

    public void writeAttribute(String name, String value) throws IOException {
        this.write(String.valueOf(name) + "=\"" + value + "\" ");
    }

    public void writeOneLineElement(String tag, List<XmlAttribute> attributes, String data) throws IOException {
        this.write("<" + tag);
        if (attributes != null && attributes.size() > 0) {
            this.write(" ");
            int i = 0;
            while (i < attributes.size()) {
                XmlAttribute attribute = attributes.get(i);
                this.writeAttribute(attribute.getName(), attribute.getValue());
                ++i;
            }
        }
        if (data == null || data.length() == 0) {
            this.write("/>");
            this.newLine();
            return;
        }
        this.write(">" + data);
        this.writeCloseTag(tag);
    }
}

