/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.format;

import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.format.StrUtil;

public class FixedFormat {
    private int length;
    private int decimals;
    private boolean pointIsAlwaysNeeded;
    private boolean discardTrailingZeros = true;

    public FixedFormat(int length, int decimals) {
        this(length, decimals, false);
    }

    public FixedFormat(int length, int decimals, boolean pointIsAlawaysNeeded) {
        if (length < 1) {
            throw new IllegalArgumentException("length is less than 1");
        }
        if (decimals < 0) {
            throw new IllegalArgumentException("decimals is less than 0");
        }
        int minLength = 1 + (this.pointIsAlwaysNeeded ? 1 : 0) + decimals;
        if (length < minLength) {
            throw new IllegalArgumentException("length is loo small");
        }
        this.length = length;
        this.decimals = decimals;
        this.pointIsAlwaysNeeded = pointIsAlawaysNeeded;
    }

    public boolean getPointIsAlwaysNeededEnabled() {
        return this.pointIsAlwaysNeeded;
    }

    public void setPointIsAlwaysNeededEnabled(boolean value) {
        if (value != this.pointIsAlwaysNeeded) {
            this.pointIsAlwaysNeeded = value;
            if (this.decimals == 0) {
                this.length = this.pointIsAlwaysNeeded ? ++this.length : --this.length;
            }
        }
    }

    public boolean getDiscardTrailingZerosEnabled() {
        return this.discardTrailingZeros;
    }

    public void setDiscardTrailingZerosEnabled(boolean value) {
        this.discardTrailingZeros = value;
    }

    public String format(double value) {
        return this.format(value, this.discardTrailingZeros);
    }

    public String format(double value, boolean discardTrailingZeros) {
        String str = this.decimals > 0 ? FC.doubleToString(value, this.decimals, discardTrailingZeros) : (!this.pointIsAlwaysNeeded ? "" + (int)Math.round(value) : (int)Math.round(value) + ".");
        if (str.length() > this.length) {
            str = String.valueOf(value > 0.0 ? "+" : "-") + StrUtil.repeat('*', this.length - 1);
        }
        return str;
    }

    public int getLength() {
        return this.length;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public static FixedFormat createFormat(double minimum, double maximum, double granulation) {
        if (granulation <= 0.0) {
            throw new IllegalArgumentException("granulation is <= 0, " + granulation);
        }
        if (granulation > 1.0) {
            granulation = 1.0;
        }
        minimum = minimum >= 0.0 ? Math.rint(minimum) : Math.ceil(minimum);
        maximum = maximum >= 0.0 ? Math.rint(maximum) : Math.ceil(maximum);
        int length = Math.max(("" + (int)minimum).length(), ("" + (int)maximum).length());
        int decimals = 0;
        if (granulation < 1.0) {
            decimals = ("" + Math.max(0, (int)(1.0 / granulation - 1.0))).length();
        }
        if (decimals > 0) {
            length += 1 + decimals;
        }
        return new FixedFormat(length, decimals);
    }
}

