/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.format;

import edu.uml.lgdc.format.StrUtil;
import java.util.Locale;
import javax.swing.JTextField;

public class Formatter {
    public static final String format(String format, Object ... args) {
        return String.format(Locale.US, format, args);
    }

    public static final String padLeft(String str, int width) {
        return Formatter.padLeft(str, width, ' ');
    }

    public static final String padLeft(String str, int width, char ch) {
        int length = str.length();
        if (length == width) {
            return str;
        }
        if (length > width) {
            return str.substring(length - width, length);
        }
        int padLen = width - length;
        char[] chArr = new char[width];
        int i = 0;
        while (i < padLen) {
            chArr[i] = ch;
            ++i;
        }
        i = padLen;
        int j = 0;
        while (i < width) {
            chArr[i] = str.charAt(j);
            ++i;
            ++j;
        }
        return new String(chArr);
    }

    public static final String padRight(String str, int width) {
        return Formatter.padRight(str, width, ' ');
    }

    public static final String padRight(String str, int width, char ch) {
        int length = str.length();
        if (length == width) {
            return str;
        }
        if (length > width) {
            return str.substring(0, width);
        }
        char[] chArr = new char[width];
        int i = 0;
        while (i < length) {
            chArr[i] = str.charAt(i);
            ++i;
        }
        i = length;
        while (i < width) {
            chArr[i] = ch;
            ++i;
        }
        return new String(chArr);
    }

    public static String int2HexStr(int value, int width) {
        return String.format(Locale.US, "%0" + width + "X", value);
    }

    public static String getFFormat(int Length, int fractionLength) {
        return "%" + Length + "." + fractionLength + "f";
    }

    public static String trimTail(String str, char ch) {
        int pos = str.length();
        while (--pos >= 0) {
            if (str.charAt(pos) != ch) break;
        }
        if (++pos < str.length()) {
            return str.substring(0, pos);
        }
        return str;
    }

    public static int checkNumericFieldValue(JTextField tf, int minValue, int maxValue, int previous) {
        int val = previous;
        boolean reset = false;
        try {
            val = Integer.parseInt(tf.getText().trim().trim());
            if (val < minValue || val > maxValue) {
                val = previous;
                reset = true;
            }
        }
        catch (NumberFormatException ex) {
            reset = true;
        }
        if (reset) {
            tf.setText("" + val);
        }
        return val;
    }

    public static double checkNumericFieldValue(JTextField tf, double minValue, double maxValue, double previous, int length, int precision) {
        return Formatter.checkNumericFieldValue(tf, minValue, maxValue, previous, length, precision, false);
    }

    public static double checkNumericFieldValue(JTextField tf, double minValue, double maxValue, double previous, int length, int precision, boolean cutTail) {
        boolean reset = false;
        String valStr = tf.getText();
        double val = previous;
        try {
            val = Double.parseDouble(valStr);
        }
        catch (NumberFormatException ex) {
            reset = true;
        }
        if (!reset) {
            if (val < minValue) {
                val = previous;
                reset = true;
            } else if (val > maxValue) {
                val = previous;
                reset = true;
            } else {
                int dotPos = valStr.lastIndexOf(46);
                if (dotPos >= 0 && valStr.length() - (dotPos + 1) > precision) {
                    val = Double.parseDouble(valStr.substring(0, dotPos + precision + 1));
                    reset = true;
                }
            }
        }
        if (reset) {
            tf.setText(Formatter.format("%" + length + "." + precision + "f", val));
        }
        if (cutTail) {
            tf.setText(Formatter.cutTail(tf.getText()));
        }
        return val;
    }

    public static String cutTail(String strNumber) {
        int dotPos = (strNumber = strNumber.trim()).lastIndexOf(46);
        if (dotPos >= 0 && dotPos == (strNumber = StrUtil.trimRight(strNumber, '0')).length() - 1) {
            strNumber = dotPos > 1 || dotPos == 1 && strNumber.charAt(0) != '-' && strNumber.charAt(0) != '+' ? strNumber.substring(0, dotPos) : String.valueOf(strNumber) + "0";
        }
        return strNumber;
    }

    public static String bytes2HexStr(byte[] bytes, int start, int length) {
        if (start < 0 || length <= 0 || start + length > bytes.length) {
            throw new IllegalArgumentException("start, length are illegal or inconsistent with length of bytes");
        }
        int end = start + length;
        StringBuilder strBuf = new StringBuilder(2 * length);
        int i = start;
        while (i < end) {
            strBuf.append("0123456789ABCDEF".charAt(bytes[i] >> 4 & 0xF));
            strBuf.append("0123456789ABCDEF".charAt(bytes[i] & 0xF));
            ++i;
        }
        return strBuf.toString();
    }
}

