/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.format;

import edu.uml.lgdc.format.HDF5Utils;
import edu.uml.lgdc.time.TimeScale;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import ncsa.hdf.object.h5.H5CompoundDS;
import ncsa.hdf.object.h5.H5File;
import ncsa.hdf.object.h5.H5Group;

public class GpsTecH5 {
    public static String DATASETNAME_GPS = "Table Layout";

    public static GpsTecInstance[] readLines(String fileName, String datasetName, long start, int count) throws Exception {
        GpsTecInstance[] tec = new GpsTecInstance[count];
        long[] dims = new long[1];
        H5File file = null;
        H5CompoundDS dset = null;
        H5Group grp = null;
        int dataspace_id = -1;
        int dataset_id = -1;
        file = new H5File(fileName, 2);
        file.open();
        grp = (H5Group)file.get(HDF5Utils.ROOT_GROUP);
        dset = (H5CompoundDS)file.get(HDF5Utils.iterateGroupsForDataset(grp, datasetName, true));
        dataset_id = dset.open();
        if (dataset_id >= 0) {
            dataspace_id = H5.H5Dget_space((int)dataset_id);
            if (dataspace_id >= 0) {
                H5.H5Sget_simple_extent_dims((int)dataspace_id, (long[])dims, null);
                if (dims[0] < start || dims[0] < start + (long)count) {
                    System.out.println("Start and/or end index is beyond dataset size.");
                    return null;
                }
                byte[] line = new byte[GpsTecInstance_Datatype.LENGTH * count];
                int memspace_id = H5.H5Screate_simple((int)1, (long[])new long[]{count}, null);
                H5.H5Sselect_hyperslab((int)dataspace_id, (int)HDF5Constants.H5S_SELECT_SET, (long[])new long[]{start}, (long[])new long[]{1L}, (long[])new long[]{count}, (long[])new long[]{1L});
                H5.H5Dread((int)dataset_id, (int)GpsTecInstance_Datatype.MEMTYPE_ID, (int)memspace_id, (int)dataspace_id, (int)HDF5Constants.H5P_DEFAULT, (byte[])line);
                int i = 0;
                while (i < count) {
                    tec[i] = new GpsTecInstance();
                    tec[i].readData(line, i);
                    ++i;
                }
                H5.H5Sclose((int)dataspace_id);
            }
            dset.close(dataset_id);
        }
        file.close();
        return tec;
    }

    private static long[] getCount(String fileName, String datasetName) throws Exception {
        long[] dims = new long[1];
        H5File file = null;
        H5CompoundDS dset = null;
        H5Group grp = null;
        int dataspace_id = -1;
        int dataset_id = -1;
        file = new H5File(fileName, 2);
        file.open();
        grp = (H5Group)file.get(HDF5Utils.ROOT_GROUP);
        dset = (H5CompoundDS)file.get(HDF5Utils.iterateGroupsForDataset(grp, datasetName, true));
        dataset_id = dset.open();
        if (dataset_id >= 0) {
            dataspace_id = H5.H5Dget_space((int)dataset_id);
            if (dataspace_id >= 0) {
                H5.H5Sget_simple_extent_dims((int)dataspace_id, (long[])dims, null);
                H5.H5Sclose((int)dataspace_id);
            }
            dset.close(dataset_id);
        }
        file.close();
        return dims;
    }

    public static long[] parseDataRange(String fileName, String datasetName, TimeScale seekDate) throws Exception {
        long[] dims = GpsTecH5.getCount(fileName, datasetName);
        long[] range = null;
        GpsTecInstance tecInstance = GpsTecH5.readLines(fileName, datasetName, 0L, 1)[0];
        if (tecInstance.year != seekDate.get(1) || tecInstance.month != seekDate.get(2) + 1 || tecInstance.day != seekDate.get(5)) {
            System.out.println("Specified date " + seekDate.toDateUT() + " does not correspond to date range in file " + tecInstance.getDate().toDateUT());
            return new long[2];
        }
        int seekTimeSeconds = seekDate.get(11) * 3600 + seekDate.get(12) * 60 + seekDate.get(13);
        long instancesCount = 0L;
        long lowerLimit = 0L;
        long upperLimit = dims[0] - 1L;
        long middle = 0L;
        int instanceTimeSeconds = -1;
        while (instanceTimeSeconds != seekTimeSeconds && instancesCount != 1L) {
            instancesCount = upperLimit - lowerLimit;
            if (instancesCount != 1L) {
                middle = lowerLimit + instancesCount / 2L;
            } else if (middle == lowerLimit) {
                middle = upperLimit;
            } else if (middle == upperLimit) {
                middle = lowerLimit;
            }
            tecInstance = GpsTecH5.readLines(fileName, datasetName, middle, 1)[0];
            instanceTimeSeconds = tecInstance.getTimeInSeconds();
            if (instanceTimeSeconds < seekTimeSeconds) {
                lowerLimit = middle;
            }
            if (instanceTimeSeconds <= seekTimeSeconds) continue;
            upperLimit = middle;
        }
        if (instanceTimeSeconds != seekTimeSeconds) {
            System.out.println("Cannot find data for time = " + seekDate.toHumanUT() + " exactly.");
            TimeScale foundTime = tecInstance.getDate();
            if (middle == 0L || middle == dims[0] - 1L) {
                seekTimeSeconds = instanceTimeSeconds;
            } else {
                middle = GpsTecH5.findExactly(GpsTecH5.readLines(fileName, datasetName, middle - 1L, 3), middle, seekTimeSeconds);
                tecInstance = GpsTecH5.readLines(fileName, datasetName, middle, 1)[0];
                seekTimeSeconds = tecInstance.getTimeInSeconds();
                foundTime = tecInstance.getDate();
            }
            System.out.println("Data are found for nearest time = " + foundTime.toHumanUT());
        }
        range = GpsTecH5.findBorders(fileName, datasetName, dims, seekTimeSeconds, middle);
        System.out.println("Lines are from " + range[0] + " to " + range[1]);
        return range;
    }

    private static long findExactly(GpsTecInstance[] tecInstance, long ind, int seek_sec) throws Exception {
        if (tecInstance.length != 3) {
            throw new RuntimeException(" Length of tecInstance must be 3 (middle, before and after)");
        }
        int before_sec = -1;
        int after_sec = -1;
        int found_sec = -1;
        before_sec = tecInstance[0].getTimeInSeconds();
        found_sec = tecInstance[1].getTimeInSeconds();
        after_sec = tecInstance[2].getTimeInSeconds();
        if (Math.abs(seek_sec - before_sec) < Math.abs(after_sec - seek_sec)) {
            ind = found_sec == before_sec ? ind : ind - 1L;
            return ind;
        }
        ind = found_sec == after_sec ? ind : ind + 1L;
        return ind;
    }

    private static long[] findBorders(String fileName, String datasetName, long[] dims, int seekTimeSeconds, long middle) throws Exception {
        int instanceTimeSeconds = seekTimeSeconds;
        long upperLimit = middle - 1L;
        int buf_length = 100;
        GpsTecInstance[] buff = null;
        while (instanceTimeSeconds == seekTimeSeconds) {
            if (++upperLimit + 1L > dims[0] - 1L) break;
            if ((upperLimit - middle) % 100L == 0L) {
                int count = upperLimit + 1L + 100L > dims[0] - 1L ? (int)(dims[0] - 1L - upperLimit) : 100;
                buff = GpsTecH5.readLines(fileName, datasetName, upperLimit + 1L, count);
            }
            instanceTimeSeconds = buff[(int)((upperLimit - middle) % 100L)].getTimeInSeconds();
        }
        instanceTimeSeconds = seekTimeSeconds;
        long lowerLimit = middle + 1L;
        while (instanceTimeSeconds == seekTimeSeconds) {
            if (--lowerLimit - 1L < 0L) break;
            if ((middle - lowerLimit) % 100L == 0L) {
                int count = (int)(lowerLimit - 1L - 100L < 0L ? lowerLimit : 100L);
                buff = GpsTecH5.readLines(fileName, datasetName, lowerLimit - (long)count, count);
            }
            instanceTimeSeconds = buff[buff.length - 1 - (int)((middle - lowerLimit) % 100L)].getTimeInSeconds();
        }
        return new long[]{lowerLimit, upperLimit};
    }

    public static boolean isGood(String filenamepath) {
        try {
            return H5.H5Fis_hdf5((String)filenamepath);
        }
        catch (NullPointerException | HDF5LibraryException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static class GpsTecInstance
    implements Externalizable {
        public int year;
        public int month;
        public int day;
        public int hour;
        public int minute;
        public int second;
        public double lat;
        public double lon;
        public double tec;
        public double dTec;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.year = (int)in.readLong();
            this.month = (int)in.readLong();
            this.day = (int)in.readLong();
            this.hour = (int)in.readLong();
            this.minute = (int)in.readLong();
            this.second = (int)in.readLong();
            in.skipBytes(8);
            in.skipBytes(8);
            in.skipBytes(8);
            this.lat = in.readDouble();
            this.lon = in.readDouble();
            this.tec = in.readDouble();
            this.dTec = in.readDouble();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.year);
            out.writeLong(this.month);
            out.writeLong(this.day);
            out.writeLong(this.hour);
            out.writeLong(this.minute);
            out.writeLong(this.second);
            out.writeLong(0L);
            out.writeLong(0L);
            out.writeLong(0L);
            out.writeDouble(this.lat);
            out.writeDouble(this.lon);
            out.writeDouble(this.tec);
            out.writeDouble(this.dTec);
        }

        public void readData(byte[] data, int index) {
            int offset = 6;
            byte[] row = new byte[GpsTecInstance_Datatype.LENGTH + offset];
            int iByte = 0;
            while (iByte < 4) {
                row[iByte] = GpsTecInstance_Datatype.MAGICNUMBERVALUE[iByte];
                ++iByte;
            }
            row[4] = 119;
            row[5] = (byte)GpsTecInstance_Datatype.LENGTH;
            int startByte = index * GpsTecInstance_Datatype.LENGTH;
            int rightByte = startByte + GpsTecInstance_Datatype.LENGTH;
            int iByte2 = startByte;
            while (iByte2 < rightByte) {
                row[offset + iByte2 - startByte] = data[iByte2];
                ++iByte2;
            }
            try {
                ObjectInputStream objectIn = new ObjectInputStream(new ByteArrayInputStream(row));
                this.readExternal(objectIn);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public int getTimeInSeconds() {
            return this.hour * 3600 + this.minute * 60 + this.second;
        }

        public TimeScale getDate() {
            TimeScale time = new TimeScale();
            time.set(1, this.year);
            time.set(2, this.month - 1);
            time.set(5, this.day);
            time.set(11, this.hour);
            time.set(12, this.minute);
            time.set(13, this.second);
            return time;
        }

        public void printout() {
            System.out.println("Year   : " + this.year);
            System.out.println("Day    : " + this.day);
            System.out.println("Hour   : " + this.hour);
            System.out.println("Minute : " + this.minute);
            System.out.println("Second : " + this.second);
            System.out.println("Tec    : " + this.tec);
            System.out.println("dTec   : " + this.dTec);
        }
    }

    public static class GpsTecInstance_Datatype {
        public static final int OBJHEADERSIZE = 2;
        public static final int MAGICNUMBER_LENGTH = 4;
        public static final byte[] MAGICNUMBERVALUE;
        private static final int MEMBERS_NUM = 13;
        private static final int[] MEMBERS_DIM;
        private static final String[] MEMBERS_NAMES;
        private static final int[] MEMBERS_TYPES;
        private static final int[] MEMBERS_SIZES;
        public static final int LENGTH;
        public static final int MEMTYPE_ID;

        static {
            byte[] byArray = new byte[4];
            byArray[0] = -84;
            byArray[1] = -19;
            byArray[3] = 5;
            MAGICNUMBERVALUE = byArray;
            MEMBERS_DIM = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
            MEMBERS_NAMES = new String[]{"year", "month", "day", "hour", "min", "sec", "ut1_unix", "ut2_unix", "recno", "gdlat", "glon", "tec", "dtec"};
            MEMBERS_TYPES = new int[]{HDF5Constants.H5T_STD_I64BE, HDF5Constants.H5T_STD_I64BE, HDF5Constants.H5T_STD_I64BE, HDF5Constants.H5T_STD_I64BE, HDF5Constants.H5T_STD_I64BE, HDF5Constants.H5T_STD_I64BE, HDF5Constants.H5T_STD_I64BE, HDF5Constants.H5T_STD_I64BE, HDF5Constants.H5T_STD_I64BE, HDF5Constants.H5T_IEEE_F64BE, HDF5Constants.H5T_IEEE_F64BE, HDF5Constants.H5T_IEEE_F64BE, HDF5Constants.H5T_IEEE_F64BE};
            MEMBERS_SIZES = new int[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
            LENGTH = GpsTecInstance_Datatype.getDataSize();
            MEMTYPE_ID = GpsTecInstance_Datatype.getTypeID();
            if (MEMTYPE_ID < 0) {
                throw new RuntimeException("Fail to create data type for GPS TEC instance");
            }
            if (LENGTH > 255) {
                throw new RuntimeException("Too long data block");
            }
            if ((byte)LENGTH > LENGTH) {
                throw new RuntimeException("Too long data block");
            }
        }

        private static int getDataSize() {
            int data_size = 0;
            int iMember = 0;
            while (iMember < 13) {
                data_size += MEMBERS_SIZES[iMember] * MEMBERS_DIM[iMember];
                ++iMember;
            }
            return data_size;
        }

        public static int getMemberOffset(int memberItem) {
            int memberOffset = 0;
            int iMember = 0;
            while (iMember < memberItem) {
                memberOffset += MEMBERS_SIZES[iMember];
                ++iMember;
            }
            return memberOffset;
        }

        private static int getTypeID() {
            int memtype_id = -1;
            try {
                memtype_id = H5.H5Tcreate((int)HDF5Constants.H5T_COMPOUND, (int)LENGTH);
                if (memtype_id >= 0) {
                    int indx = 0;
                    while (indx < 13) {
                        int type_id = MEMBERS_TYPES[indx];
                        H5.H5Tinsert((int)memtype_id, (String)MEMBERS_NAMES[indx], (long)GpsTecInstance_Datatype.getMemberOffset(indx), (int)type_id);
                        ++indx;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return memtype_id;
        }
    }
}

