/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.format;

import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.format.IonexGrid;
import edu.uml.lgdc.format.IonexRecordSet;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.time.TimeScale;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.stream.Stream;

public class IonexMap {
    private static final float FORMAT_VERSION = 1.0f;
    private static final String FILE_TYPE = "IONOSPHERE MAPS";
    private static final String DATA_TYPE = "IRI Real Time Asm";
    private static final String DATA_FORMAT_STRING = "yyyy_MM_dd HH:mm";
    private static final int VALUE_LENGTH = 4;
    private static final int NO_VALUE = 9999;
    private static final int MAX_VALUES_PERLINE = 16;
    private static final int INTEGER_DIGITS = 6;
    private static final int FRACTION_DIGITS = 1;
    private static final int GRID_DIGITS = 6;
    private static final String LABEL_VERSION_TYPE = "IONEX VERSION / TYPE";
    private static final String LABEL_SOURCE = "PGM / RUN BY / DATE ";
    private static final String LABEL_DESCRIPTION = "DESCRIPTION         ";
    private static final String LABEL_COMMENT = "COMMENT             ";
    private static final String LABEL_EPOCH_FIRST = "EPOCH OF FIRST MAP  ";
    private static final String LABEL_EPOCH_LAST = "EPOCH OF LAST MAP   ";
    private static final String LABEL_INTERVAL = "INTERVAL            ";
    private static final String LABEL_NUMBERMAPS = "# OF MAPS IN FILE   ";
    private static final String LABEL_MAPPING_FUNC = "MAPPING FUNCTION    ";
    private static final String LABEL_ELEVATION_CUT = "ELEVATION CUTOFF    ";
    private static final String LABEL_OBS_USED = "OBSERVATIONS USED   ";
    public static final String LABEL_NUMBER_SITES = "# OF STATIONS       ";
    private static final String LABEL_NUMBER_SATELL = "# OF SATELLITES     ";
    private static final String LABEL_BASE_RADIUS = "BASE RADIUS         ";
    private static final String LABEL_MAP_DIMENSION = "MAP DIMENSION       ";
    private static final String LABEL_HEIGTH_GRID = "HGT1 / HGT2 / DHGT  ";
    private static final String LABEL_LAT_GRID = "LAT1 / LAT2 / DLAT  ";
    private static final String LABEL_LON_GRID = "LON1 / LON2 / DLON  ";
    static final String LABEL_EXPONENT = "EXPONENT            ";
    private static final String LABEL_END_HEADER = "END OF HEADER       ";
    private static final String LABEL_MAP_EPOCH = "EPOCH OF CURRENT MAP";
    private static final String LABEL_MAP_GRID = "LAT/LON1/LON2/DLON/H";
    private static final String[] headerLabels = new String[]{"IONEX VERSION / TYPE", "PGM / RUN BY / DATE ", "EPOCH OF FIRST MAP  ", "EPOCH OF LAST MAP   ", "INTERVAL            ", "# OF MAPS IN FILE   ", "MAPPING FUNCTION    ", "ELEVATION CUTOFF    ", "OBSERVATIONS USED   ", "# OF STATIONS       ", "# OF SATELLITES     ", "BASE RADIUS         ", "MAP DIMENSION       ", "HGT1 / HGT2 / DHGT  ", "LAT1 / LAT2 / DLAT  ", "LON1 / LON2 / DLON  ", "EXPONENT            ", "END OF HEADER       "};

    public static boolean write(String filename, IonexRecordSet recordSet) {
        if (!recordSet.totalCheck()) {
            return false;
        }
        HashMap<String, String> header = IonexMap.buildHeader(recordSet);
        try {
            PrintWriter writer = new PrintWriter(filename);
            String[] stringArray = headerLabels;
            int n = headerLabels.length;
            int n2 = 0;
            while (n2 < n) {
                String cmnt;
                int n3;
                int n4;
                String[] stringArray2;
                String[] cmnts;
                String key = stringArray[n2];
                writer.write(String.valueOf(header.get(key)) + key + "\n");
                if (recordSet.getComments().containsKey(key)) {
                    stringArray2 = cmnts = IonexMap.divideString(recordSet.getComments().get(key), 60);
                    n4 = cmnts.length;
                    n3 = 0;
                    while (n3 < n4) {
                        cmnt = stringArray2[n3];
                        writer.write(String.valueOf(IonexMap.fill(cmnt, ' ', true, 60)) + LABEL_COMMENT + "\n");
                        ++n3;
                    }
                }
                if (recordSet.getDescriptions().containsKey(key)) {
                    stringArray2 = cmnts = IonexMap.divideString(recordSet.getDescriptions().get(key), 60);
                    n4 = cmnts.length;
                    n3 = 0;
                    while (n3 < n4) {
                        cmnt = stringArray2[n3];
                        writer.write(String.valueOf(IonexMap.fill(cmnt, ' ', true, 60)) + LABEL_DESCRIPTION + "\n");
                        ++n3;
                    }
                }
                ++n2;
            }
            String mapStartLabel = FC.padRight("START OF " + recordSet.getChar().getName().toUpperCase() + " MAP", 20, ' ');
            String mapEndLabel = FC.padRight("END OF " + recordSet.getChar().getName().toUpperCase() + " MAP", 20, ' ');
            double exponentFactor = Math.pow(10.0, -recordSet.getExponent());
            IonexGrid grid = recordSet.getGrid();
            double[] latGrid = grid.getLatitudeTriplet();
            double[] lonGrid = grid.getLongitudeTriplet();
            double[] altGrid = grid.getAltitudeTriplet();
            int iMap = 0;
            while (iMap < recordSet.getTotalMaps()) {
                writer.write(String.valueOf(FC.IntegerToString(iMap + 1, 6)) + FC.nC2S(' ', 54) + mapStartLabel + "\n");
                writer.write(String.valueOf(grid.getTime(iMap).toIonexEpoch()) + LABEL_MAP_EPOCH + "\n");
                double[] map = recordSet.getMap(iMap);
                int iLat = 0;
                while (iLat < grid.getTotalLatitudes()) {
                    writer.write(String.valueOf(FC.nC2S(' ', 2)) + FC.DoubleToString(latGrid[0] + (double)iLat * latGrid[2], 6, 1) + FC.DoubleToString(lonGrid[0], 6, 1) + FC.DoubleToString(lonGrid[1], 6, 1) + FC.DoubleToString(lonGrid[2], 6, 1) + FC.DoubleToString(altGrid[0], 6, 1) + FC.nC2S(' ', 28) + LABEL_MAP_GRID + "\n");
                    int count = 0;
                    int iLon = 0;
                    while (iLon < grid.getTotalLongitudes()) {
                        int val = (int)(map[iLat * grid.getTotalLongitudes() + iLon] * exponentFactor);
                        val = val > 9999 ? 9999 : val;
                        writer.write(" " + FC.IntegerToString(val, 4));
                        if (++count >= 16) {
                            writer.write("\n");
                            count = 0;
                        }
                        ++iLon;
                    }
                    if (count != 0) {
                        writer.write("\n");
                    }
                    ++iLat;
                }
                writer.write(String.valueOf(FC.IntegerToString(iMap + 1, 6)) + FC.nC2S(' ', 54) + mapEndLabel + "\n");
                ++iMap;
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static HashMap<String, String> buildHeader(IonexRecordSet recordSet) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put(LABEL_VERSION_TYPE, String.valueOf(IonexMap.fill(FC.DoubleToString(1.0, 8, 1), ' ', true, 20)) + IonexMap.fill(FILE_TYPE, ' ', true, 20) + IonexMap.fill(DATA_TYPE, ' ', true, 20));
        header.put(LABEL_SOURCE, String.valueOf(IonexMap.fill(recordSet.getSoftwareVersion(), ' ', true, 20)) + IonexMap.fill("SSL UML", ' ', true, 20) + IonexMap.fill(new TimeScale().toFormatUT(DATA_FORMAT_STRING), ' ', true, 20));
        IonexGrid grid = recordSet.getGrid();
        header.put(LABEL_EPOCH_FIRST, grid.getStartTime().toIonexEpoch());
        header.put(LABEL_EPOCH_LAST, grid.getStopTime().toIonexEpoch());
        header.put(LABEL_INTERVAL, String.valueOf(FC.IntegerToString(grid.getCadence_sec(), 6)) + FC.nC2S(' ', 54));
        header.put(LABEL_NUMBERMAPS, String.valueOf(FC.IntegerToString(recordSet.getTotalMaps(), 6)) + FC.nC2S(' ', 54));
        header.put(LABEL_MAPPING_FUNC, String.valueOf(FC.nC2S(' ', 2)) + "NONE" + FC.nC2S(' ', 54));
        header.put(LABEL_ELEVATION_CUT, String.valueOf(FC.DoubleToString(0.0, 8, 1)) + FC.nC2S(' ', 52));
        header.put(LABEL_OBS_USED, IonexMap.fill("GIRO ionosondes measurements of " + recordSet.getChar().getName(), ' ', true, 60));
        header.put(LABEL_NUMBER_SITES, String.valueOf(FC.IntegerToString(recordSet.getTotalSites(), 6)) + FC.nC2S(' ', 54));
        header.put(LABEL_NUMBER_SATELL, String.valueOf(FC.IntegerToString(0, 6)) + FC.nC2S(' ', 54));
        header.put(LABEL_BASE_RADIUS, String.valueOf(FC.IntegerToString((int)(6371.2 + grid.getAltitudeTriplet()[0]), 6)) + FC.nC2S(' ', 54));
        header.put(LABEL_MAP_DIMENSION, String.valueOf(FC.IntegerToString(2, 6)) + FC.nC2S(' ', 54));
        header.put(LABEL_HEIGTH_GRID, IonexMap.gridToString(grid.getAltitudeTriplet()));
        header.put(LABEL_LAT_GRID, IonexMap.gridToString(grid.getLatitudeTriplet()));
        header.put(LABEL_LON_GRID, IonexMap.gridToString(grid.getLongitudeTriplet()));
        header.put(LABEL_EXPONENT, String.valueOf(FC.IntegerToString(recordSet.getExponent(), 6)) + FC.nC2S(' ', 54));
        header.put(LABEL_END_HEADER, FC.nC2S(' ', 60));
        if (header.size() != headerLabels.length) {
            System.out.println("IONEX_EXPORT: Some header lines are missing or unknown lines are inserted.");
        }
        for (String key : header.keySet()) {
            if (header.get(key).length() == 60) continue;
            System.out.println("IONEX_EXPORT: Check length of data for label " + key + " data are " + header.get(key));
        }
        return header;
    }

    private static String gridToString(double[] grid) {
        return String.valueOf(FC.nC2S(' ', 2)) + FC.DoubleToString(grid[0], 6, 1) + FC.DoubleToString(grid[1], 6, 1) + FC.DoubleToString(Math.abs(grid[2]), 6, 1) + FC.nC2S(' ', 40);
    }

    public static String fill(String src, char ch, boolean right, int length) {
        String dst = new String(src);
        if (length <= src.length()) {
            return dst;
        }
        int i = 0;
        while (i < length - src.length()) {
            dst = right ? String.valueOf(dst) + ch : String.valueOf(ch) + dst;
            ++i;
        }
        return dst;
    }

    public static String[] divideString(String src, int size) {
        int length = src.length();
        String[] dst = new String[length / size + 1];
        int i = 0;
        while (i < length / size + 1) {
            int end = (i + 1) * size <= length ? (i + 1) * size : length;
            dst[i] = src.substring(i * size, end);
            ++i;
        }
        return dst;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean read(IonexRecordSet recordSet, String filename) {
        try {
            Throwable throwable = null;
            Object var3_7 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(filename));){
                recordSet.reset();
                if (!IonexMap.readHeader(recordSet, br)) {
                    return false;
                }
                if (IonexMap.readMaps(recordSet, br)) return true;
                return false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static boolean readHeader(IonexRecordSet recordSet, BufferedReader br) throws IOException, ParseException {
        String line;
        TimeScale epochFirst = new TimeScale(0L);
        TimeScale epochLast = new TimeScale(0L);
        int cadence = 0;
        int totalMaps = 0;
        double referenceAltitude_km = 0.0;
        double[] latGrid = new double[3];
        block26: while ((line = br.readLine()) != null) {
            String keyword = FC.padRight(line.substring(60), 20);
            String values = line.substring(0, 59).trim();
            switch (keyword) {
                case "EPOCH OF FIRST MAP  ": {
                    int[] v = Stream.of(values.split("\\s+")).mapToInt(Integer::parseInt).toArray();
                    if (v.length != 6) break;
                    epochFirst.set(v[0], v[1] - 1, v[2], v[3], v[4], v[5]);
                    break;
                }
                case "EPOCH OF LAST MAP   ": {
                    int[] v = Stream.of(values.split("\\s+")).mapToInt(Integer::parseInt).toArray();
                    if (v.length != 6) break;
                    epochLast.set(v[0], v[1] - 1, v[2], v[3], v[4], v[5]);
                    break;
                }
                case "INTERVAL            ": {
                    cadence = NumberFormat.getIntegerInstance().parse(values).intValue();
                    break;
                }
                case "# OF MAPS IN FILE   ": {
                    totalMaps = NumberFormat.getIntegerInstance().parse(values).intValue();
                    break;
                }
                case "# OF STATIONS       ": {
                    int totalSites = NumberFormat.getIntegerInstance().parse(values).intValue();
                    recordSet.setTotalSites(totalSites);
                    break;
                }
                case "MAP DIMENSION       ": {
                    int mapDim = NumberFormat.getIntegerInstance().parse(values).intValue();
                    if (mapDim == 2) break;
                    Console.showError("IONEX Reader: cannot read records that are not 2D maps: dimension=" + mapDim);
                    return false;
                }
                case "HGT1 / HGT2 / DHGT  ": {
                    String[] s = values.split("\\s+");
                    double[] d = Stream.of(values.split("\\s+")).mapToDouble(Double::parseDouble).toArray();
                    if (d.length != 3) break;
                    referenceAltitude_km = d[0];
                    break;
                }
                case "LAT1 / LAT2 / DLAT  ": {
                    latGrid = Stream.of(values.split("\\s+")).mapToDouble(Double::parseDouble).toArray();
                    break;
                }
                case "LON1 / LON2 / DLON  ": {
                    double[] lonGrid = Stream.of(values.split("\\s+")).mapToDouble(Double::parseDouble).toArray();
                    if (latGrid.length != 3 || lonGrid.length != 3) continue block26;
                    if (cadence == 0) {
                        cadence = (int)(epochLast.getTimeInSeconds() - epochFirst.getTimeInSeconds()) / (totalMaps - 1);
                    }
                    recordSet.getGrid().set(latGrid, lonGrid, referenceAltitude_km, epochFirst, epochLast, cadence);
                    if (totalMaps == recordSet.getGrid().getTotalTimes()) break;
                    Console.showError("IONEX Reader: record reports total " + totalMaps + " maps, but time grid has " + recordSet.getGrid().getTotalTimes() + " timestamps");
                    return false;
                }
                case "EXPONENT            ": {
                    int itemp = NumberFormat.getIntegerInstance().parse(values).intValue();
                    recordSet.setExponent(itemp);
                    break;
                }
                case "END OF HEADER       ": {
                    return true;
                }
            }
        }
        Console.showError("IONEX Reader: reached the end of record while parsing the header... no end header found");
        return false;
    }

    private static boolean readMaps(IonexRecordSet recordSet, BufferedReader br) throws IOException, ParseException {
        String line;
        IonexGrid grid = recordSet.getGrid();
        TimeScale currentTime = new TimeScale(0L);
        double[][] maps = new double[grid.getTotalTimes()][grid.getTotalLatitudes() * grid.getTotalLongitudes()];
        double exponentFactor = Math.pow(10.0, recordSet.getExponent());
        while ((line = br.readLine()) != null) {
            String keyword = line.substring(60).trim();
            String values = line.substring(0, 59).trim();
            if (!keyword.startsWith("START OF ")) continue;
            String[] tokens = keyword.split("\\s+");
            switch (tokens[2]) {
                case "FOF2": {
                    recordSet.setCharChoice(CharChoice.FOF2);
                    break;
                }
                case "TEC": {
                    recordSet.setCharChoice(CharChoice.VTEC);
                    break;
                }
                default: {
                    Console.showError("IONEX Reader: record holds unknown characteristic " + tokens[2]);
                    return false;
                }
            }
            int index = NumberFormat.getIntegerInstance().parse(values).intValue() - 1;
            line = br.readLine();
            if (line == null) {
                Console.showError("IONEX Reader: found end of line reading map subheader");
                return false;
            }
            values = line.substring(0, 59).trim();
            int[] v = Stream.of(values.split("\\s+")).mapToInt(Integer::parseInt).toArray();
            if (v.length == 6) {
                v[1] = recordSet.getGrid().getStartTime().get(2) + 1;
                currentTime.set(v[0], v[1] - 1, v[2], v[3], v[4], v[5]);
            }
            if (!currentTime.equals(grid.getTime(index))) {
                Console.showError("IONEX Reader: time mismatch in map subheader: found " + currentTime.toHumanUT() + ", expected " + grid.getTime(index).toHumanUT());
                return false;
            }
            int items = IonexMap.readOneMap(maps[index], br, exponentFactor);
            if (items == grid.getTotalLatitudes() * grid.getTotalLongitudes()) continue;
            Console.showError("IONEX Reader: error reading map at " + currentTime.toHumanUT() + ": only " + items + " elements (truncated?)");
            break;
        }
        recordSet.setMaps(maps);
        return true;
    }

    private static int readOneMap(double[] map, BufferedReader br, double exp) throws IOException {
        String line;
        int counter = 0;
        while ((line = br.readLine()) != null) {
            int[] v;
            String keyword = line.substring(60);
            String values = line.substring(0, 59);
            if (keyword.startsWith("END OF ")) {
                return counter;
            }
            if (keyword.equals(LABEL_MAP_GRID)) {
                double[] d = new double[5];
                int j = 0;
                while (j < 5) {
                    String one = values.substring(2 + j * 6, 2 + (j + 1) * 6);
                    d[j] = FC.StringToDouble(one);
                    ++j;
                }
                continue;
            }
            int[] nArray = v = Stream.of(line.trim().split("\\s+")).mapToInt(Integer::parseInt).toArray();
            int n = v.length;
            int n2 = 0;
            while (n2 < n) {
                int value = nArray[n2];
                if (counter == map.length) {
                    Console.showError("IONEX Reader: too many items found while reading a map: " + counter);
                    return counter;
                }
                map[counter++] = exp * (double)value;
                ++n2;
            }
        }
        Console.showError("IONEX Reader: premature end of record while reading a map; no END OF MAP tag found");
        return counter;
    }
}

