/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.format;

import edu.uml.lgdc.format.IonexGrid;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.geospace.Geomap;
import edu.uml.lgdc.project.Console;
import java.util.HashMap;

public class IonexRecordSet {
    private HashMap<String, String> descriptions = new HashMap();
    private HashMap<String, String> comments = new HashMap();
    private IonexGrid grid = new IonexGrid();
    private int totalMaps = 0;
    private double[][] maps;
    private CharChoice cc;
    private int exponent = Integer.MAX_VALUE;
    private String softwareVersion;
    private int totalSites = 0;

    public void reset() {
        this.exponent = Integer.MAX_VALUE;
        this.grid.reset();
        this.maps = null;
    }

    public boolean setMaps(double[][] maps) {
        this.maps = maps;
        this.totalMaps = maps.length;
        return this.checkMaps();
    }

    public boolean setGambitMaps(Geomap[] gambitMaps) {
        this.totalMaps = gambitMaps.length;
        if (this.totalMaps == 0) {
            Console.showError("IONEX Export: no maps are given for export");
            return false;
        }
        int nLons = gambitMaps[0].getEarthGrid().getNumLongitudeNodes();
        int nLats = gambitMaps[0].getEarthGrid().getNumLatitudeNodes();
        this.maps = new double[this.totalMaps][(nLats - 2) * (nLons + 1)];
        int iMap = 0;
        while (iMap < this.totalMaps) {
            int latCount = 0;
            double[] synthesizedValues = gambitMaps[iMap].getMap_1D();
            int i = 0;
            while (i < synthesizedValues.length - 2 * nLons) {
                if (i > 0 && i % nLons == 0) {
                    this.maps[iMap][i + latCount] = this.maps[iMap][i + latCount - nLons];
                    ++latCount;
                }
                this.maps[iMap][i + latCount] = synthesizedValues[i + nLons];
                ++i;
            }
            ++iMap;
        }
        return true;
    }

    public boolean setCharChoice(CharChoice cc) {
        this.cc = cc;
        switch (cc) {
            case FOF2: {
                this.exponent = -2;
                break;
            }
            case HMF2: 
            case B0: 
            case VTEC: {
                this.exponent = -1;
                break;
            }
            case B1: {
                this.exponent = -3;
                break;
            }
            default: {
                Console.showError("IONEX Formatter: Unknown characteric " + cc.getName());
                return false;
            }
        }
        if (!this.comments.containsKey("EXPONENT            ")) {
            this.comments.put("EXPONENT            ", String.valueOf(cc.getName()) + " values in " + Math.pow(10.0, this.exponent) + cc.getUnits() + " units; 9999 if no value available or overflow.");
        }
        return true;
    }

    public void setDescriptions(HashMap<String, String> descriptions) {
        this.descriptions = descriptions;
    }

    public void setComments(HashMap<String, String> comments) {
        this.comments = comments;
    }

    public void setSoftwareVersion(String version) {
        this.softwareVersion = version;
    }

    public void setTotalSites(int totalSites) {
        this.totalSites = totalSites;
    }

    public void setExponent(int value) {
        this.exponent = value;
    }

    public IonexGrid getGrid() {
        return this.grid;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public int getTotalMaps() {
        return this.totalMaps;
    }

    public double[][] getMaps() {
        return this.maps;
    }

    public double[] getMap(int index) {
        if (this.maps == null || index < 0 || index >= this.maps.length) {
            return null;
        }
        return this.maps[index];
    }

    public CharChoice getChar() {
        return this.cc;
    }

    public int getTotalSites() {
        return this.totalSites;
    }

    public int getExponent() {
        return this.exponent;
    }

    public HashMap<String, String> getComments() {
        return this.comments;
    }

    public HashMap<String, String> getDescriptions() {
        return this.descriptions;
    }

    public boolean totalCheck() {
        if (!this.grid.isGood()) {
            return false;
        }
        return this.checkMaps();
    }

    private boolean checkMaps() {
        if (!this.grid.checkCadence(this.maps)) {
            return false;
        }
        int oneMapSize = this.grid.getTotalLatitudes() * this.grid.getTotalLongitudes();
        double[][] dArray = this.maps;
        int n = this.maps.length;
        int n2 = 0;
        while (n2 < n) {
            double[] data = dArray[n2];
            if (data.length != oneMapSize) {
                System.out.println("IONEX_EXPORT: Grid dimension and number of elements in the map do not correspond each other.");
                return false;
            }
            ++n2;
        }
        return true;
    }
}

