/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.format;

import java.util.ArrayList;
import java.util.Objects;

public final class StrUtil {
    private static final char CR = '\r';
    private static final char LF = '\n';
    public static final String[] INFO_VOLUME_UNITS_NAMES = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"};

    public static int getDigitalPos(String str, int startPos) {
        int pos = str.length();
        int i = startPos;
        while (i < str.length()) {
            if (Character.isDigit(str.charAt(i))) {
                pos = i;
                break;
            }
            ++i;
        }
        return pos;
    }

    public static String[] cutLine(String text) {
        Objects.requireNonNull(text);
        int length = text.length();
        int terminatorStartPos = -1;
        int terminatorEndPos = -1;
        int pos = -1;
        String terminator = "";
        while (++pos < length) {
            char ch = text.charAt(pos);
            if (ch != '\n' && ch != '\r') {
                if (terminatorStartPos < 0) continue;
                break;
            }
            if (terminatorStartPos >= 0) {
                if (ch != '\n') break;
                terminatorEndPos = pos;
                terminator = String.valueOf(terminator) + ch;
                break;
            }
            terminatorStartPos = pos;
            terminator = String.valueOf(terminator) + ch;
            if (ch == '\n') break;
        }
        if (terminatorStartPos >= 0) {
            if (terminatorEndPos < 0) {
                terminatorEndPos = terminatorStartPos;
            }
            return new String[]{text.substring(0, terminatorStartPos), text.substring(terminatorEndPos + 1), terminator};
        }
        return new String[]{text, "", terminator};
    }

    public static String[] textToLines(String text) {
        Objects.requireNonNull(text);
        ArrayList<String> lines = new ArrayList<String>(128);
        while (!text.isEmpty()) {
            String[] result = StrUtil.cutLine(text);
            lines.add(result[0]);
            text = result[1];
        }
        return lines.toArray(new String[lines.size()]);
    }

    public static String[] listToArray(String strList, char delimiter) {
        return StrUtil.listToArray(strList, new String(new char[]{delimiter}));
    }

    public static String[] listToArray(String strList, String delimiter) {
        return StrUtil.listToArray(strList, delimiter, false);
    }

    public static String[] listToArray(String strList, String delimiter, boolean anyCharAsDelimiter) {
        ArrayList<String> list = new ArrayList<String>(64);
        int prevPos = 0;
        int delLength = delimiter.length();
        String element = null;
        if (delLength == 1) {
            anyCharAsDelimiter = false;
        }
        if (anyCharAsDelimiter) {
            delLength = 1;
        }
        if (delimiter.equals(" ")) {
            strList = strList.trim();
        }
        block0: while (prevPos < strList.length()) {
            int nextPos = StrUtil.indexOfDel(strList, delimiter, prevPos, anyCharAsDelimiter);
            if (nextPos == -1) {
                nextPos = strList.length();
            }
            if ((element = strList.substring(prevPos, nextPos).trim()).length() > 0) {
                list.add(element);
            }
            prevPos = nextPos + delLength;
            while (prevPos < strList.length()) {
                if (strList.charAt(prevPos) == ' ') {
                    ++prevPos;
                    continue;
                }
                if (!StrUtil.startWith(strList, delimiter, prevPos, anyCharAsDelimiter)) continue block0;
                prevPos += delLength;
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public static int sniff(String str, String chars, int from) {
        int i = from;
        while (i < str.length()) {
            if (chars.indexOf(str.charAt(i)) >= 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int[] sniffStr(String str, String[] strs, int from) {
        int i = from;
        while (i < str.length()) {
            int j = 0;
            while (j < strs.length) {
                if (str.substring(i).startsWith(strs[j])) {
                    return new int[]{i, i + strs[j].length()};
                }
                ++j;
            }
            ++i;
        }
        return new int[]{str.length(), str.length()};
    }

    public static int sniffOthers(String str, String chars, int from) {
        int i = from;
        while (i < str.length()) {
            if (chars.indexOf(str.charAt(i)) < 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int indexOfDel(String str, String delimiters, int from, boolean anyCharAsDelimiter) {
        if (!anyCharAsDelimiter) {
            return str.indexOf(delimiters, from);
        }
        return StrUtil.sniff(str, delimiters, from);
    }

    private static boolean startWith(String str, String compare, int from, boolean anyCharFromCompare) {
        if (!anyCharFromCompare) {
            return str.startsWith(compare, from);
        }
        return compare.indexOf(str.charAt(from)) >= 0;
    }

    public static int countChar(String strList, char c) {
        int count = 0;
        int prevPos = 0;
        int nextPos = 0;
        while (nextPos >= 0) {
            nextPos = strList.indexOf(c, prevPos);
            if (nextPos >= 0) {
                ++count;
            }
            prevPos = nextPos + 1;
        }
        return count;
    }

    public static String trimLeft(String str) {
        return StrUtil.trimLeft(str, ' ');
    }

    public static String trimLeft(String str, char trimChar) {
        String leftTrimmed = "";
        int pos = -1;
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) != trimChar) {
                pos = i;
                break;
            }
            ++i;
        }
        if (pos > 0) {
            leftTrimmed = str.substring(pos);
        } else if (pos == 0) {
            leftTrimmed = str;
        }
        return leftTrimmed;
    }

    public static String trimRight(String str) {
        return StrUtil.trimRight(str, ' ');
    }

    public static String trimRight(String str, char trimChar) {
        String rightTrimmed = "";
        int pos = -1;
        int i = str.length() - 1;
        while (i >= 0) {
            if (str.charAt(i) != trimChar) {
                pos = i;
                break;
            }
            --i;
        }
        if (pos >= 0) {
            rightTrimmed = pos < str.length() - 1 ? str.substring(0, pos + 1) : str;
        }
        return rightTrimmed;
    }

    public static boolean isOnlyDigits(String str) {
        return StrUtil.isOnlyDigits(str, false);
    }

    public static boolean isOnlyDigits(String str, boolean ignoreLeadingBlanks) {
        if (ignoreLeadingBlanks) {
            str = StrUtil.trimLeft(str);
        }
        int i = 0;
        while (i < str.length()) {
            if (!Character.isDigit(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isOnlyLetters(String str) {
        return StrUtil.isOnlyLetters(str, false);
    }

    public static boolean isOnlyLetters(String str, boolean ignoreLeadingBlanks) {
        if (ignoreLeadingBlanks) {
            str = StrUtil.trimLeft(str);
        }
        int i = 0;
        while (i < str.length()) {
            if (!Character.isLetter(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isOnlyLettersOrDigits(String str) {
        return StrUtil.isOnlyLettersOrDigits(str, false);
    }

    public static boolean isOnlyLettersOrDigits(String str, boolean ignoreLeadingBlanks) {
        if (ignoreLeadingBlanks) {
            str = StrUtil.trimLeft(str);
        }
        int i = 0;
        while (i < str.length()) {
            if (!Character.isLetterOrDigit(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isIntegerNumber(String str) {
        return StrUtil.isIntegerNumber(str, false);
    }

    public static boolean isIntegerNumber(String str, boolean leadingBlanksAdmitted) {
        boolean ok = true;
        boolean digitEncountered = false;
        boolean signEncountered = false;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (!Character.isDigit(c)) {
                if (c == ' ') {
                    if (!leadingBlanksAdmitted || signEncountered || digitEncountered) {
                        ok = false;
                    }
                } else if (c == '-' || c == '+') {
                    if (!signEncountered && !digitEncountered) {
                        signEncountered = true;
                    } else {
                        ok = false;
                    }
                } else {
                    ok = false;
                }
            } else {
                digitEncountered = true;
            }
            if (!ok) break;
            ++i;
        }
        if (!digitEncountered) {
            ok = false;
        }
        return ok;
    }

    public static boolean isFloatingPointNumber(String str) {
        return StrUtil.isFloatingPointNumber(str, false);
    }

    public static boolean isFloatingPointNumber(String str, boolean leadingBlanksAdmitted) {
        boolean ok = true;
        boolean digitEncountered = false;
        boolean signEncountered = false;
        boolean pointEncountered = false;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (!Character.isDigit(c)) {
                if (c == ' ') {
                    if (!leadingBlanksAdmitted || signEncountered || pointEncountered || digitEncountered) {
                        ok = false;
                    }
                } else if (c == '-' || c == '+') {
                    if (!(signEncountered || digitEncountered || pointEncountered)) {
                        signEncountered = true;
                    } else {
                        ok = false;
                    }
                } else if (c == '.') {
                    if (!pointEncountered) {
                        pointEncountered = true;
                    } else {
                        ok = false;
                    }
                } else {
                    ok = false;
                }
            } else {
                digitEncountered = true;
            }
            if (!ok) break;
            ++i;
        }
        if (!digitEncountered) {
            ok = false;
        }
        return ok;
    }

    public static boolean isFloating(String str) {
        try {
            Double.valueOf(str).doubleValue();
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isOnlyDigits(byte[] array, int start, int length) {
        boolean ok = true;
        int i = start;
        while (i < start + length) {
            if (array[i] < 0 || array[i] > 9) {
                ok = false;
                break;
            }
            ++i;
        }
        return ok;
    }

    public static boolean isOnlyBCD(byte[] array, int firstNibleOffset, int qtyOfNimbles) {
        boolean ok = true;
        boolean upper = firstNibleOffset % 2 == 0;
        int i = 0;
        while (i < qtyOfNimbles) {
            byte val = upper ? (byte)(array[firstNibleOffset / 2] >> 4) : array[firstNibleOffset / 2];
            if ((val = (byte)(val & 0xF)) > 9) {
                ok = false;
                break;
            }
            upper = !upper;
            ++firstNibleOffset;
            ++i;
        }
        return ok;
    }

    public static boolean isOnlyHexDigits(String str) {
        return StrUtil.consistOf(str.toUpperCase(), "0123456789ABCDEF");
    }

    public static boolean isOnlyHexDigits(byte[] array, int start, int length) {
        boolean ok = true;
        int i = start;
        while (i < start + length) {
            if (array[i] < 0 || array[i] > 15) {
                ok = false;
                break;
            }
            ++i;
        }
        return ok;
    }

    public static boolean consistOf(String str, String legalSymbols) {
        boolean result = true;
        int i = 0;
        while (i < str.length()) {
            if (legalSymbols.indexOf(str.charAt(i)) < 0) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    public static String repeat(char c, int count) {
        StringBuilder sb = new StringBuilder(count);
        int i = 0;
        while (i < count) {
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static String toTriplets(long value) {
        long posValue = Math.abs(value);
        if (posValue > 0L) {
            String resultStr = "" + posValue % 1000L;
            posValue /= 1000L;
            int length = 3;
            while (posValue > 0L) {
                if (resultStr.length() < length) {
                    resultStr = String.valueOf(StrUtil.repeat('0', length - resultStr.length())) + resultStr;
                }
                resultStr = posValue % 1000L + "," + resultStr;
                posValue /= 1000L;
                length += 4;
            }
            if (value < 0L) {
                resultStr = "-" + resultStr;
            }
            return resultStr;
        }
        return "0";
    }

    public static String quote(String str) {
        return "\"" + str + "\"";
    }

    public static String secondsToStr(int seconds, boolean fullUnitsName) {
        int min = seconds / 60;
        int sec = seconds % 60;
        String str = "";
        if (fullUnitsName && (min <= 0 || sec <= 0)) {
            if (min == 0) {
                str = sec > 1 ? String.valueOf(sec) + " seconds" : String.valueOf(sec) + " second";
            } else {
                str = min > 1 ? String.valueOf(min) + " minutes" : String.valueOf(min) + " minute";
                if (sec > 0) {
                    str = sec > 1 ? String.valueOf(str) + " " + sec + " seconds" : String.valueOf(str) + " " + sec + " second";
                }
            }
        } else {
            String secName;
            String minName = fullUnitsName ? " min" : "m";
            String string = secName = fullUnitsName ? " sec" : "s";
            if (min > 0) {
                str = String.valueOf(min) + minName;
                if (sec > 0) {
                    str = String.valueOf(str) + " " + sec + secName;
                }
            } else {
                str = String.valueOf(sec) + secName;
            }
        }
        return str;
    }

    public static String getInfoVolSizeAsStr(long numberOfBytes) {
        long volume = numberOfBytes;
        int i = 0;
        while (i < INFO_VOLUME_UNITS_NAMES.length) {
            long volumeInNextUnits = volume / 1024L;
            if (volumeInNextUnits <= 999L) break;
            volume = volumeInNextUnits;
            ++i;
        }
        if (volume == 0L) {
            volume = 0L;
        }
        return String.valueOf(StrUtil.toTriplets(volume)) + " " + INFO_VOLUME_UNITS_NAMES[i];
    }

    public static String padLeftNBSP(String str, int width) {
        int strLen = str.length();
        if (strLen >= width) {
            return str.substring(strLen - width);
        }
        String spaces = "";
        int i = 0;
        while (i < width - strLen) {
            spaces = String.valueOf(spaces) + "&nbsp;";
            ++i;
        }
        return String.valueOf(spaces) + str;
    }

    public static boolean isBlankOrNull(String string) {
        if (string == null) {
            return true;
        }
        return string == "";
    }

    public static boolean isEndOfLineChar(char c) {
        return c == '\r' || c == '\n';
    }

    public static boolean isEndOfLineChar(int c) {
        return c == 13 || c == 10;
    }
}

