/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.ftp;

import edu.uml.lgdc.ftp.Assert;
import edu.uml.lgdc.ftp.FtpProtocolConstants;
import edu.uml.lgdc.ftp.FtpProtocolException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public abstract class FtpDataTransferProcess
implements FtpProtocolConstants {
    private Socket socket;
    private boolean isUsingStreamMode = true;
    private char representationType;
    private Transfer transfer;
    private int numberOfBytesPerProgessNotification = 8192;
    private int dataTransferBufferSize = 4096;
    private int soTimeout = -1;
    private boolean isStop;
    private byte BLOCKMODEDESCRIPTOR_EOR = (byte)-128;
    private byte BLOCKMODEDESCRIPTOR_EOF = (byte)64;
    private byte BLOCKMODEDESCRIPTOR_SUSPECTED_ERROR = (byte)32;
    private byte BLOCKMODEDESCRIPTOR_RESTART_MARKER = (byte)16;

    public FtpDataTransferProcess() {
        this.representationType = (char)65;
        this.transfer = new StreamModeTransfer();
    }

    public final void setSocket(Socket socket) throws SocketException {
        Assert.pre(socket != null, "socket != null");
        Assert.pre(this.socket == null, "this.socket == null");
        this.socket = socket;
        if (this.soTimeout != -1) {
            Assert.check(this.soTimeout > 0, "soTimeout > 0");
            socket.setSoTimeout(this.soTimeout);
        }
    }

    public final int getTimeout(int timeout) throws SocketException {
        Assert.check(this.socket != null);
        return this.socket.getSoTimeout();
    }

    public final void setTimeout(int timeout) throws SocketException {
        this.soTimeout = timeout;
        if (this.socket != null) {
            this.socket.setSoTimeout(this.soTimeout);
        }
    }

    public final int getTimeout() {
        return this.soTimeout;
    }

    public final void closeSocket() throws IOException {
        Assert.pre(this.socket != null, "socket != null");
        this.socket.close();
        this.socket = null;
    }

    public final boolean isSocketOpen() {
        return this.socket != null;
    }

    public final boolean isStreamMode() {
        return this.isUsingStreamMode;
    }

    public final char getTransferMode() {
        return this.isUsingStreamMode ? (char)'S' : 'B';
    }

    public final char getRepresentationType() {
        return this.representationType;
    }

    public abstract void connect() throws IOException;

    public abstract void disconnect() throws IOException;

    protected abstract void progressListener(int var1);

    public final void setNumberOfBytesPerProgessNotification(int numberOfBytes) {
        Assert.pre(numberOfBytes > 10 && numberOfBytes < 0x100000, "numberOfBytes > 10 &&  numberOfBytes < 1024 * 1024");
        this.numberOfBytesPerProgessNotification = numberOfBytes;
    }

    public final int getNumberOfBytesPerProgessNotification() {
        return this.numberOfBytesPerProgessNotification;
    }

    public final void setDataTransferBufferSize(int numberOfBytes) {
        Assert.pre(numberOfBytes > 10 && numberOfBytes < 0x100000, "numberOfBytes > 10 && numberOfBytes < 1024 * 1024");
        this.dataTransferBufferSize = numberOfBytes;
    }

    public final int getDataTransferBufferSize() {
        return this.dataTransferBufferSize;
    }

    private String readLine(BufferedReader in) throws IOException {
        String str = null;
        int repeatCount = 0;
        while (repeatCount < 11) {
            try {
                str = in.readLine();
                break;
            }
            catch (InterruptedIOException e) {
                ++repeatCount;
            }
        }
        if (repeatCount == 11) {
            throw new IOException("Reached maximum attempts (10) after I/O interrupts");
        }
        return str;
    }

    private int read(InputStream in, byte[] buffer) throws IOException {
        return this.read(in, buffer, 0, buffer.length);
    }

    private int read(InputStream in, byte[] buffer, int offset, int len) throws IOException {
        int bytesRead = 0;
        int repeatCount = 0;
        while (repeatCount < 11) {
            try {
                bytesRead = in.read(buffer, offset, len);
                break;
            }
            catch (InterruptedIOException e) {
                ++repeatCount;
            }
        }
        if (repeatCount == 11) {
            throw new IOException("Reached maximum attempts (10) after I/O interrupts");
        }
        return bytesRead;
    }

    public int upload(InputStream in) throws IOException, InterruptedException {
        Assert.pre(in != null, "in != null");
        if (this.representationType == 'I') {
            return this.transfer.uploadBinary(in);
        }
        Assert.check(this.representationType == 'A');
        return this.transfer.uploadAscii(in);
    }

    public int download(OutputStream out) throws IOException, InterruptedException {
        Assert.pre(out != null);
        if (this.representationType == 'I') {
            return this.transfer.downloadBinary(out);
        }
        Assert.check(this.representationType == 'A');
        return this.transfer.downloadAscii(out);
    }

    public DirectoryListingEnumeration createDirectoryListingEnumeration() throws IOException {
        return this.transfer.createDirectoryListingEnumeration();
    }

    public void interruptTransfer() {
        this.isStop = true;
    }

    public void setTransferMode(char transferMode) throws UnsupportedTransferModeException, BadTransferModeException {
        if (transferMode == 'S') {
            this.transfer = new StreamModeTransfer();
            this.isUsingStreamMode = true;
        } else if (transferMode == 'B') {
            this.transfer = new BlockModeTransfer();
            this.isUsingStreamMode = false;
        } else {
            if (transferMode == 'C') {
                throw new UnsupportedTransferModeException("Cis unsupported");
            }
            throw new BadTransferModeException("'" + transferMode + "' " + "is not a valid trasfer mode");
        }
    }

    public void setRepresentationType(char type) throws BadRepresentationTypeException, UnsupportedRepresentationTypeException {
        switch (type) {
            case 'A': 
            case 'I': {
                this.representationType = type;
                break;
            }
            case 'E': 
            case 'L': {
                throw new UnsupportedRepresentationTypeException("'" + type + "' " + "is not supported");
            }
            default: {
                throw new BadRepresentationTypeException("'" + type + "' " + "is not a valid representation type");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final int parsePortArgument(String argument, StringBuffer hostAddress) throws FtpProtocolException {
        Assert.pre(hostAddress.length() == 0);
        int index = 0;
        int countComma = 0;
        index = 0;
        while (index < argument.length()) {
            char ch = argument.charAt(index);
            if (ch == ',') {
                if (++countComma == 4) break;
                hostAddress.append('.');
            } else {
                if (!Character.isDigit(ch)) throw new FtpProtocolException(501, "bad character '" + ch + "' in " + "host address part of " + "parsePortArgument(" + argument + ")");
                hostAddress.append(ch);
            }
            ++index;
        }
        Assert.check(countComma == 4);
        int port = 0;
        StringBuffer PortByte = new StringBuffer(10);
        Assert.check(argument.charAt(index) == ',');
        ++index;
        while (index < argument.length()) {
            char ch = argument.charAt(index);
            if (ch == ',') {
                int n = ++countComma;
                ++countComma;
                if (n != 5) throw new FtpProtocolException(501, "Too ma ny ',' in parsePortArgument(" + argument + ")");
                port = Integer.parseInt(PortByte.toString());
                PortByte.setLength(0);
            } else {
                if (!Character.isDigit(ch)) throw new FtpProtocolException(501, "bad character '" + ch + "' " + "in port part of " + "parsePortArgument(" + argument + ")");
                PortByte.append(ch);
            }
            ++index;
        }
        Assert.post(argument.length() == index);
        return port * 256 + Integer.parseInt(PortByte.toString());
    }

    public static final String getDataPortArgument(ServerSocket serverSocket) throws UnknownHostException {
        StringBuffer argument = new StringBuffer(24);
        argument.append(InetAddress.getLocalHost().getHostAddress());
        int i = 0;
        while (i < argument.length()) {
            if (argument.charAt(i) == '.') {
                argument.setCharAt(i, ',');
            }
            ++i;
        }
        int port = serverSocket.getLocalPort();
        argument.append(',');
        argument.append(port / 256);
        argument.append(',');
        argument.append(port % 256);
        return new String(argument);
    }

    public class BadRepresentationTypeException
    extends FtpProtocolException {
        private static final long serialVersionUID = 1L;

        BadRepresentationTypeException(String message) {
            super(501, message);
        }
    }

    public class BadTransferModeException
    extends FtpProtocolException {
        private static final long serialVersionUID = 1L;

        BadTransferModeException(String message) {
            super(501, message);
        }
    }

    private class BlockModeTransfer
    extends Transfer {
        private BlockModeTransfer() {
        }

        @Override
        public int downloadBinary(OutputStream out) throws IOException, InterruptedException {
            Assert.pre(FtpDataTransferProcess.this.socket != null, "socket != null");
            InputStream in = FtpDataTransferProcess.this.socket.getInputStream();
            int bytesTransferred = 0;
            int bytesOfProgressSignaled = 0;
            byte[] blockHeader = new byte[3];
            byte[] buffer = new byte[FtpDataTransferProcess.this.dataTransferBufferSize];
            FtpDataTransferProcess.this.isStop = false;
            while (true) {
                int bytesRead;
                if ((bytesRead = FtpDataTransferProcess.this.read(in, blockHeader)) != 3) {
                    throw new IOException("Block Transfer Header is " + bytesRead + " bytes, but should be 3");
                }
                if (blockHeader[0] == 64) break;
                int bytesRemain = blockHeader[1] << 8 | blockHeader[2] & 0xFF;
                do {
                    bytesRead = FtpDataTransferProcess.this.read(in, buffer, 0, bytesRemain < buffer.length ? bytesRemain : buffer.length);
                    Assert.check(bytesRead > 0, "bytesRead > 0");
                    out.write(buffer, 0, bytesRead);
                    if ((bytesTransferred += bytesRead) - bytesOfProgressSignaled > FtpDataTransferProcess.this.numberOfBytesPerProgessNotification) {
                        FtpDataTransferProcess.this.progressListener(bytesTransferred);
                        bytesOfProgressSignaled = bytesTransferred;
                    }
                    bytesRemain -= bytesRead;
                    if (!FtpDataTransferProcess.this.isStop) continue;
                    throw new InterruptedException("User interrupt");
                } while (bytesRemain > 0);
            }
            FtpDataTransferProcess.this.progressListener(bytesTransferred);
            return bytesTransferred;
        }

        @Override
        public int uploadBinary(InputStream in) throws IOException, InterruptedException {
            byte[] buffer;
            int bytesTransferred;
            OutputStream out;
            block1: {
                Assert.pre(FtpDataTransferProcess.this.socket != null, "socket != null");
                out = FtpDataTransferProcess.this.socket.getOutputStream();
                bytesTransferred = 0;
                int bytesOfProgressSignaled = 0;
                buffer = new byte[FtpDataTransferProcess.this.dataTransferBufferSize + 3];
                buffer[0] = 0;
                FtpDataTransferProcess.this.isStop = false;
                do {
                    int bytesRead;
                    if ((bytesRead = in.read(buffer, 3, FtpDataTransferProcess.this.dataTransferBufferSize)) == -1) break block1;
                    Assert.check(bytesRead > 0, "bytesRead > 0");
                    Assert.check(buffer[0] == 0, "buffer[ 0 ] == 0");
                    buffer[1] = (byte)(bytesRead >> 8);
                    buffer[2] = (byte)bytesRead;
                    out.write(buffer, 0, bytesRead + 3);
                    if ((bytesTransferred += bytesRead) - bytesOfProgressSignaled <= FtpDataTransferProcess.this.numberOfBytesPerProgessNotification) continue;
                    FtpDataTransferProcess.this.progressListener(bytesTransferred);
                    bytesOfProgressSignaled = bytesTransferred;
                } while (!FtpDataTransferProcess.this.isStop);
                throw new InterruptedException("User interrupt");
            }
            buffer[0] = 64;
            buffer[1] = 0;
            buffer[2] = 0;
            out.write(buffer, 0, 3);
            FtpDataTransferProcess.this.progressListener(bytesTransferred);
            return bytesTransferred;
        }

        @Override
        public DirectoryListingEnumeration createDirectoryListingEnumeration() throws IOException {
            Assert.pre(FtpDataTransferProcess.this.socket != null, "socket != null");
            int BUFFERSIZE = 1024;
            InputStream in = FtpDataTransferProcess.this.socket.getInputStream();
            int bytesTransferred = 0;
            byte[] blockHeader = new byte[3];
            byte[] buffer = new byte[1024];
            int spaceLeftInBuffer = buffer.length;
            while (true) {
                int bytesRead;
                if ((bytesRead = in.read(blockHeader)) != 3) {
                    throw new IOException("Block Transfer Header is " + bytesRead + " byte(s), but should be 3");
                }
                if (blockHeader[0] == 64) break;
                int bytesRemainInBlock = blockHeader[1] << 8 | blockHeader[2] & 0xFF;
                Assert.check(spaceLeftInBuffer + bytesTransferred == buffer.length, "spaceLeftInBuffer+bytesTransferred == buffer.length");
                if (bytesRemainInBlock > spaceLeftInBuffer) {
                    byte[] oldBuffer = buffer;
                    buffer = new byte[oldBuffer.length + bytesRemainInBlock * 3];
                    System.arraycopy(oldBuffer, 0, buffer, 0, bytesTransferred);
                    spaceLeftInBuffer += bytesRemainInBlock * 3;
                }
                Assert.check(bytesRemainInBlock < spaceLeftInBuffer, "bytesRemainInBlock < spaceLeftInBuffer");
                spaceLeftInBuffer -= bytesRemainInBlock;
                do {
                    Assert.check((bytesRead = in.read(buffer, bytesTransferred, bytesRemainInBlock)) > 0, "bytesRead > 0");
                    bytesTransferred += bytesRead;
                } while ((bytesRemainInBlock -= bytesRead) > 0);
            }
            return this.createDirectoryListingEnumeration(new ByteArrayInputStream(buffer, 0, bytesTransferred));
        }
    }

    private static class CrLfTranslationInputStream
    extends InputStream {
        private BufferedInputStream in;
        private int cachedByte;
        private static final int CR = 13;
        private static final int LF = 10;

        public CrLfTranslationInputStream(InputStream in) {
            this.in = in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
            this.cachedByte = -1;
        }

        @Override
        public final int read() throws IOException {
            if (this.cachedByte != -1) {
                int oldCachedByte = this.cachedByte;
                this.cachedByte = -1;
                System.out.println("cachedByte: " + oldCachedByte);
                return oldCachedByte;
            }
            int oneByte = this.in.read();
            if (oneByte == 10) {
                this.cachedByte = 10;
                return 13;
            }
            if (oneByte == 13) {
                this.cachedByte = this.in.read();
                return 13;
            }
            return oneByte;
        }

        @Override
        public int read(byte[] buffer, int off, int len) throws IOException {
            int endIndex = off + len;
            int index = off;
            while (index < endIndex) {
                int oneByte = this.read();
                if (oneByte == -1) {
                    if (index != off) break;
                    return -1;
                }
                buffer[index++] = (byte)oneByte;
                System.out.println(String.valueOf(index) + " " + oneByte);
            }
            Assert.post(index - off > 0, "(index - off) > 0");
            return index - off;
        }
    }

    private static class CrLfTranslationOutputStream
    extends OutputStream {
        private BufferedOutputStream out;
        static final int CR = 13;

        public CrLfTranslationOutputStream(OutputStream out) {
            this.out = out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out);
        }

        @Override
        public void write(int oneByte) throws IOException {
            if (oneByte != 13) {
                this.out.write(oneByte);
            }
        }

        @Override
        public void write(byte[] buffer, int off, int len) throws IOException {
            int endIndex = off + len;
            while (off < endIndex) {
                if (buffer[off] != 13) {
                    this.out.write(buffer[off]);
                }
                ++off;
            }
            this.out.flush();
        }
    }

    public static interface DirectoryListingEnumeration {
        public boolean hasMoreElements() throws IOException;

        public String nextElement() throws IOException;
    }

    private class StreamModeTransfer
    extends Transfer {
        private StreamModeTransfer() {
        }

        @Override
        public int downloadBinary(OutputStream out) throws IOException, InterruptedException {
            Assert.pre(FtpDataTransferProcess.this.socket != null, "socket != null");
            InputStream in = FtpDataTransferProcess.this.socket.getInputStream();
            int bytesTransferred = 0;
            int bytesOfProgressSignaled = 0;
            byte[] buffer = new byte[FtpDataTransferProcess.this.dataTransferBufferSize];
            FtpDataTransferProcess.this.isStop = false;
            try {
                int bytesRead;
                while ((bytesRead = FtpDataTransferProcess.this.read(in, buffer)) != -1) {
                    if (bytesRead == 0) continue;
                    Assert.check(bytesRead > 0, "bytesRead(" + bytesRead + ") <= 0");
                    out.write(buffer, 0, bytesRead);
                    if ((bytesTransferred += bytesRead) - bytesOfProgressSignaled > FtpDataTransferProcess.this.numberOfBytesPerProgessNotification) {
                        FtpDataTransferProcess.this.progressListener(bytesTransferred);
                        bytesOfProgressSignaled = bytesTransferred;
                    }
                    if (!FtpDataTransferProcess.this.isStop) continue;
                    throw new InterruptedException("User interrupt");
                }
                FtpDataTransferProcess.this.progressListener(bytesTransferred);
            }
            finally {
                in.close();
                in = null;
            }
            return bytesTransferred;
        }

        @Override
        public int uploadBinary(InputStream in) throws IOException, InterruptedException {
            Assert.pre(FtpDataTransferProcess.this.socket != null, "socket != null");
            OutputStream out = FtpDataTransferProcess.this.socket.getOutputStream();
            Assert.check(out != null);
            int bytesTransferred = 0;
            int bytesOfProgressSignaled = 0;
            byte[] buffer = new byte[FtpDataTransferProcess.this.dataTransferBufferSize];
            FtpDataTransferProcess.this.isStop = false;
            try {
                int bytesRead;
                while ((bytesRead = in.read(buffer)) != -1) {
                    Assert.check(bytesRead > 0, "bytesRead(" + bytesRead + ") <= 0");
                    out.write(buffer, 0, bytesRead);
                    if ((bytesTransferred += bytesRead) - bytesOfProgressSignaled > FtpDataTransferProcess.this.numberOfBytesPerProgessNotification) {
                        FtpDataTransferProcess.this.progressListener(bytesTransferred);
                        bytesOfProgressSignaled = bytesTransferred;
                    }
                    if (!FtpDataTransferProcess.this.isStop) continue;
                    throw new InterruptedException("User interrupt");
                }
                FtpDataTransferProcess.this.progressListener(bytesTransferred);
            }
            catch (Throwable throwable) {
                Assert.check(out != null);
                out.close();
                out = null;
                throw throwable;
            }
            Assert.check(out != null);
            out.close();
            out = null;
            return bytesTransferred;
        }

        @Override
        public DirectoryListingEnumeration createDirectoryListingEnumeration() throws IOException {
            return this.createDirectoryListingEnumeration(FtpDataTransferProcess.this.socket.getInputStream());
        }
    }

    private abstract class Transfer {
        private Transfer() {
        }

        public abstract int downloadBinary(OutputStream var1) throws IOException, InterruptedException;

        public abstract int uploadBinary(InputStream var1) throws IOException, InterruptedException;

        public int downloadAscii(OutputStream out) throws IOException, InterruptedException {
            if ('/' == File.separatorChar) {
                return this.downloadBinary(new CrLfTranslationOutputStream(out));
            }
            return this.downloadBinary(out);
        }

        public int uploadAscii(InputStream in) throws IOException, InterruptedException {
            return this.uploadBinary(new CrLfTranslationInputStream(in));
        }

        public abstract DirectoryListingEnumeration createDirectoryListingEnumeration() throws IOException;

        protected DirectoryListingEnumeration createDirectoryListingEnumeration(InputStream inputStream) throws IOException {
            BufferedReader in;
            try {
                in = new BufferedReader(new InputStreamReader(inputStream, "ASCII"));
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("UnsupportedEncodingException: " + e.getMessage());
                in = new BufferedReader(new InputStreamReader(inputStream));
            }
            BufferedReader reader = in;
            return new DirectoryListingEnumeration(reader){
                String nextLine = null;
                private BufferedReader in;
                boolean eol;
                String temp;
                {
                    this.in = bufferedReader;
                    this.eol = false;
                }

                @Override
                public boolean hasMoreElements() throws IOException {
                    if (this.eol) {
                        return false;
                    }
                    if (this.nextLine == null) {
                        boolean bl = this.eol = !this.readNextLine();
                    }
                    return !this.eol && this.nextLine != null;
                }

                @Override
                public String nextElement() throws IOException {
                    if (!this.eol && this.nextLine == null) {
                        boolean bl = this.eol = !this.readNextLine();
                    }
                    if (!this.eol) {
                        this.temp = this.nextLine;
                        this.nextLine = null;
                        return this.temp;
                    }
                    return null;
                }

                private boolean readNextLine() throws IOException {
                    this.nextLine = FtpDataTransferProcess.this.readLine(this.in);
                    if (this.nextLine != null) {
                        return true;
                    }
                    this.in.close();
                    this.in = null;
                    return false;
                }
            };
        }
    }

    public class UnsupportedRepresentationTypeException
    extends FtpProtocolException {
        private static final long serialVersionUID = 1L;

        UnsupportedRepresentationTypeException(String message) {
            super(504, message);
        }
    }

    public class UnsupportedTransferModeException
    extends FtpProtocolException {
        private static final long serialVersionUID = 1L;

        UnsupportedTransferModeException(String message) {
            super(504, message);
        }
    }
}

