/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.math.ExtMath;

public class Azimuth {
    private double cwAzimuth_deg;
    private double normCWazimuth_deg;
    private boolean calculated;

    public void calc(double lat1, double long1, double lat2, double long2) {
        if (Math.abs(lat1) > 90.0 || Math.abs(lat2) > 90.0) {
            throw new IllegalArgumentException("Azimuth: latitude is greater than 90 deg");
        }
        if (lat1 == -lat2 && (long1 - long2) % 180.0 == 0.0) {
            throw new IllegalArgumentException("Azimuth: two points are antipodes");
        }
        if (lat1 == lat2 && (long1 - long2) % 360.0 == 0.0) {
            throw new IllegalArgumentException("Azimuth: Coordinates are the same");
        }
        if (Math.abs(lat1) == 90.0) {
            long1 = long2;
        }
        if (Math.abs(lat2) == 90.0) {
            long2 = long1;
        }
        long1 = Math.toRadians(long1);
        long2 = Math.toRadians(long2);
        lat1 = Math.toRadians(lat1);
        lat2 = Math.toRadians(lat2);
        this.calcIt1(lat1, long1, lat2, long2);
        this.calculated = true;
    }

    private void calcIt1(double lat1, double long1, double lat2, double long2) {
        double cos_1x2 = Math.cos(long2 - long1) * Math.cos(lat1) * Math.cos(lat2) + Math.sin(lat1) * Math.sin(lat2);
        double angle_1x2 = Math.acos(cos_1x2);
        this.cwAzimuth_deg = Math.acos((Math.sin(lat2) - Math.sin(lat1) * cos_1x2) / (Math.cos(lat1) * Math.sin(angle_1x2)));
        this.cwAzimuth_deg = Math.sin(long2 - long1) > 0.0 ? Math.toDegrees(this.cwAzimuth_deg) : -Math.toDegrees(this.cwAzimuth_deg);
        this.normCWazimuth_deg = ExtMath.rangeAngle_deg(this.cwAzimuth_deg);
    }

    public double getCWazimuth_deg() {
        if (!this.calculated) {
            throw new RuntimeException("illegal use");
        }
        return this.cwAzimuth_deg;
    }

    public double getNormCWazimuth_deg() {
        if (!this.calculated) {
            throw new RuntimeException("illegal use");
        }
        return this.normCWazimuth_deg;
    }
}

