/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.geospace.PlasmaMath;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum CharChoice {
    FOF2("foF2", "foF2", "Critical frequency", 1, "MHz", 0.01, -1, 0),
    NMF2("NmF2", "NmF2", "Peak density", -1, "cm-3", PlasmaMath.freq2density(0.01), 0, 1),
    HMF2("hmF2", "hmF2", "Peak height", 32, "km", 2.0, -1, 2),
    MUF3000("MUF(3000)F2", "MUF", "MUF for 3000 km path though F2 layer", 4, "MHz", 0.5, 2, 3),
    B0("B0", "B0in", "B0 Shape Parameter", 41, "km", 1.0, -1, 4),
    B1("B1", "B1in", "B1 Shape Parameter", 42, "", 0.01, -1, 5),
    VTEC("VTEC", "VTEC", "Vertical TEC", -2, "TECU", 0.05, -1, 6),
    TAU("tau", "Tau_", "Slab Thickness", -3, "km", 3.0, 5, 7),
    CUSTOM("Custom", "Custom", "Custom input file", -4, "", 0.01, -1, 8);

    public static final int SIZE;
    private static final Map<Integer, CharChoice> mapByDatabaseIdent;
    private static final Map<Integer, CharChoice> mapByIndex;
    private static final Map<String, CharChoice> mapByName;
    private static final Set<CharChoice> regularChars;
    private static final Set<CharChoice> assimilatedChars;
    private final String name;
    private final String name4char;
    private final String description;
    private final String description_tooltip;
    private final String units;
    private final double valueUncertainty;
    private final int didbaseIdent;
    private final int derivedFrom;
    private final int index;

    static {
        SIZE = CharChoice.values().length;
        mapByDatabaseIdent = new HashMap<Integer, CharChoice>();
        mapByIndex = new HashMap<Integer, CharChoice>();
        mapByName = new HashMap<String, CharChoice>();
        regularChars = new HashSet<CharChoice>();
        assimilatedChars = new HashSet<CharChoice>();
        CharChoice[] charChoiceArray = CharChoice.values();
        int n = charChoiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            CharChoice cc = charChoiceArray[n2];
            if (mapByDatabaseIdent.put(cc.getDidbaseIdent(), cc) != null) {
                throw new RuntimeException("CharChoice design error: DIDB ident duplication: " + cc.getDidbaseIdent());
            }
            if (mapByIndex.put(cc.getIndex(), cc) != null) {
                throw new RuntimeException("CharChoice design error: index duplication: " + cc.getIndex());
            }
            if (mapByName.put(cc.getName(), cc) != null) {
                throw new RuntimeException("CharChoice design error: name duplication: " + cc.getName());
            }
            if (cc != CUSTOM) {
                regularChars.add(cc);
                if (!cc.isDerived() && cc != VTEC) {
                    assimilatedChars.add(cc);
                }
            }
            ++n2;
        }
    }

    private CharChoice(String name, String name4char, String description, int didbaseIdent, String units, double valueUncertainty, int derivedFrom, int index) {
        this.name = name;
        this.name4char = name4char;
        this.description = description;
        this.description_tooltip = "<html>" + description.replaceAll("\n", "<br>") + "</html>";
        this.didbaseIdent = didbaseIdent;
        this.units = units;
        this.valueUncertainty = valueUncertainty;
        this.derivedFrom = derivedFrom;
        this.index = index;
    }

    public String getName() {
        return this.name;
    }

    public String getName4char() {
        return this.name4char;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescription_tooltip() {
        return this.description_tooltip;
    }

    public String getUnits() {
        return this.units;
    }

    public double getUncertainty() {
        return this.valueUncertainty;
    }

    public int getDidbaseIdent() {
        return this.didbaseIdent;
    }

    public int getDerivedFrom() {
        return this.derivedFrom;
    }

    public boolean isDerived() {
        return this.derivedFrom != -1;
    }

    public int getIndex() {
        return this.index;
    }

    public static CharChoice getByIdent(int charIdent) {
        return mapByDatabaseIdent.get(charIdent);
    }

    public static CharChoice getByName(String name) {
        return mapByName.get(name);
    }

    public static CharChoice getByIndex(int index) {
        return mapByIndex.get(index);
    }

    public static boolean isRegularChar(CharChoice cc) {
        return regularChars.contains((Object)cc);
    }

    public static boolean isAssimilatedChar(CharChoice cc) {
        return assimilatedChars.contains((Object)cc);
    }

    public static boolean isRegularChar(String name) {
        CharChoice cc = CharChoice.getByName(name);
        if (cc != null) {
            return regularChars.contains((Object)cc);
        }
        return false;
    }

    public static String getRegularCharsList() {
        return regularChars.toString();
    }

    public static String getRegularCharNames() {
        String output = "";
        CharChoice[] charChoiceArray = CharChoice.values();
        int n = charChoiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            CharChoice cc = charChoiceArray[n2];
            output = String.valueOf(output) + cc.getName() + " ";
            ++n2;
        }
        return output;
    }
}

