/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.geospace.Coefficients;
import edu.uml.lgdc.geospace.ExpansionBasis_SphericalCapHarmonicsK6;

public class Coefficients_B0
extends Coefficients {
    private static final double[][] c28x20 = new double[][]{{176.746, 0.233, 0.0, 0.0, -109.413, 0.072, 0.0, 0.0, -66.0, -0.004, 0.0, 0.0, 36.874, -0.018, 0.0, 0.0, -19.515, 0.04, 0.0, 0.0}, {94.998, 0.724, 0.0, 0.0, -116.9, -0.971, 0.0, 0.0, -93.849, -0.59, 0.0, 0.0, 80.579, 0.425, 0.0, 0.0, -19.205, -0.22, 0.0, 0.0}, {-94.824, 0.115, 6.055, 0.265, 84.72, -0.161, -7.101, -0.374, 35.2, -0.138, 1.043, -0.35, -23.96, 0.109, -2.478, 0.133, 25.55, -0.049, -3.143, 0.003}, {-29.418, -0.823, 0.0, 0.0, 40.07, 0.8, 0.0, 0.0, 24.019, 0.478, 0.0, 0.0, -13.175, -0.265, 0.0, 0.0, 8.799, 0.09, 0.0, 0.0}, {-31.099, -1.117, -1.906, 0.498, 43.807, 1.406, -3.216, -0.52, 37.957, 0.902, -0.717, -0.57, -40.232, -0.583, 12.171, 0.244, 11.595, 0.241, -4.89, 0.054}, {-87.665, 1.635, 117.581, -1.765, 123.444, -2.119, -146.917, 2.131, 81.137, -1.173, -99.063, 1.548, -42.646, 0.681, 61.263, -0.811, 17.55, -0.408, -24.374, 0.26}, {54.538, -0.17, 0.0, 0.0, -71.552, 0.361, 0.0, 0.0, -50.565, -0.077, 0.0, 0.0, 36.653, -0.071, 0.0, 0.0, -10.816, 0.236, 0.0, 0.0}, {-31.138, 1.156, 37.307, -1.407, 40.39, -1.39, -34.573, 1.73, 41.597, -0.835, -41.318, 1.55, -19.779, 0.404, 15.954, -0.696, -1.706, -0.22, 5.084, 0.04}, {-57.671, 0.045, 42.683, -0.8, 71.491, 0.048, -49.441, 0.98, 47.893, -0.037, -36.191, 0.562, -26.638, -0.029, 20.346, -0.384, 9.998, 0.067, -6.787, 0.213}, {90.187, -1.198, -66.032, -0.056, -119.148, 1.428, 81.202, 0.022, -63.375, 0.754, 53.07, 0.149, 39.249, -0.436, -30.898, -0.052, -27.293, 0.301, 12.838, -0.067}, {-110.261, 1.509, 0.0, 0.0, 164.956, -1.761, 0.0, 0.0, 103.699, -1.005, 0.0, 0.0, -55.127, 0.569, 0.0, 0.0, 25.376, -0.315, 0.0, 0.0}, {-104.655, 1.341, 109.057, -1.367, 139.129, -1.73, -127.325, 1.532, 88.526, -1.068, -106.461, 1.397, -38.306, 0.508, 56.24, -0.798, 17.239, -0.267, -7.766, 0.058}, {-6.494, -1.253, 5.714, 0.132, 3.547, 1.545, -5.372, -0.106, -4.343, 1.103, -3.393, -0.017, 2.454, -0.626, -3.297, -0.025, 5.871, 0.16, 2.04, -0.036}, {50.814, -0.23, -25.094, 0.817, -65.502, 0.304, 32.267, -1.075, -44.176, 0.019, 14.606, -0.605, 27.869, -0.009, -5.147, 0.387, -11.041, 0.131, 5.922, -0.225}, {77.825, -0.728, 128.501, -0.81, -87.685, 0.838, -164.016, 1.103, -74.431, 0.807, -95.539, 0.498, 40.631, -0.454, 49.95, -0.292, -4.229, 0.0, -29.666, 0.272}, {152.38, -1.232, 0.0, 0.0, -192.098, 1.514, 0.0, 0.0, -132.417, 1.37, 0.0, 0.0, 82.894, -0.709, 0.0, 0.0, -28.162, 0.05, 0.0, 0.0}, {-12.633, 1.192, 47.246, -1.193, -5.488, -1.387, -67.206, 1.486, -9.917, -0.914, -34.438, 0.552, 13.185, 0.477, 21.225, -0.387, 0.586, -0.208, -15.426, 0.419}, {-4.478, -0.118, 17.908, 0.175, -0.417, 0.067, -27.047, -0.241, 7.636, 0.028, -10.075, -0.109, -10.582, 0.005, 14.496, 0.086, 0.421, 0.001, -12.2, -0.041}, {16.086, 0.321, 47.044, -0.126, -24.823, -0.28, -62.615, 0.21, -12.03, -0.136, -44.003, -0.023, 4.929, 0.137, 28.34, -0.009, -4.688, -0.057, -9.315, 0.103}, {28.023, -0.031, -21.535, 0.115, -31.946, 0.011, 24.143, -0.18, -21.019, -0.057, 24.108, -0.116, 13.969, 0.004, -13.823, 0.042, -6.86, 0.031, 0.546, -0.035}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {-31.994, 0.409, 0.0, 0.0, 18.217, -0.458, 0.0, 0.0, 39.28, -0.754, 0.0, 0.0, -20.453, 0.324, 0.0, 0.0, -8.111, 0.139, 0.0, 0.0}, {28.765, -0.477, -28.368, 0.516, -50.604, 0.751, 25.725, -0.471, -23.444, 0.283, 29.966, -0.558, 2.759, -0.146, -10.824, 0.341, -7.419, 0.206, -3.711, 0.056}, {42.429, -0.415, 1.993, 0.117, -53.162, 0.555, 7.229, -0.246, -19.307, 0.039, -8.028, 0.028, 9.849, -0.035, 6.834, 0.033, -17.01, 0.272, 4.668, -0.129}, {4.546, -0.359, -57.796, 0.359, 0.738, 0.343, 73.027, -0.423, -7.421, 0.42, 56.067, -0.327, 5.093, -0.279, -37.581, 0.226, 3.636, -0.041, 10.91, -0.059}, {88.44, -0.393, -69.598, 0.643, -109.481, 0.532, 82.266, -0.765, -59.229, 0.182, 55.279, -0.58, 28.514, -0.057, -30.282, 0.326, -22.924, 0.164, 11.602, -0.073}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    private static double[][] c28x10 = new double[c28x20.length][c28x20[0].length / 2];
    private static double[][] c28x2 = new double[c28x10.length][c28x10[0].length / 5];

    @Override
    public void loadFromClimateFile(int month, double sunspotNumber) {
        int j;
        int i = 0;
        while (i < c28x10.length) {
            j = 0;
            while (j < c28x10[0].length) {
                double value;
                double intercept = c28x20[i][j * 2];
                double slope = c28x20[i][j * 2 + 1];
                Coefficients_B0.c28x10[i][j] = value = intercept + sunspotNumber * slope;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < c28x2.length) {
            j = 0;
            while (j < c28x2[0].length) {
                Coefficients_B0.c28x2[i][j] = 0.0;
                int k = 0;
                while (k < 5) {
                    double c = c28x10[i][k * 2 + j];
                    double basis = ExpansionBasis_SphericalCapHarmonicsK6.DELT[k];
                    double[] dArray = c28x2[i];
                    int n = j;
                    dArray[n] = dArray[n] + c * basis;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.put(c28x2);
    }
}

