/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.time.TimeScale;

public class EarthGrid {
    protected static final int MAX_LATITUDE_NODES = 180;
    protected static final int MAX_LONGITUDE_NODES = 360;
    private static final double PI_HALF = 1.5707963267948966;
    private static final double RADIANS_TO_DEGREES = 57.29577951308232;
    public static final double EARTH_CIRCUMFERENCE_EQUATOR = 4.0075017E7;
    public static final double EARTH_CIRCUMFERENCE_MERIDIAN = 4.000786E7;
    public static final double EARTH_MERIDIANAL_DEGREE_METERS = 111132.94444444444;
    public static final double EARTH_EQUATORIAL_DEGREE_METERS = 111319.49166666667;
    public static final double RE = 6371.2;
    public static final int LAT_IND = 0;
    public static final int LON_IND = 1;
    public static final int NEIGHBORS_DATA_FIELDS = 3;
    private double neighborRadius;
    private int nLats;
    private int nLons;
    private double gridLatStep_rad;
    private double gridLonStep_rad;
    private double lonStepDegree;
    private double latStepDegree;
    private int nLats_2;
    private int nLons_2;
    private int nLatsM1;
    private double[][][] dists = null;
    private double[][][] neighbors = null;

    public EarthGrid(int nLats, int nLons) {
        EarthGrid.checkLatLon(nLats, nLons);
        this.nLats = nLats;
        this.nLons = nLons;
        this.nLatsM1 = nLats - 1;
        this.nLats_2 = nLats / 2;
        this.nLons_2 = nLons / 2;
        this.gridLatStep_rad = Math.PI / (double)this.nLatsM1;
        this.gridLonStep_rad = Math.PI * 2 / (double)nLons;
        this.latStepDegree = 180.0 / (double)this.nLatsM1;
        this.lonStepDegree = 360.0 / (double)nLons;
        EarthGrid.checkSteps(this.latStepDegree, this.lonStepDegree);
    }

    public EarthGrid(int nLats, int nLons, double neighborRadius) {
        this(nLats, nLons);
        this.neighborRadius = neighborRadius;
        this.calcNeighbors(neighborRadius);
    }

    public static void checkLatLon(int nLats, int nLons) {
        if (nLats < 3) {
            throw new IllegalArgumentException("nLats < 3, is " + nLats);
        }
        if (nLons < 2) {
            throw new IllegalArgumentException("nLons < 2, is " + nLons);
        }
    }

    public static double[] getLatLonStep_deg(int nLats, int nLons) {
        double[] steps = new double[]{180.0 / (double)(nLats - 1), 360.0 / (double)nLons};
        return steps;
    }

    public static double[] getLatLonStep_rad(int nLats, int nLons) {
        double[] steps = new double[]{Math.PI / (double)(nLats - 1), Math.PI * 2 / (double)nLons};
        return steps;
    }

    public static void checkSteps(double latStep_deg, double lonStep_deg) {
        if (lonStep_deg * 10.0 != (double)((int)(lonStep_deg * 10.0)) || latStep_deg * 10.0 != (double)((int)(latStep_deg * 10.0))) {
            throw new IllegalArgumentException("Suspicious stepping: Lat. step = " + latStep_deg + " lon. step = " + lonStep_deg);
        }
    }

    public double getDist(int lat1, int lon1, int lat2, int lon2) {
        int lon;
        if (this.dists == null) {
            System.out.println(String.valueOf(new TimeScale().toHumanUT()) + ". Start calculating distances.");
            this.calcDists();
            System.out.println(String.valueOf(new TimeScale().toHumanUT()) + ". Finish calculating distances.");
        }
        if ((lon = lon2 - lon1) < 0) {
            lon = -lon;
        }
        if (lon > this.nLons_2) {
            lon = this.nLons - lon;
        }
        if (lat1 <= this.nLats_2) {
            return this.dists[lat1][lat2][lon];
        }
        if (lat2 <= this.nLats_2) {
            return this.dists[lat2][lat1][lon];
        }
        return this.dists[this.nLatsM1 - lat1][this.nLatsM1 - lat2][lon];
    }

    public double[][] getNeighbors(int iLatCenter, int iLonCenter) {
        if (this.neighbors == null) {
            System.out.println("Precalculate neighbors!");
        }
        double[][] neighborsLocal = new double[this.neighbors[iLatCenter].length][3];
        int iN = 0;
        while (iN < neighborsLocal.length) {
            neighborsLocal[iN][0] = this.neighbors[iLatCenter][iN][0];
            neighborsLocal[iN][1] = this.neighbors[iLatCenter][iN][1] + (double)iLonCenter;
            neighborsLocal[iN][1] = neighborsLocal[iN][1] < (double)this.nLons ? neighborsLocal[iN][1] : neighborsLocal[iN][1] - (double)this.nLons;
            neighborsLocal[iN][2] = this.neighbors[iLatCenter][iN][2];
            ++iN;
        }
        return neighborsLocal;
    }

    private void calcNeighbors(double radius_km) {
        System.out.println("Start searching for neighbors.");
        this.neighbors = new double[this.nLats][][];
        int iLat = 0;
        while (iLat < this.nLats) {
            this.neighbors[iLat] = this.findNeighbors(iLat, 0, radius_km);
            ++iLat;
        }
    }

    public double[][] findNeighbors(int iLatCenter, int iLonCenter, double radius_km) {
        int latOffset = 0;
        int lonOffset = 0;
        int neighborsGain = 0;
        int neighborsTotal = 0;
        int iLat = 0;
        int iLon = 0;
        double weightNorm = 0.0;
        double latStep_km = 4.000786E7 / (double)(2000 * this.nLatsM1);
        latOffset = -((int)(radius_km / latStep_km) + 1);
        double[][] temp = new double[this.nLats * this.nLons][3];
        block0: do {
            neighborsGain = 0;
            iLat = iLatCenter + ++latOffset;
            lonOffset = latOffset == 0 ? 1 : 0;
            do {
                iLon = iLonCenter - lonOffset;
                if ((iLat == 0 || iLat == this.nLats - 1) && iLon != iLonCenter) {
                    ++lonOffset;
                    continue;
                }
                int[] latlonP = this.getProperIndexes(iLat, iLon);
                double dist = this.getDist(iLatCenter, iLonCenter, latlonP[0], latlonP[1]);
                if (!(dist < radius_km)) continue block0;
                ++neighborsGain;
                temp[neighborsTotal][0] = latlonP[0];
                temp[neighborsTotal][1] = latlonP[1];
                temp[neighborsTotal][2] = 1.0 - dist / radius_km;
                weightNorm += temp[neighborsTotal][2];
                ++neighborsTotal;
                if (lonOffset != 0 && lonOffset != this.nLons_2) {
                    latlonP = this.getProperIndexes(iLat, iLonCenter + lonOffset);
                    temp[neighborsTotal][0] = latlonP[0];
                    temp[neighborsTotal][1] = latlonP[1];
                    temp[neighborsTotal][2] = 1.0 - dist / radius_km;
                    weightNorm += temp[neighborsTotal][2];
                    ++neighborsTotal;
                }
                ++lonOffset;
            } while (lonOffset <= this.nLons_2);
        } while (neighborsGain > 0);
        double[][] neighbors = new double[neighborsTotal][3];
        int i = 0;
        while (i < neighborsTotal) {
            neighbors[i][0] = temp[i][0];
            neighbors[i][1] = temp[i][1];
            neighbors[i][2] = temp[i][2] / weightNorm;
            ++i;
        }
        return neighbors;
    }

    int[] getProperIndexes(int iLat, int iLon) {
        int[] latlon = new int[2];
        int iLatP = iLat;
        int iLonP = iLon;
        if (iLon < 0) {
            iLonP = this.nLons + iLon;
        }
        if (iLon >= this.nLons) {
            iLonP = iLon - this.nLons;
        }
        if (iLat < 0 || iLat >= this.nLats) {
            if (iLat < 0) {
                iLatP = -iLatP;
            }
            if (iLat > this.nLatsM1) {
                iLatP = 2 * this.nLatsM1 - iLat;
            }
            iLonP = iLonP >= this.nLons_2 ? iLonP - this.nLons_2 : iLonP + this.nLons_2;
        }
        latlon[0] = iLatP;
        latlon[1] = iLonP;
        return latlon;
    }

    public int getNumLatitudeNodes() {
        return this.nLats;
    }

    public int getNumLongitudeNodes() {
        return this.nLons;
    }

    public double getLatitudeStep() {
        return this.latStepDegree;
    }

    public double getLongitudeStep() {
        return this.lonStepDegree;
    }

    public double getNeighborRadius() {
        return this.neighborRadius;
    }

    private double[] getCoord(int latIndex, int lonIndex) {
        return new double[]{(double)latIndex * this.gridLatStep_rad - 1.5707963267948966, (double)lonIndex * this.gridLonStep_rad};
    }

    public double[] getCoordGeo_radians(int latIndex, int lonIndex) {
        return new double[]{1.5707963267948966 - (double)latIndex * this.gridLatStep_rad, -Math.PI + (double)lonIndex * this.gridLonStep_rad};
    }

    public double[] getCoordGeo_degrees(int latIndex, int lonIndex) {
        double[] latlon = this.getCoordGeo_radians(latIndex, lonIndex);
        latlon[0] = latlon[0] * 57.29577951308232;
        latlon[1] = latlon[1] * 57.29577951308232;
        return latlon;
    }

    public int[] getNode_radians(double lat, double lon) {
        int iLat = (int)Math.round((lat + 1.5707963267948966) / this.gridLonStep_rad);
        int iLon = (int)Math.round(lon / this.gridLonStep_rad);
        return new int[]{iLat, iLon};
    }

    public int[] matchNode(EarthGrid grid2, int iLat, int iLon) {
        return new int[]{Math.round(iLat * this.nLatsM1 / (grid2.getNumLatitudeNodes() - 1)), Math.round(iLon * this.nLons / grid2.getNumLongitudeNodes())};
    }

    private void calcDists() {
        this.dists = new double[this.nLats_2 + 1][this.nLats][this.nLons_2 + 1];
        int i = 0;
        while (i <= this.nLats_2) {
            double[] p1 = this.getCoord(i, 0);
            int j = 0;
            while (j < this.nLats) {
                int k = 0;
                while (k <= this.nLons_2) {
                    double[] p2 = this.getCoord(j, k);
                    this.dists[i][j][k] = EarthGrid.onEarthDistance_rad(p1[0], p1[1], p2[0], p2[1]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static double onEarthDistance_rad(double lat1_rad, double lon1_rad, double lat2_rad, double lon2_rad) {
        double cosD = Math.cos(lon2_rad - lon1_rad) * Math.cos(lat1_rad) * Math.cos(lat2_rad) + Math.sin(lat1_rad) * Math.sin(lat2_rad);
        return 6371.2 * Math.acos(cosD);
    }

    public static double onEarthDistance_deg(double lat1_deg, double lon1_deg, double lat2_deg, double lon2_deg) {
        return EarthGrid.onEarthDistance_rad(Math.toRadians(lat1_deg), Math.toRadians(lon1_deg), Math.toRadians(lat2_deg), Math.toRadians(lon2_deg));
    }

    protected boolean checkSpaceGrid() {
        return this.getNumLatitudeNodes() < 180 && this.getNumLongitudeNodes() < 360;
    }

    public int getGridLatIndex(double latitude_deg) {
        return (int)Math.round((latitude_deg + 90.0) / this.getLatitudeStep()) % this.getNumLatitudeNodes();
    }

    public int getGridLonIndex(double longitude_deg) {
        int i = (int)Math.round(longitude_deg / this.getLongitudeStep()) % this.getNumLongitudeNodes();
        if (i < 0) {
            i += this.getNumLongitudeNodes();
        }
        return i;
    }

    public double getGridLatDegree(int iLat) {
        return (double)iLat * this.getLatitudeStep() - 90.0;
    }

    public double getGridLonDegree(int iLon) {
        return (double)iLon * this.getLongitudeStep();
    }
}

