/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.math.SphereMath;

public class EarthSphere
extends SphereMath {
    private static final double EARTH_RADIUS_KM = 6371.0;

    public EarthSphere() {
        super(6371.0);
    }

    public double distanceOnEarth_km(double lat1_deg, double lon1_deg, double lat2_deg, double lon2_deg) {
        EarthSphere.check(lat1_deg);
        EarthSphere.check(lat2_deg);
        double theta1_deg = (lon1_deg + 720.0) % 360.0;
        double phi1_deg = 90.0 - lat1_deg;
        double theta2_deg = (lon2_deg + 720.0) % 360.0;
        double phi2_deg = 90.0 - lat2_deg;
        return this.distance_pDeg(theta1_deg, phi1_deg, theta2_deg, phi2_deg);
    }

    public double angleOnEarth(double lat1_deg, double lon1_deg, double lat2_deg, double lon2_deg) {
        EarthSphere.check(lat1_deg);
        EarthSphere.check(lat2_deg);
        double theta1_deg = (lon1_deg + 720.0) % 360.0;
        double phi1_deg = 90.0 - lat1_deg;
        double theta2_deg = (lon2_deg + 720.0) % 360.0;
        double phi2_deg = 90.0 - lat2_deg;
        return this.angle_pDeg(theta1_deg, phi1_deg, theta2_deg, phi2_deg);
    }

    public double[] midpointOnEarth(double lat1_deg, double lon1_deg, double lat2_deg, double lon2_deg) {
        EarthSphere.check(lat1_deg);
        EarthSphere.check(lat2_deg);
        double theta1_deg = (lon1_deg + 720.0) % 360.0;
        double phi1_deg = 90.0 - lat1_deg;
        double theta2_deg = (lon2_deg + 720.0) % 360.0;
        double phi2_deg = 90.0 - lat2_deg;
        double[] midPointOnSphere = this.midpoint_pDeg(theta1_deg, phi1_deg, theta2_deg, phi2_deg);
        if (midPointOnSphere != null) {
            return new double[]{90.0 - midPointOnSphere[1], midPointOnSphere[0]};
        }
        System.out.println("antipodes points on Earth (lat,lon):  (" + lat1_deg + "," + lon1_deg + ") and (" + lat2_deg + "," + lon2_deg + ")");
        return null;
    }

    private static void check(double lat_deg) {
        assert (lat_deg >= -90.0 && lat_deg <= 90.0);
    }
}

