/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.geospace.EarthGrid;
import edu.uml.lgdc.geospace.IGRF;
import edu.uml.lgdc.geospace.TimeGrid;
import edu.uml.lgdc.time.TimeScale;
import java.time.YearMonth;

public class ExpansionBasis_SphericalCapHarmonicsK6 {
    public static final int SPATIAL_DEGREE = 6;
    protected static final int INDEX_ORDER = 0;
    protected static final int INDEX_DEGREE = 1;
    protected static final int INDEX_TERM = 2;
    public static final double REFERENCE_ALTITUDE_KM = 300.0;
    public static final int MONTHLY_ORDER = 2;
    private static final TimeScale JANUARY = new TimeScale("2000.01");
    private static final TimeScale DECEMBER = new TimeScale("2000.12");
    public static final double TZERO = JANUARY.get(2);
    public static final double THINT = (double)(DECEMBER.get(2) - JANUARY.get(2)) / 2.0;
    public static double[] DELT = new double[5];
    protected double[][] sinLon;
    protected double[][] cosLon;
    protected double[][] modip;
    public static final double[][] NORMALIZERS = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 1.73205, 0.866025, 0.0, 0.0, 0.0, 0.0}, {1.0, 2.44949, 1.93649, 0.7905691, 0.0, 0.0, 0.0}, {1.0, 3.16228, 3.3541, 2.09165, 0.73951, 0.0, 0.0}, {1.0, 3.87298, 5.12348, 4.1833, 2.21853, 0.701561, 0.0}, {1.0, 4.58258, 7.24569, 7.24569, 4.96078, 2.32681, 0.671693}};
    public static final double[][] DEGREES = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {2.0, 2.0, 2.0, 0.0, 0.0, 0.0, 0.0}, {3.0, 3.0, 3.0, 3.0, 0.0, 0.0, 0.0}, {4.0, 4.0, 4.0, 4.0, 4.0, 0.0, 0.0}, {5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 0.0}, {6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0}};
    protected double[][] legendre;
    protected EarthGrid earthGrid = null;
    protected TimeGrid timeGrid = null;
    private final IGRF igrf = new IGRF();
    private TimeScale tov = null;
    public boolean debugging = false;

    public EarthGrid getEarthGrid() {
        return this.earthGrid;
    }

    public void setEarthGrid(EarthGrid grid) {
        this.earthGrid = grid;
    }

    public TimeGrid getTimeGrid() {
        return this.timeGrid;
    }

    public void setTimeGrid(TimeGrid grid) {
        this.timeGrid = grid;
    }

    public boolean setupSpatialBasisConstants() {
        if (this.earthGrid == null) {
            System.err.println("ERROR: Spherical Cap Harmonics basis cannot initialize without defined grid");
            return false;
        }
        this.sinLon = new double[7][this.earthGrid.getNumLongitudeNodes()];
        this.cosLon = new double[7][this.earthGrid.getNumLongitudeNodes()];
        int i = 0;
        while (i < this.earthGrid.getNumLongitudeNodes()) {
            double longitude_deg = this.earthGrid.getGridLonDegree(i);
            double longitude_rad = Math.toRadians(longitude_deg);
            this.cosLon[0][i] = 1.0;
            this.sinLon[0][i] = 0.0;
            this.cosLon[1][i] = Math.cos(longitude_rad);
            this.sinLon[1][i] = Math.sin(longitude_rad);
            int j = 2;
            while (j <= 6) {
                this.cosLon[j][i] = this.cosLon[1][i] * this.cosLon[j - 1][i] - this.sinLon[1][i] * this.sinLon[j - 1][i];
                this.sinLon[j][i] = this.cosLon[1][i] * this.sinLon[j - 1][i] + this.sinLon[1][i] * this.cosLon[j - 1][i];
                ++j;
            }
            ++i;
        }
        this.legendre = new double[this.getCompactSpatialBasisLength()][this.earthGrid.getNumLatitudeNodes()];
        i = 0;
        while (i < this.earthGrid.getNumLatitudeNodes()) {
            double latitude_deg = (double)i * this.earthGrid.getLatitudeStep() - 90.0;
            double colat = 90.0 - latitude_deg;
            int order = 0;
            while (order <= 6) {
                int degree = 0;
                while (degree <= order) {
                    this.legendre[this.orderDegreeTermToCompact((int)order, (int)degree, (int)0)][i] = this.legfun(order, degree, Math.toRadians(colat));
                    this.legendre[this.orderDegreeTermToCompact((int)order, (int)degree, (int)1)][i] = this.legendre[this.orderDegreeTermToCompact(order, degree, 0)][i];
                    ++degree;
                }
                ++order;
            }
            ++i;
        }
        if (this.tov != null && (this.modip.length != this.earthGrid.getNumLatitudeNodes() || this.modip[0].length != this.earthGrid.getNumLongitudeNodes())) {
            this.recalculateMagneticField(this.tov);
        }
        return true;
    }

    private double legfun(int order, int degree, double colat_rad) {
        double al;
        double fnn = DEGREES[order][degree] * (DEGREES[order][degree] + 1.0);
        double c = Math.cos(colat_rad);
        double x = (1.0 - c) / 2.0;
        double s = Math.sin(colat_rad);
        double pnm = al = NORMALIZERS[order][degree] * (degree < 2 ? 1.0 : Math.pow(s, degree - 1));
        double a = 0.0;
        int count = 0;
        while (count++ < 60) {
            int jpm = count + degree;
            double b = al * ((double)(jpm - 1) - fnn / (double)jpm);
            a = b * x / (double)count;
            pnm += a;
            al = a;
            if (Math.abs(a) > 1.0E13 || Math.abs(b) > 1.0E13) {
                System.out.println("ERROR: Legendre polynomial did not converge.");
                return 0.0;
            }
            if (Math.abs(a) < 1.0E-7 && Math.abs(b) < 1.0E-7) break;
        }
        return pnm * (degree > 0 ? s : 1.0);
    }

    public void computeTimeDependentConstants(TimeScale ut) {
        this.timeGrid.setUTs(ut);
        this.tov = new TimeScale(ut.getTimeInMillis());
        this.setupTemporalBasisConstants();
        this.recalculateMagneticField(ut);
    }

    protected boolean setupTemporalBasisConstants() {
        if (this.tov == null) {
            return false;
        }
        int month = this.tov.get(2);
        YearMonth ym = YearMonth.of(this.tov.get(1), month + 1);
        double dMonth = (double)month + (double)(this.tov.get(5) - 1) / (double)ym.lengthOfMonth();
        ExpansionBasis_SphericalCapHarmonicsK6.DELT[0] = 1.0;
        double del = (dMonth - TZERO) / THINT;
        double sinT = Math.sin(del);
        double cosT = Math.cos(del);
        ExpansionBasis_SphericalCapHarmonicsK6.DELT[1] = sinT;
        ExpansionBasis_SphericalCapHarmonicsK6.DELT[2] = cosT;
        int i = 3;
        while (i < 5) {
            ExpansionBasis_SphericalCapHarmonicsK6.DELT[i] = i % 2 != 0 ? DELT[i - 2] * cosT + DELT[i - 1] * sinT : DELT[i - 2] * cosT - DELT[i - 3] * sinT;
            ++i;
        }
        return true;
    }

    protected void recalculateMagneticField(TimeScale ut) {
        this.modip = new double[this.earthGrid.getNumLatitudeNodes()][this.earthGrid.getNumLongitudeNodes()];
        int i = 0;
        while (i < this.earthGrid.getNumLatitudeNodes()) {
            double latitude_deg = (double)i * this.earthGrid.getLatitudeStep() - 90.0;
            double latitude_rad = Math.toRadians(latitude_deg);
            double cos_latitude = Math.cos(latitude_rad);
            double root_cos_lat = Math.sqrt(cos_latitude);
            int j = 0;
            while (j < this.earthGrid.getNumLongitudeNodes()) {
                double longitude_deg = (double)j * this.earthGrid.getLongitudeStep();
                this.igrf.calc(ut, latitude_deg, longitude_deg, 300.0);
                double dip_rad = Math.toRadians(this.igrf.dip);
                this.modip[i][j] = Math.atan2(dip_rad, root_cos_lat);
                ++j;
            }
            ++i;
        }
    }

    public int findModipIndex(double modip0, int iLon) {
        int i = 0;
        while (i < this.earthGrid.getNumLatitudeNodes()) {
            double diff = this.modip[i][iLon] - modip0;
            if (diff >= 0.0) {
                return i > 0 && modip0 - this.modip[i - 1][iLon] < diff ? i - 1 : i;
            }
            ++i;
        }
        System.err.println("Problems locating matching modip");
        return this.earthGrid.getNumLatitudeNodes() - 1;
    }

    public double getModip(double latitude_deg, double longitude_deg) {
        int iLat = this.earthGrid.getGridLatIndex(latitude_deg);
        int iLon = this.earthGrid.getGridLonIndex(longitude_deg);
        return this.modip[iLat][iLon];
    }

    public int getCompactSpatialBasisLength() {
        return 56;
    }

    public int orderDegreeTermToCompact(int order, int degree, int term) {
        return ((1 + order) * order / 2 + degree) * 2 + term;
    }

    public int[] compactToOrderDegreeTerm(int sCompact) {
        int term = sCompact % 2;
        int tria = sCompact / 2;
        int k = (int)(-1.0 + Math.sqrt(1 + 8 * tria)) / 2;
        int m = tria - (1 + k) * k / 2;
        return new int[]{k, m, term};
    }

    protected double longitudeFactor(int order, int term, int iLon) {
        return term == 0 ? this.cosLon[order][iLon] : this.sinLon[order][iLon];
    }

    public double getSpatialBasisFunctionValue(int iCompact, int iLat, int iLon) {
        int[] odt = this.compactToOrderDegreeTerm(iCompact);
        if (this.debugging) {
            System.out.println("k=" + iCompact + "(" + odt[0] + " " + odt[1] + " " + odt[2] + ") LongitudeTerm=" + this.longitudeFactor(odt[1], odt[2], iLon) + " , LegendreFactor=" + this.legendre[iCompact][iLat]);
        }
        return this.longitudeFactor(odt[1], odt[2], iLon) * this.legendre[iCompact][iLat];
    }

    public double getTemporalBasisFunctionValue(int index, int iTime) {
        return 0.0;
    }

    public void test() {
        int m;
        int spatialOrder = 6;
        int k = 0;
        while (k <= spatialOrder) {
            m = 0;
            while (m <= k) {
                System.out.println("k" + k + " m" + m + " " + this.legfun(k, m, Math.toRadians(40.0)));
                ++m;
            }
            ++k;
        }
        k = 0;
        while (k <= spatialOrder) {
            m = 0;
            while (m <= k) {
                System.out.println("k" + k + " m" + m + " c=" + this.orderDegreeTermToCompact(k, m, 0));
                ++m;
            }
            ++k;
        }
        int s = 0;
        while (s < this.getCompactSpatialBasisLength()) {
            int[] km = this.compactToOrderDegreeTerm(s);
            System.out.println("s" + s + " k" + km[0] + " m=" + km[1] + " t=" + km[2]);
            ++s;
        }
        System.out.println("");
        int degree = 0;
        while (degree <= 6) {
            int order = 0;
            while (order <= degree) {
                int t = 0;
                while (t < 2) {
                    System.out.println("degree" + degree + " order" + order + " t=" + t + " c=" + this.orderDegreeTermToCompact(degree, order, t));
                    ++t;
                }
                ++order;
            }
            ++degree;
        }
    }
}

