/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.format.IonexGrid;
import edu.uml.lgdc.geospace.EarthGrid;
import edu.uml.lgdc.geospace.MapChoice;
import edu.uml.lgdc.math.SimpleMetrics;
import edu.uml.lgdc.time.TimeScale;

public class Geomap {
    protected EarthGrid earthGrid;
    protected double[][] mapValues;
    protected double[] mapValues_1D;
    protected SimpleMetrics metrics = new SimpleMetrics();
    protected TimeScale refTime = new TimeScale();
    protected TimeScale refTime_baseline = new TimeScale();
    protected boolean needRecalculateGrid = true;
    protected boolean demagnetized = false;
    protected double noValue;
    public static final int TRANSFORM_DO_NOTHING = 0;
    public static final int TRANSFORM_MAPS_DEMAG = 1;
    public static final int TRANSFORM_MAPS_REMAG = 2;
    protected int transformation = 0;
    protected MapChoice mapChoice;

    public Geomap(MapChoice mapChoice, double noValue) {
        this.mapChoice = mapChoice;
        this.noValue = noValue;
        this.demagnetized = false;
    }

    public void setEarthGrid(EarthGrid earthGrid) {
        this.earthGrid = earthGrid;
        this.mapValues = new double[earthGrid.getNumLatitudeNodes()][earthGrid.getNumLongitudeNodes()];
        this.mapValues_1D = new double[earthGrid.getNumLatitudeNodes() * earthGrid.getNumLongitudeNodes()];
    }

    public TimeScale getRefTime() {
        return this.refTime == null ? null : new TimeScale(this.refTime.getTimeInMillis());
    }

    public TimeScale getBaselineTime() {
        return this.refTime_baseline == null ? null : new TimeScale(this.refTime_baseline.getTimeInMillis());
    }

    public void setBaselineTime(TimeScale time) {
        if (this.refTime_baseline == null) {
            this.refTime_baseline = new TimeScale(time.getTimeInMillis());
        } else {
            this.refTime_baseline.setTimeInMillis(time.getTimeInMillis());
        }
    }

    public boolean getNeedRecalcGrid() {
        return this.needRecalculateGrid;
    }

    public double[] getMap_1D() {
        return this.mapValues_1D;
    }

    public double[][] getMap() {
        return this.mapValues;
    }

    public SimpleMetrics getMetrics() {
        return this.metrics;
    }

    public double getMinValue() {
        return this.metrics.min;
    }

    public double getMaxValue() {
        return this.metrics.max;
    }

    public double getAverageValue() {
        return this.metrics.average;
    }

    public double getSDO() {
        return this.metrics.standardDeviation;
    }

    public EarthGrid getEarthGrid() {
        return this.earthGrid;
    }

    public MapChoice getMapChoice() {
        return this.mapChoice;
    }

    public double getNoValue() {
        return this.noValue;
    }

    public void setNeedRecalcGrid(boolean b) {
        this.needRecalculateGrid = b;
    }

    public boolean setMapValues(double[][] values, TimeScale newRefTime) {
        if (values.length != this.earthGrid.getNumLatitudeNodes() || values[0].length != this.earthGrid.getNumLongitudeNodes()) {
            System.err.println("Map ERROR: grid does not match value array");
            return false;
        }
        int i = 0;
        while (i < values.length) {
            int j = 0;
            while (j < values[i].length) {
                this.mapValues[i][j] = values[i][j];
                ++j;
            }
            ++i;
        }
        this.refTime.setTimeInMillis(newRefTime.getTimeInMillis());
        Geomap.compute1Dfrom2D(this.mapValues_1D, this.mapValues);
        this.metrics.compute(this.mapValues_1D, this.mapValues_1D.length, this.noValue);
        return true;
    }

    public boolean setMapValues(double[] values, TimeScale newRefTime) {
        if (values.length != this.earthGrid.getNumLatitudeNodes() * this.earthGrid.getNumLongitudeNodes()) {
            System.err.println("Map ERROR: grid does not match value array");
            return false;
        }
        int i = 0;
        while (i < values.length) {
            this.mapValues_1D[i] = values[i];
            ++i;
        }
        this.refTime.setTimeInMillis(newRefTime.getTimeInMillis());
        Geomap.compute2Dfrom1D(this.mapValues, this.mapValues_1D);
        this.metrics.compute(this.mapValues_1D, this.mapValues_1D.length, this.noValue);
        return true;
    }

    public static boolean compute2Dfrom1D(double[][] m2, double[] m1) {
        if (m1 == null || m2 == null) {
            System.err.println("Map ERROR: null value arrays in 2D->1D computation");
            return false;
        }
        if (m1.length != m2.length * m2[0].length) {
            System.err.println("Map ERROR: dimensions do not match in 2D->1D computation");
            return false;
        }
        int totalLatitudes = m2.length;
        int totalLongitudes = m2[0].length;
        int halfLongitudes = totalLongitudes / 2;
        int i = 0;
        while (i < m1.length) {
            int wLat = i / totalLongitudes;
            int iLat = totalLatitudes - wLat - 1;
            int wLon = i - wLat * totalLongitudes;
            int iLon = (wLon + halfLongitudes) % totalLongitudes;
            m2[iLat][iLon] = m1[i];
            ++i;
        }
        return true;
    }

    public static boolean compute1Dfrom2D(double[] m1, double[][] m2) {
        if (m1 == null || m2 == null) {
            System.err.println("Map ERROR: null value arrays in 1D->2D computation");
            return false;
        }
        if (m1.length != m2.length * m2[0].length) {
            System.err.println("Map ERROR: dimensions do not match in 1D->2D computation");
            return false;
        }
        int totalLatitudes = m2.length;
        int totalLongitudes = m2[0].length;
        int halfLongitudes = totalLongitudes / 2;
        int wLat = 0;
        while (wLat < totalLatitudes) {
            int j = totalLongitudes * wLat;
            int iLat = totalLatitudes - 1 - wLat;
            int wLon = 0;
            while (wLon < totalLongitudes) {
                int iLon = (wLon + halfLongitudes) % totalLongitudes;
                m1[j + wLon] = m2[iLat][iLon];
                ++wLon;
            }
            ++wLat;
        }
        return true;
    }

    public boolean setIonexMapValues(double[] ionexValues, IonexGrid ionexGrid) {
        if (ionexValues == null) {
            System.err.println("Ionex map is empty");
            return false;
        }
        int nLons = this.earthGrid.getNumLongitudeNodes();
        int nLats = this.earthGrid.getNumLatitudeNodes();
        if (Math.abs(ionexGrid.getLatitudeTriplet()[2]) != this.earthGrid.getLatitudeStep()) {
            System.err.println("Ionex Import ERROR: latitude step of the grids do not match: ionex " + ionexGrid.getLatitudeTriplet()[2] + " vs WorldWind " + this.earthGrid.getLatitudeStep());
            return false;
        }
        if (Math.abs(ionexGrid.getLongitudeTriplet()[2]) != this.earthGrid.getLongitudeStep()) {
            System.err.println("Ionex Import ERROR: longitude step of the grids do not match: ionex " + ionexGrid.getLongitudeTriplet()[2] + " vs WorldWind " + this.earthGrid.getLongitudeStep());
            return false;
        }
        int latCount = 0;
        int i = 0;
        while (i < this.mapValues_1D.length - 2 * nLons) {
            if (i > 0 && i % nLons == 0) {
                ++latCount;
            }
            this.mapValues_1D[i + nLons] = ionexValues[i + latCount];
            ++i;
        }
        double average = 0.0;
        i = 0;
        while (i < nLons) {
            average += ionexValues[i];
            ++i;
        }
        average /= (double)nLons;
        i = 0;
        while (i < nLons) {
            this.mapValues_1D[i] = average;
            ++i;
        }
        average = 0.0;
        i = ionexValues.length - 1;
        while (i >= ionexValues.length - 1 - nLons) {
            average += ionexValues[i];
            --i;
        }
        average /= (double)nLons;
        i = this.mapValues_1D.length - 1;
        while (i >= this.mapValues_1D.length - nLons - 1) {
            this.mapValues_1D[i] = average;
            --i;
        }
        Geomap.compute2Dfrom1D(this.mapValues, this.mapValues_1D);
        this.metrics.compute(this.mapValues_1D, this.mapValues_1D.length, this.noValue);
        return true;
    }

    public Geomap clone() {
        Geomap m = new Geomap(this.mapChoice, this.noValue);
        m.setEarthGrid(this.earthGrid);
        int i = 0;
        while (i < this.mapValues_1D.length) {
            m.mapValues_1D[i] = this.mapValues_1D[i];
            ++i;
        }
        m.setMapValues(m.mapValues_1D, this.refTime);
        if (this.refTime_baseline != null) {
            m.setBaselineTime(this.refTime_baseline);
        }
        m.demagnetized = this.demagnetized;
        return m;
    }

    public void reset() {
        int iLat = 0;
        while (iLat < this.earthGrid.getNumLatitudeNodes()) {
            int iLon = 0;
            while (iLon < this.earthGrid.getNumLongitudeNodes()) {
                this.mapValues[iLat][iLon] = this.noValue;
                ++iLon;
            }
            ++iLat;
        }
        int i = 0;
        while (i < this.mapValues_1D.length) {
            this.mapValues_1D[i] = this.noValue;
            ++i;
        }
    }

    public boolean buildDeviationMap(double[][] values1, double[][] values2, TimeScale refTime, TimeScale baselineTime) {
        if (values1.length != this.earthGrid.getNumLatitudeNodes() || values1[0].length != this.earthGrid.getNumLongitudeNodes() || values2.length != this.earthGrid.getNumLatitudeNodes() || values2[0].length != this.earthGrid.getNumLongitudeNodes()) {
            System.err.println("Map ERROR: grid does not match value array");
            return false;
        }
        this.refTime = refTime;
        this.refTime_baseline = baselineTime;
        int iLat = 0;
        while (iLat < values1.length) {
            int iLon = 0;
            while (iLon < values1[0].length) {
                double val1 = values1[iLat][iLon];
                double val2 = values2[iLat][iLon];
                this.mapValues[iLat][iLon] = val1 == this.noValue || val2 == this.noValue ? this.noValue : val1 - val2;
                ++iLon;
            }
            ++iLat;
        }
        Geomap.compute1Dfrom2D(this.mapValues_1D, this.mapValues);
        this.metrics.compute(this.mapValues_1D, this.mapValues_1D.length, this.noValue);
        return true;
    }

    public boolean buildDeviationMap(double[] values1, double[] values2, TimeScale refTime, TimeScale baselineTime) {
        if (values1.length != this.earthGrid.getNumLatitudeNodes() * this.earthGrid.getNumLongitudeNodes() || values2.length != this.earthGrid.getNumLatitudeNodes() * this.earthGrid.getNumLongitudeNodes()) {
            System.err.println("Map ERROR: grid does not match value array");
            return false;
        }
        this.refTime = refTime;
        this.refTime_baseline = baselineTime;
        int i = 0;
        while (i < values1.length) {
            double val1 = values1[i];
            double val2 = values2[i];
            this.mapValues_1D[i] = val1 == this.noValue || val2 == this.noValue ? this.noValue : val1 - val2;
            ++i;
        }
        Geomap.compute2Dfrom1D(this.mapValues, this.mapValues_1D);
        this.metrics.compute(this.mapValues_1D, this.mapValues_1D.length, this.noValue);
        return true;
    }

    public boolean buildDeviationMap_percent(double[][] values1, double[][] values2, TimeScale refTime, TimeScale baselineTime) {
        this.buildDeviationMap(values1, values2, refTime, baselineTime);
        int iLat = 0;
        while (iLat < values1.length) {
            int iLon = 0;
            while (iLon < values1[0].length) {
                if (this.mapValues[iLat][iLon] != this.noValue) {
                    double[] dArray = this.mapValues[iLat];
                    int n = iLon;
                    dArray[n] = dArray[n] / (0.01 * values2[iLat][iLon]);
                }
                ++iLon;
            }
            ++iLat;
        }
        Geomap.compute1Dfrom2D(this.mapValues_1D, this.mapValues);
        this.metrics.compute(this.mapValues_1D, this.mapValues_1D.length, this.noValue);
        return true;
    }

    public boolean buildDeviationMap_percent(double[] values1, double[] values2, TimeScale refTime, TimeScale baselineTime) {
        this.buildDeviationMap(values1, values2, refTime, baselineTime);
        int i = 0;
        while (i < values1.length) {
            if (this.mapValues_1D[i] != this.noValue) {
                int n = i;
                this.mapValues_1D[n] = this.mapValues_1D[n] / (0.01 * values2[i]);
            }
            ++i;
        }
        Geomap.compute2Dfrom1D(this.mapValues, this.mapValues_1D);
        this.metrics.compute(this.mapValues_1D, this.mapValues_1D.length, this.noValue);
        return true;
    }

    public boolean isDemagnetized() {
        return this.demagnetized;
    }

    public void setDemagnetized(boolean demagnetized) {
        this.demagnetized = demagnetized;
    }
}

