/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.format.StrUtil;
import edu.uml.lgdc.project.CommonConst;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.time.TimeScale;
import java.awt.Polygon;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class Geopack {
    public static final String GEOPACKDATA = "geopackdata.txt";
    public static final double RE = 6371.2;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int Z_AXIS = 2;
    public static final int POLAR_ANGLE = 0;
    public static final int AZIMUTH = 1;
    public static final int RADIUS = 2;
    public static final int LATITUDE = 0;
    public static final int LONGITUDE = 1;
    public static final int ALTITUDE = 2;
    private static final String DATAFILE_NAME = new File(CommonConst.getShareResourcesDir(), "geopackdata.txt").getPath();
    private static final String FILE_SIGNATURE = "GeopackData ";
    private static final double DATA_FILE_VERSION = 3.0;
    public static final int DATAFILE_ERROR_OK = 0;
    public static final int DATAFILE_ERROR_ZEROLENGTH = 1;
    public static final int DATAFILE_ERROR_SIGNATURE = 2;
    public static final int DATAFILE_ERROR_ELEMENT_QTY = 3;
    public static final int DATAFILE_ERROR_TIME_FORMAT = 4;
    public static final int DATAFILE_ERROR_NUMBER_FORMAT = 5;
    public static final int DATAFILE_ERROR_TIME_DECREASE = 6;
    public static final int DATAFILE_ERROR_NO_ENTRIES = 7;
    public static final int DATAFILE_ERROR_LACK_OF_ENTRIES = 8;
    public static final int DATAFILE_ERROR_IO = 9;
    public static final int DATAFILE_ERROR_OBSOLETE = 10;
    private static TimeScale[] TIMES = new TimeScale[]{new TimeScale("1945.01.01"), new TimeScale("1950.01.01"), new TimeScale("1955.01.01"), new TimeScale("1960.01.01"), new TimeScale("1965.01.01"), new TimeScale("1970.01.01"), new TimeScale("1975.01.01"), new TimeScale("1980.01.01"), new TimeScale("1985.01.01"), new TimeScale("1990.01.01"), new TimeScale("1995.01.01"), new TimeScale("2000.01.01"), new TimeScale("2005.01.01"), new TimeScale("2011.01.01"), new TimeScale("2015.01.01"), new TimeScale("2020.01.01"), new TimeScale("2026.01.01")};
    private static double[] G10 = new double[]{30594.0, 30554.0, 30500.0, 30421.0, 30334.0, 30220.0, 30100.0, 29992.0, 29873.0, 29775.0, 29692.0, 29619.4, 29554.63, 29496.5, 29442.0, 29404.8, -5.7};
    private static double[] G11 = new double[]{-2285.0, -2250.0, -2215.0, -2169.0, -2119.0, -2068.0, -2013.0, -1956.0, -1905.0, -1848.0, -1784.0, -1728.2, -1669.05, -1585.9, -1501.0, -1450.9, 7.4};
    private static double[] H11 = new double[]{5810.0, 5815.0, 5820.0, 5791.0, 5776.0, 5737.0, 5675.0, 5604.0, 5500.0, 5406.0, 5306.0, 5186.1, 5077.99, 4945.1, 4797.1, 4652.5, -25.9};
    private static boolean datafileInUse = false;
    private static int datafileErrorCode = 0;
    private static boolean softwareObsolete = false;
    public static TimeScale MIN_DATE = TIMES[0];
    public static TimeScale MAX_DATE = new TimeScale(TIMES[TIMES.length - 1].getTimeInMinutes());
    public static double MIN_DATE_IN_MINUTES;
    public static double MAX_DATE_IN_MINUTES;
    public static final double RAD = 57.29577951308232;
    public static double L_SHELL;
    public double GST = 0.0;
    public double SLONG = 0.0;
    public double SRASN = 0.0;
    public double SDEC = 0.0;
    public double CGST = 0.0;
    public double SGST = 0.0;
    public double PSI = 0.0;
    double CPS = 0.0;
    double SPS = 0.0;
    double A11 = 0.0;
    double A21 = 0.0;
    double A31 = 0.0;
    double A12 = 0.0;
    double A22 = 0.0;
    double A32 = 0.0;
    double A13 = 0.0;
    double A23 = 0.0;
    double A33 = 0.0;
    double CHI = 0.0;
    double SHI = 0.0;
    double HI = 0.0;
    double CFI = 0.0;
    double SFI = 0.0;
    double S1 = 0.0;
    double S2 = 0.0;
    double S3 = 0.0;
    double DZ1;
    double DZ2;
    double DZ3;
    double DY1;
    double DY2;
    double DY3;
    double ST0 = 0.0;
    double CT0 = 0.0;
    double SL0 = 0.0;
    double CL0 = 0.0;
    double STCL = 0.0;
    double STSL = 0.0;
    double CTCL = 0.0;
    double CTSL = 0.0;
    private int prevYear = -1;
    private int prevDayOfYear = -1;
    private TimeScale prevTimeUT = null;
    private TimeScale timeUT = null;
    private static boolean extrapolationInaccurateMes;
    private static boolean compatibleMode;

    static {
        MAX_DATE.add(14, -1);
        MIN_DATE_IN_MINUTES = MIN_DATE.getTimeInMinutes();
        MAX_DATE_IN_MINUTES = MAX_DATE.getTimeInMinutes();
        L_SHELL = 4.0;
        extrapolationInaccurateMes = false;
        Geopack.readGeodipoleMomentCoeff();
        compatibleMode = true;
        int i = 0;
        while (i < TIMES.length - 1) {
            if (!TIMES[i].equals(TIMES[i].startOfYear())) {
                compatibleMode = false;
                break;
            }
            ++i;
        }
    }

    private void recalc(int year, int dayOfYear, int hour, int min, int sec) {
        boolean onlyForGeoMagTransform = false;
        TimeScale ut = new TimeScale();
        ut.set(1, year);
        ut.set(6, dayOfYear);
        if (hour >= 24) {
            hour -= 24;
            onlyForGeoMagTransform = true;
        }
        ut.set(11, hour);
        ut.set(12, min);
        ut.set(13, sec);
        ut.set(14, 0);
        this.recalc(ut, onlyForGeoMagTransform);
    }

    public void recalc(TimeScale ut) {
        this.recalc(ut, false);
    }

    private void recalc(TimeScale ut, boolean onlyForGeoMagTransform) {
        int year = ut.get(1);
        int dayOfYear = ut.get(6);
        this.timeUT = new TimeScale(ut.getTimeInMinutes());
        if (ut.before(MIN_DATE)) {
            throw new RuntimeException("Geopack: date is below " + MIN_DATE + ", - no coefficients exist");
        }
        if (MAX_DATE.before(ut)) {
            String msg = "Geopack: date is above " + MAX_DATE + ", extrapolated coefficients may be inaccurate";
            if (!extrapolationInaccurateMes) {
                if (!datafileInUse) {
                    if (datafileErrorCode == 0) {
                        msg = String.valueOf(msg) + System.lineSeparator() + "  you do not use Geopack data file";
                    } else if (!softwareObsolete && datafileErrorCode != 10) {
                        msg = String.valueOf(msg) + System.lineSeparator() + "  your Geopack data file is corrupted";
                    }
                }
                msg = String.valueOf(msg) + System.lineSeparator() + "  try to get up-to-date Geopack data file";
                extrapolationInaccurateMes = true;
            }
            Console.showWarn(msg);
        }
        double g10 = 0.0;
        double g11 = 0.0;
        double h11 = 0.0;
        double SQ = 0.0;
        double SQQ = 0.0;
        double SQR = 0.0;
        if (compatibleMode && (year != this.prevYear || dayOfYear != this.prevDayOfYear) || !compatibleMode && !ut.equals(this.prevTimeUT)) {
            int i;
            this.prevDayOfYear = this.prevYear = year;
            this.prevTimeUT = ut;
            if (compatibleMode) {
                if (year >= TIMES[TIMES.length - 2].get(1)) {
                    double dt = (double)year + (double)dayOfYear / 366.0 - (double)TIMES[TIMES.length - 2].get(1);
                    g10 = G10[TIMES.length - 2] + G10[TIMES.length - 1] * dt;
                    g11 = G11[TIMES.length - 2] + G11[TIMES.length - 1] * dt;
                    h11 = H11[TIMES.length - 2] + H11[TIMES.length - 1] * dt;
                } else {
                    i = 0;
                    while (i < TIMES.length - 2) {
                        if (year < TIMES[i + 1].get(1)) {
                            double f2 = ((double)year + (double)dayOfYear / 365.0 - (double)TIMES[i].get(1)) / 5.0;
                            double f1 = 1.0 - f2;
                            g10 = f1 * G10[i] + f2 * G10[i + 1];
                            g11 = f1 * G11[i] + f2 * G11[i + 1];
                            h11 = f1 * H11[i] + f2 * H11[i + 1];
                            break;
                        }
                        ++i;
                    }
                }
            } else if (!ut.before(TIMES[TIMES.length - 2])) {
                double dt = ut.diffIn(1, TIMES[TIMES.length - 2]);
                g10 = G10[TIMES.length - 2] + G10[TIMES.length - 1] * dt;
                g11 = G11[TIMES.length - 2] + G11[TIMES.length - 1] * dt;
                h11 = H11[TIMES.length - 2] + H11[TIMES.length - 1] * dt;
            } else {
                i = 0;
                while (i < TIMES.length - 2) {
                    if (ut.before(TIMES[i + 1])) {
                        double f2 = ut.diffIn(12, TIMES[i]) / TIMES[i + 1].diffIn(12, TIMES[i]);
                        double f1 = 1.0 - f2;
                        g10 = f1 * G10[i] + f2 * G10[i + 1];
                        g11 = f1 * G11[i] + f2 * G11[i + 1];
                        h11 = f1 * H11[i] + f2 * H11[i + 1];
                        break;
                    }
                    ++i;
                }
            }
            SQ = g11 * g11 + h11 * h11;
            SQQ = Math.sqrt(SQ);
            SQR = Math.sqrt(g10 * g10 + SQ);
            this.SL0 = -h11 / SQQ;
            this.CL0 = -g11 / SQQ;
            this.ST0 = SQQ / SQR;
            this.CT0 = g10 / SQR;
            this.STCL = this.ST0 * this.CL0;
            this.STSL = this.ST0 * this.SL0;
            this.CTSL = this.CT0 * this.SL0;
            this.CTCL = this.CT0 * this.CL0;
        }
        if (onlyForGeoMagTransform) {
            return;
        }
        this.sunPosition(ut);
        this.S1 = Math.cos(this.SRASN) * Math.cos(this.SDEC);
        this.S2 = Math.sin(this.SRASN) * Math.cos(this.SDEC);
        this.S3 = Math.sin(this.SDEC);
        this.CGST = Math.cos(this.GST);
        this.SGST = Math.sin(this.GST);
        double DIP1 = this.STCL * this.CGST - this.STSL * this.SGST;
        double DIP2 = this.STCL * this.SGST + this.STSL * this.CGST;
        double DIP3 = this.CT0;
        double Y1 = 0.0;
        double Y2 = 0.0;
        double Y3 = 0.0;
        double Z1 = 0.0;
        double Z2 = 0.0;
        double Z3 = 0.0;
        Y1 = DIP2 * this.S3 - DIP3 * this.S2;
        Y2 = DIP3 * this.S1 - DIP1 * this.S3;
        Y3 = DIP1 * this.S2 - DIP2 * this.S1;
        double Y = Math.sqrt(Y1 * Y1 + Y2 * Y2 + Y3 * Y3);
        Z1 = this.S2 * (Y3 /= Y) - this.S3 * (Y2 /= Y);
        Z2 = this.S3 * (Y1 /= Y) - this.S1 * Y3;
        Z3 = this.S1 * Y2 - this.S2 * Y1;
        double DJ = compatibleMode ? (double)(365 * (year - 1900) + (year - 1901) / 4 + dayOfYear) - 0.5 + (double)ut.get(13) / 86400.0 : ut.diffIn(5, new TimeScale("1900.01.01"));
        double T = DJ / 36525.0;
        double OBLIQ = (23.45229 - 0.0130125 * T) / 57.2957795;
        this.DZ1 = 0.0;
        this.DZ2 = -Math.sin(OBLIQ);
        this.DZ3 = Math.cos(OBLIQ);
        this.DY1 = this.DZ2 * this.S3 - this.DZ3 * this.S2;
        this.DY2 = this.DZ3 * this.S1 - this.DZ1 * this.S3;
        this.DY3 = this.DZ1 * this.S2 - this.DZ2 * this.S1;
        this.CHI = Y1 * this.DY1 + Y2 * this.DY2 + Y3 * this.DY3;
        this.SHI = Y1 * this.DZ1 + Y2 * this.DZ2 + Y3 * this.DZ3;
        this.HI = Math.asin(this.SHI);
        this.SPS = DIP1 * this.S1 + DIP2 * this.S2 + DIP3 * this.S3;
        this.CPS = Math.sqrt(1.0 - this.SPS * this.SPS);
        this.PSI = Math.asin(this.SPS);
        double EXMAGX = this.CT0 * (this.CL0 * this.CGST - this.SL0 * this.SGST);
        double EXMAGY = this.CT0 * (this.CL0 * this.SGST + this.SL0 * this.CGST);
        double EXMAGZ = -this.ST0;
        double EYMAGX = -(this.SL0 * this.CGST + this.CL0 * this.SGST);
        double EYMAGY = -(this.SL0 * this.SGST - this.CL0 * this.CGST);
        this.CFI = Y1 * EYMAGX + Y2 * EYMAGY;
        this.SFI = Y1 * EXMAGX + Y2 * EXMAGY + Y3 * EXMAGZ;
        this.A11 = this.S1 * this.CGST + this.S2 * this.SGST;
        this.A12 = -this.S1 * this.SGST + this.S2 * this.CGST;
        this.A13 = this.S3;
        this.A21 = Y1 * this.CGST + Y2 * this.SGST;
        this.A22 = -Y1 * this.SGST + Y2 * this.CGST;
        this.A23 = Y3;
        this.A31 = Z1 * this.CGST + Z2 * this.SGST;
        this.A32 = -Z1 * this.SGST + Z2 * this.CGST;
        this.A33 = Z3;
    }

    private void sunPosition(TimeScale ut) {
        this.sunPosition(ut.get(1), ut.get(6), ut.get(11), ut.get(12), ut.get(13));
    }

    private void sunPosition(int IYR, int IDAY, int IHOUR, int MIN, int ISEC) {
        if (IYR < 1901 || IYR > 2099) {
            return;
        }
        double FDAY = ((double)IHOUR * 3600.0 + (double)MIN * 60.0 + (double)ISEC) / 86400.0;
        double DJ = (double)(365 * (IYR - 1900) + (IYR - 1901) / 4 + IDAY) - 0.5 + FDAY;
        double T = DJ / 36525.0;
        double VL = (279.696678 + 0.9856473354 * DJ) % 360.0;
        this.GST = (279.690983 + 0.9856473354 * DJ + 360.0 * FDAY + 180.0) % 360.0 / 57.29577951308232;
        double G = (358.475845 + 0.985600267 * DJ) % 360.0 / 57.29577951308232;
        this.SLONG = (VL + (1.91946 - 0.004789 * T) * Math.sin(G) + 0.020094 * Math.sin(2.0 * G)) / 57.29577951308232;
        if (this.SLONG > 6.2831853) {
            this.SLONG -= 6.2831853;
        }
        if (this.SLONG < 0.0) {
            this.SLONG += 6.2831853;
        }
        double OBLIQ = (23.45229 - 0.0130125 * T) / 57.29577951308232;
        double SOB = Math.sin(OBLIQ);
        double SLP = this.SLONG - 9.924E-5;
        double SIND = SOB * Math.sin(SLP);
        double COSD = Math.sqrt(1.0 - SIND * SIND);
        double SC = SIND / COSD;
        this.SDEC = Math.atan(SC);
        this.SRASN = 3.141592654 - Math.atan2(Math.cos(OBLIQ) / SOB * SC, -Math.cos(SLP) / COSD);
    }

    public void sunGEI(double[] out) {
        out[0] = this.S1;
        out[1] = this.S2;
        out[2] = this.S3;
    }

    public void GeoToMag(double[] geo, double[] mag) {
        this.recalc(this.timeUT.get(1), 1, 25, 0, 0);
        mag[0] = geo[0] * this.CTCL + geo[1] * this.CTSL - geo[2] * this.ST0;
        mag[1] = geo[1] * this.CL0 - geo[0] * this.SL0;
        mag[2] = geo[0] * this.STCL + geo[1] * this.STSL + geo[2] * this.CT0;
    }

    public void MagToGeo(double[] mag, double[] geo) {
        this.recalc(this.timeUT.get(1), 0, 25, 0, 0);
        geo[0] = mag[0] * this.CTCL - mag[1] * this.SL0 + mag[2] * this.STCL;
        geo[1] = mag[0] * this.CTSL + mag[1] * this.CL0 + mag[2] * this.STSL;
        geo[2] = mag[2] * this.CT0 - mag[0] * this.ST0;
    }

    public void GsmToGse(double[] gsm, double[] gse) {
        gse[0] = gsm[0];
        gse[1] = gsm[1] * this.CHI - gsm[2] * this.SHI;
        gse[2] = gsm[1] * this.SHI + gsm[2] * this.CHI;
    }

    public void GseToGsm(double[] gse, double[] gsm) {
        gsm[0] = gse[0];
        gsm[1] = gse[1] * this.CHI + gse[2] * this.SHI;
        gsm[2] = gse[2] * this.CHI - gse[1] * this.SHI;
    }

    public void GeoToGsm(double[] geo, double[] gsm) {
        gsm[0] = this.A11 * geo[0] + this.A12 * geo[1] + this.A13 * geo[2];
        gsm[1] = this.A21 * geo[0] + this.A22 * geo[1] + this.A23 * geo[2];
        gsm[2] = this.A31 * geo[0] + this.A32 * geo[1] + this.A33 * geo[2];
    }

    public void GsmToGeo(double[] gsm, double[] geo) {
        geo[0] = this.A11 * gsm[0] + this.A21 * gsm[1] + this.A31 * gsm[2];
        geo[1] = this.A12 * gsm[0] + this.A22 * gsm[1] + this.A32 * gsm[2];
        geo[2] = this.A13 * gsm[0] + this.A23 * gsm[1] + this.A33 * gsm[2];
    }

    public void SmToGsm(double[] sm, double[] gsm) {
        gsm[0] = sm[0] * this.CPS + sm[2] * this.SPS;
        gsm[1] = sm[1];
        gsm[2] = -sm[0] * this.SPS + sm[2] * this.CPS;
    }

    public void GsmToSm(double[] gsm, double[] sm) {
        sm[0] = gsm[0] * this.CPS - gsm[2] * this.SPS;
        sm[1] = gsm[1];
        sm[2] = gsm[0] * this.SPS + gsm[2] * this.CPS;
    }

    public static double getMLT(double xSM, double ySM) {
        return (12.0 + Math.atan2(ySM, xSM) * 12.0 / Math.PI) % 24.0;
    }

    public void GeiToGse(double[] gei, double[] gse) {
        gse[0] = this.S1 * gei[0] + this.S2 * gei[1] + this.S3 * gei[2];
        gse[1] = this.DY1 * gei[0] + this.DY2 * gei[1] + this.DY3 * gei[2];
        gse[2] = this.DZ1 * gei[0] + this.DZ2 * gei[1] + this.DZ3 * gei[2];
    }

    public void GseToGei(double[] gse, double[] gei) {
        gei[0] = this.S1 * gse[0] + this.DY1 * gse[1] + this.DZ1 * gse[2];
        gei[1] = this.S2 * gse[0] + this.DY2 * gse[1] + this.DZ2 * gse[2];
        gei[2] = this.S3 * gse[0] + this.DY3 * gse[1] + this.DZ3 * gse[2];
    }

    public void GeiToGeo(double[] gei, double[] geo) {
        geo[0] = this.CGST * gei[0] + this.SGST * gei[1];
        geo[1] = -this.SGST * gei[0] + this.CGST * gei[1];
        geo[2] = gei[2];
    }

    public void GeoToGei(double[] geo, double[] gei) {
        gei[0] = this.CGST * geo[0] - this.SGST * geo[1];
        gei[1] = this.SGST * geo[0] + this.CGST * geo[1];
        gei[2] = geo[2];
    }

    public void GeiToMag(double[] gei, double[] mag) {
        double[] tmp = new double[3];
        this.GeiToGeo(gei, tmp);
        this.GeoToMag(tmp, mag);
    }

    public void MagToGei(double[] mag, double[] gei) {
        double[] tmp = new double[3];
        this.MagToGeo(mag, tmp);
        this.GeoToGei(tmp, gei);
    }

    public void GeoToSm(double[] geo, double[] sm) {
        double[] gsm = new double[3];
        this.GeoToGsm(geo, gsm);
        this.GsmToSm(gsm, sm);
    }

    public void SmToGeo(double[] sm, double[] geo) {
        double[] gsm = new double[3];
        this.SmToGsm(sm, gsm);
        this.GsmToGeo(gsm, geo);
    }

    public void GeiToGsm(double[] gei, double[] gsm) {
        double[] geo = new double[3];
        this.GeiToGeo(gei, geo);
        this.GeoToGsm(geo, gsm);
    }

    public void GsmToGei(double[] gsm, double[] gei) {
        double[] geo = new double[3];
        this.GsmToGeo(gsm, geo);
        this.GeoToGei(geo, gei);
    }

    public void GeiToGeomap(double[] gei, double[] geomap) {
        double[] geo = new double[3];
        this.GeiToGeo(gei, geo);
        Geopack.cartToSpher(geo, geomap);
        Geopack.spherToGeomap(geomap);
    }

    public void GeomapToGei(double[] geomap, double[] gei) {
        double[] geo = new double[3];
        Geopack.geomapToSpher(geomap, geo);
        Geopack.spherToCart(geo);
        this.GeoToGei(geo, gei);
    }

    public void GeiToMagmap(double[] gei, double[] magmap) {
        double[] mag = new double[3];
        this.GeiToMag(gei, mag);
        Geopack.cartToSpher(mag, magmap);
        Geopack.spherToGeomap(magmap);
    }

    public void magmapToGei(double[] magmap, double[] gei) {
        double[] mag = new double[3];
        Geopack.geomapToSpher(magmap, mag);
        Geopack.spherToCart(mag);
        this.MagToGei(mag, gei);
    }

    public void smToGeomap(double[] sm, double[] geomap) {
        double[] geo = new double[3];
        this.SmToGeo(sm, geo);
        Geopack.cartToSpher(geo);
        Geopack.spherToGeomap(geo, geomap);
    }

    public void geomapToSm(double[] geomap, double[] sm) {
        double[] geo = new double[3];
        Geopack.geomapToSpher(geomap, geo);
        Geopack.spherToCart(geo);
        this.GeoToSm(geo, sm);
    }

    public void geomapToMagmap(double[] geomap, double[] magmap) {
        double[] tmp = new double[3];
        Geopack.geomapToSpher(geomap, tmp);
        Geopack.spherToCart(tmp);
        this.GeoToMag(tmp, magmap);
        Geopack.cartToSpher(magmap);
        Geopack.spherToGeomap(magmap);
    }

    public void magmapToGeomap(double[] magmap, double[] geomap) {
        double[] tmp = new double[3];
        Geopack.geomapToSpher(magmap, tmp);
        Geopack.spherToCart(tmp);
        this.MagToGeo(tmp, geomap);
        Geopack.cartToSpher(geomap);
        Geopack.spherToGeomap(geomap);
    }

    public static void spherToGeomap(double[] coord) {
        Geopack.spherToGeomap(coord, coord);
    }

    public static void spherToGeomap(double[] spher, double[] geomap) {
        geomap[1] = Math.toDegrees(spher[1]);
        geomap[0] = 90.0 - Math.toDegrees(spher[0]);
        geomap[2] = spher[2] - 6371.2;
    }

    public static void geomapToSpher(double[] coord) {
        Geopack.geomapToSpher(coord, coord);
    }

    public static void geomapToSpher(double[] geomap, double[] spher) {
        spher[1] = Math.toRadians(geomap[1]);
        spher[0] = Math.toRadians(90.0 - geomap[0]);
        spher[2] = geomap[2] + 6371.2;
    }

    public static void cartToSpher(double[] coord) {
        Geopack.cartToSpher(coord, coord);
    }

    public static void cartToSpher(double[] cart, double[] spher) {
        double radius;
        double azimuth = cart[0] != 0.0 || cart[1] != 0.0 ? Math.atan2(cart[1], cart[0]) : 0.0;
        if (azimuth < 0.0) {
            azimuth += Math.PI * 2;
        }
        double polarAngle = (radius = Math.sqrt(cart[0] * cart[0] + cart[1] * cart[1] + cart[2] * cart[2])) > 0.0 ? Math.acos(cart[2] / radius) : 0.0;
        spher[1] = azimuth;
        spher[0] = polarAngle;
        spher[2] = radius;
    }

    public static void spherToCart(double[] coord) {
        Geopack.spherToCart(coord, coord);
    }

    public static void spherToCart(double[] spher, double[] cart) {
        double x = spher[2] * Math.sin(spher[0]) * Math.cos(spher[1]);
        double y = spher[2] * Math.sin(spher[0]) * Math.sin(spher[1]);
        double z = spher[2] * Math.cos(spher[0]);
        cart[0] = x;
        cart[1] = y;
        cart[2] = z;
    }

    public static void localToGeoWithGeomapInRad(double[] local, double[] geomap, double[] geo) {
        Geopack.localToGeoWithGeomapInRad(local, 1.5707963267948966 - geomap[0], geomap[1], geo);
    }

    public static void localToGeoWithGeomapInRad(double[] local, double polarAngleInRad, double lonInRad, double[] geo) {
        geo[0] = (local[0] * Math.cos(polarAngleInRad) + local[2] * Math.sin(polarAngleInRad)) * Math.cos(lonInRad) - local[1] * Math.sin(lonInRad);
        geo[1] = (local[0] * Math.cos(polarAngleInRad) + local[2] * Math.sin(polarAngleInRad)) * Math.sin(lonInRad) + local[1] * Math.cos(lonInRad);
        geo[2] = -local[0] * Math.sin(polarAngleInRad) + local[2] * Math.cos(polarAngleInRad);
    }

    public void GeoToLocalWithGeomapInRad(double[] geo, double[] geomap, double[] local) {
        double polarAngleInRad = 1.5707963267948966 - geomap[0];
        local[0] = (geo[0] * Math.cos(geomap[1]) + geo[1] * Math.sin(geomap[1])) * Math.cos(polarAngleInRad) - geo[2] * Math.sin(polarAngleInRad);
        local[1] = -geo[0] * Math.sin(geomap[1]) + geo[1] * Math.cos(geomap[1]);
        local[2] = (geo[0] * Math.cos(geomap[1]) + geo[1] * Math.sin(geomap[1])) * Math.sin(polarAngleInRad) + geo[2] * Math.cos(polarAngleInRad);
    }

    public void getMagneticField_GSM(double[] pos_GSM, double[] b_GSM) {
        double[] pos_C = new double[3];
        double[] b_C = new double[3];
        double[] b_C1 = new double[3];
        double[][] db_C = new double[3][3];
        double[][] db_C1 = new double[3][3];
        double[][] db_GSM = new double[3][3];
        this.GsmToSm(pos_GSM, pos_C);
        this.getMagnetDipoleCart(pos_C, b_C, db_C, 1.0);
        this.SmToGsm(b_C, b_GSM);
        this.SmToGsm1(db_C, db_GSM, this.CPS, this.SPS);
        double K = 80.0;
        double xoff = 10.0 * (1.0 + Math.pow(K, 0.3333333333333333));
        pos_C[0] = pos_GSM[0] - xoff;
        pos_C[1] = pos_GSM[1];
        pos_C[2] = pos_GSM[2];
        this.getMagnetDipoleCart(pos_C, b_C, db_C, K);
        Geopack.scaleVector(b_C, this.CPS);
        Geopack.scaleMatrix(db_C, this.CPS);
        Geopack.addVectors(b_GSM, b_C, b_GSM);
        Geopack.addMatrices3x3(db_GSM, db_C, db_GSM);
        K = 25.0;
        xoff = 11.3 * (1.0 + Math.pow(K, 0.3333333333333333));
        pos_C[0] = pos_GSM[2];
        pos_C[1] = pos_GSM[1];
        pos_C[2] = -(pos_GSM[0] - xoff);
        this.getMagnetDipoleCart(pos_C, b_C, db_C, K);
        Geopack.scaleVector(b_C, this.SPS);
        Geopack.scaleMatrix(db_C, this.SPS);
        b_C1[0] = -b_C[2];
        b_C1[1] = b_C[1];
        b_C1[2] = b_C[0];
        Geopack.addVectors(b_GSM, b_C1, b_GSM);
        this.SmToGsm1(db_C, db_C1, 0.0, -1.0);
        Geopack.addMatrices3x3(db_GSM, db_C1, db_GSM);
    }

    public void getMagnetDipoleCart(double[] P, double[] B, double[][] DB, double K) {
        double M = -31100.0 * K;
        double X = P[0];
        double Y = P[1];
        double Z = P[2];
        double R = Math.sqrt(X * X + Y * Y + Z * Z);
        double R5 = Math.pow(R, 5.0);
        double BX = 3.0 * M / R5 * (Z * X);
        double BY = 3.0 * M / R5 * (Z * Y);
        double BZ = M / R5 * (3.0 * Z * Z - R * R);
        B[0] = BX;
        B[1] = BY;
        B[2] = BZ;
        DB[0][0] = 3.0 * M * Z / R5 * (1.0 - 5.0 * (X / R) * (X / R));
        DB[0][1] = BX * (-5.0 * Y / (R * R));
        DB[0][2] = 3.0 * M * X / R5 * (1.0 - 5.0 * (Z / R) * (Z / R));
        DB[1][1] = 3.0 * M * Z / R5 * (1.0 - 5.0 * (Y / R) * (Y / R));
        DB[1][0] = DB[0][1];
        DB[1][2] = 3.0 * M * Y / R5 * (1.0 - 5.0 * (Z / R) * (Z / R));
        DB[2][0] = DB[0][2];
        DB[2][1] = DB[1][2];
        DB[2][2] = M * Z / R5 * (9.0 - 15.0 * (Z / R) * (Z / R));
    }

    private void SmToGsm1(double[][] P, double[][] P1, double COST, double SINT) {
        double[][] A = new double[3][3];
        A[0][0] = COST;
        A[0][2] = SINT;
        A[1][1] = 1.0;
        A[2][0] = -SINT;
        A[2][2] = COST;
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                P1[i][j] = 0.0;
                int k = 0;
                while (k < 3) {
                    int l = 0;
                    while (l < 3) {
                        double[] dArray = P1[i];
                        int n = j;
                        dArray[n] = dArray[n] + A[i][k] * A[j][l] * P[k][l];
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static double ha_0(double mx, double kx, double a) {
        return mx * Math.cos(a) + kx * Math.sin(a);
    }

    public void ppOrbitPlaneIntersect(double[] nn, double[] x, double[] y, double[] z) {
        this.orbitPlaneIntersect(nn, x, y, z, 0);
    }

    public void mpOrbitPlaneIntersect(double[] nn, double[] x, double[] y, double[] z) {
        this.orbitPlaneIntersect(nn, x, y, z, 1);
    }

    private void orbitPlaneIntersect(double[] nn, double[] x, double[] y, double[] z, int type) {
        double[] n = new double[3];
        double[] u = new double[3];
        double[] v = new double[3];
        if (type == 0) {
            this.GeiToGse(nn, u);
            this.GseToGsm(u, v);
            this.GsmToSm(v, n);
        } else {
            this.GeiToGse(nn, u);
            this.GseToGsm(u, n);
        }
        double[] m = new double[3];
        double[] k = new double[3];
        Geopack.con_basis_2(n, m, k);
        int np = x.length;
        double[] r = new double[np];
        double[] a = new double[np];
        if (type == 0) {
            this.pp_0(n, m, k, r, a);
        } else {
            this.mp_0(n, m, k, r, a);
        }
        int i = 0;
        while (i < np) {
            x[i] = r[i] * (m[0] * Math.cos(a[i]) + k[0] * Math.sin(a[i]));
            y[i] = r[i] * (m[1] * Math.cos(a[i]) + k[1] * Math.sin(a[i]));
            z[i] = r[i] * (m[2] * Math.cos(a[i]) + k[2] * Math.sin(a[i]));
            v[0] = x[i];
            v[1] = y[i];
            v[2] = z[i];
            if (type == 0) {
                this.SmToGsm(v, u);
                this.GsmToGse(u, v);
                this.GseToGei(v, u);
            } else {
                this.GsmToGse(v, n);
                this.GseToGei(n, u);
            }
            x[i] = u[0];
            y[i] = u[1];
            z[i] = u[2];
            ++i;
        }
    }

    private void pp_0(double[] n, double[] m, double[] k, double[] r, double[] a) {
        double l = L_SHELL;
        int np = r.length;
        int i = 0;
        while (i < np) {
            a[i] = (double)i / (double)np * 2.0 * Math.PI;
            r[i] = l * (Math.pow(Geopack.ha_0(m[0], k[0], a[i]), 2.0) + Math.pow(Geopack.ha_0(m[1], k[1], a[i]), 2.0));
            ++i;
        }
    }

    private void mp_0(double[] n, double[] m, double[] k, double[] r, double[] a) {
        double[] coef = new double[3];
        double press = 2.5;
        double bz0 = 0.0;
        this.mp_coef_sib(coef, press, bz0);
        double a0 = coef[0];
        double b0 = coef[1];
        double c0 = coef[2];
        int np = r.length;
        int i = 0;
        while (i < np) {
            a[i] = (double)i / (double)(np - 1) * 2.0 * Math.PI;
            double aa = a0 * Math.pow(Geopack.ha_0(m[0], k[0], a[i]), 2.0) + Math.pow(Geopack.ha_0(m[1], k[1], a[i]), 2.0) + Math.pow(Geopack.ha_0(m[2], k[2], a[i]), 2.0);
            double bb = b0 * Geopack.ha_0(m[0], k[0], a[i]);
            double cc = c0;
            r[i] = Geopack.quadMax(aa, bb, cc);
            ++i;
        }
    }

    private void mp_coef_sib(double[] coef, double press, double bz0) {
        double bz = 0.0;
        bz = Math.abs(bz0) > 6.5 ? bz0 / Math.abs(bz0) * 6.5 : bz0;
        double y = bz + 0.1635;
        double x = press / 2.088;
        double z = Math.log(x);
        coef[0] = 0.171 * Math.pow(x, -0.474 - 0.616 * z + 0.023 * y) * Math.exp(-0.043 * y + 0.0391 * y * y);
        coef[1] = 18.8 * Math.pow(x, -0.12 - 0.03 * z + 0.036 * y) * Math.exp(-0.037 * y + 2.0E-4 * y * y);
        coef[2] = -220.8 * Math.pow(x, -0.29 - 0.11 * z + 0.018 * y) * Math.exp(-0.012 * y + 0.0017 * y * y);
    }

    public static void terminatorPoligon(double alpha, double zeta, Polygon pol) {
        double beta = 1.5707963267948966 - alpha;
        int len = pol.xpoints.length;
        int i = 0;
        while (i < len) {
            double y;
            double x;
            double gamma = (double)i * 2.0 / ((double)len - 2.0) * Math.PI;
            if (i < len / 2) {
                x = -Math.sin(beta) * Math.sin(gamma);
                y = Math.cos(gamma);
            } else {
                gamma = Math.PI - gamma;
                x = -Math.sin(gamma);
                y = Math.cos(gamma);
            }
            pol.xpoints[i] = (int)Math.round(6371.2 * (x * Math.cos(zeta) - y * Math.sin(zeta)));
            pol.ypoints[i] = (int)Math.round(6371.2 * (x * Math.sin(zeta) + y * Math.cos(zeta)));
            ++i;
        }
    }

    public static void crossp(double[] v1, double[] v2, double[] out) {
        out[0] = v1[1] * v2[2] - v2[1] * v1[2];
        out[1] = v1[2] * v2[0] - v2[2] * v1[0];
        out[2] = v1[0] * v2[1] - v2[0] * v1[1];
    }

    public static double total(double[] arr) {
        double sum = 0.0;
        int i = 0;
        while (i < arr.length) {
            sum += arr[i];
            ++i;
        }
        return sum;
    }

    public static double normalize(double[] arr) {
        double sum = 0.0;
        int i = 0;
        while (i < arr.length) {
            sum += arr[i] * arr[i];
            ++i;
        }
        double norm = Math.sqrt(sum);
        int i2 = 0;
        while (i2 < arr.length) {
            int n = i2++;
            arr[n] = arr[n] / norm;
        }
        return norm;
    }

    public static void con_basis_2(double[] x, double[] y, double[] z) {
        Geopack.normalize(x);
        int indexOfMaxElement = 0;
        double max = Math.abs(x[0]);
        int i = 1;
        while (i < 3) {
            if (Math.abs(x[i]) > max) {
                max = Math.abs(x[i]);
                indexOfMaxElement = i;
            }
            ++i;
        }
        y[(indexOfMaxElement + 1) % 3] = x[indexOfMaxElement];
        y[indexOfMaxElement] = -x[(indexOfMaxElement + 1) % 3];
        y[(indexOfMaxElement + 2) % 3] = 0.0;
        Geopack.normalize(y);
        Geopack.crossp(x, y, z);
    }

    public static double quadMax(double a, double b, double c) {
        double d = b * b - 4.0 * a * c;
        if (d < 0.0) {
            d = 1000.0;
        }
        double q = -0.5 * (b + Geopack.sgn(b) * Math.sqrt(d));
        return Math.max(q / a, c / q);
    }

    public static double sgn(double x) {
        if (x > 0.0) {
            return 1.0;
        }
        return -1.0;
    }

    public static void addVectors(double[] v1, double[] v2, double[] result) {
        int i = 0;
        while (i < 3) {
            result[i] = v1[i] + v2[i];
            ++i;
        }
    }

    public static void addMatrices3x3(double[][] m1, double[][] m2, double[][] result) {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                result[i][j] = m1[i][j] + m2[i][j];
                ++j;
            }
            ++i;
        }
    }

    public static void scaleVector(double[] v, double scalar) {
        Geopack.scaleVector(v, scalar, v);
    }

    public static void scaleVector(double[] in, double scalar, double[] out) {
        int i = 0;
        while (i < 3) {
            out[i] = in[i] * scalar;
            ++i;
        }
    }

    public static void scaleMatrix(double[][] m, double scalar) {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                double[] dArray = m[i];
                int n = j++;
                dArray[n] = dArray[n] * scalar;
            }
            ++i;
        }
    }

    public static double vectorToAngles(double[] v, double[] cos, double[] angle_deg) {
        double length = Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
        cos[0] = v[0] / length;
        cos[1] = v[1] / length;
        cos[2] = v[2] / length;
        angle_deg[0] = Math.toDegrees(Math.acos(cos[0]));
        angle_deg[1] = Math.toDegrees(Math.acos(cos[1]));
        angle_deg[2] = Math.toDegrees(Math.acos(cos[2]));
        return length;
    }

    private static void readGeodipoleMomentCoeff() {
        int lineCount;
        int qty;
        Vector<Double> vH11;
        Vector<Double> vG11;
        Vector<Double> vG10;
        Vector<TimeScale> vTimes;
        block39: {
            datafileInUse = false;
            datafileErrorCode = 0;
            softwareObsolete = false;
            File datafile = new File(DATAFILE_NAME);
            if (!datafile.isFile()) {
                return;
            }
            double version = 0.0;
            vTimes = new Vector<TimeScale>(50, 50);
            vG10 = new Vector<Double>(50, 50);
            vG11 = new Vector<Double>(50, 50);
            vH11 = new Vector<Double>(50, 50);
            qty = 0;
            BufferedReader br = null;
            lineCount = 0;
            Object dt = null;
            try {
                br = new BufferedReader(new FileReader(datafile));
                while (br.ready()) {
                    String line = br.readLine();
                    if (line == null) break;
                    line = StrUtil.trimRight(line, ' ');
                    if (++lineCount == 1) {
                        if (!line.startsWith(FILE_SIGNATURE)) {
                            Console.showError("Geopack file " + DATAFILE_NAME + ": bad signature");
                            datafileErrorCode = 2;
                        } else {
                            version = FC.StringToDouble(line.substring(FILE_SIGNATURE.length() + 1).trim());
                            if (version < 2.0) {
                                Console.showError("Geopack file " + DATAFILE_NAME + " is obsolete");
                                datafileErrorCode = 10;
                            } else {
                                if (!(version > 3.0)) continue;
                                Console.showError("Geopack file " + DATAFILE_NAME + " has a newer version" + System.lineSeparator() + "you need to upgrade software");
                                softwareObsolete = true;
                            }
                        }
                        break;
                    }
                    if (line.length() == 0 || line.startsWith("#") || line.startsWith(";")) continue;
                    String[] lineData = StrUtil.listToArray(line, ",");
                    if (lineData.length != 4) {
                        Console.showError("Geopack file " + DATAFILE_NAME + " line " + lineCount + ":" + System.lineSeparator() + "  should be exactly four elements divided by comma");
                        datafileErrorCode = 3;
                        break;
                    }
                    vTimes.addElement(TimeScale.parse(lineData[0]));
                    if (!StrUtil.isFloatingPointNumber(lineData[1])) {
                        Console.showError("Geopack file " + DATAFILE_NAME + " line " + lineCount + ": G10 should be number");
                        datafileErrorCode = 5;
                        break;
                    }
                    vG10.addElement(new Double(lineData[1]));
                    if (!StrUtil.isFloatingPointNumber(lineData[2])) {
                        Console.showError("Geopack file " + DATAFILE_NAME + " line " + lineCount + ": G11 should be number");
                        datafileErrorCode = 5;
                        break;
                    }
                    vG11.addElement(new Double(lineData[2]));
                    if (!StrUtil.isFloatingPointNumber(lineData[3])) {
                        Console.showError("Geopack file " + DATAFILE_NAME + " line " + lineCount + ": H11 should be number");
                        datafileErrorCode = 5;
                        break;
                    }
                    vH11.addElement(new Double(lineData[3]));
                    if (qty > 0 && !((TimeScale)vTimes.elementAt(qty - 1)).before(vTimes.elementAt(qty))) {
                        Console.showError("Geopack file " + DATAFILE_NAME + " line " + lineCount + ": date/time should increase");
                        datafileErrorCode = 6;
                        break;
                    }
                    ++qty;
                }
            }
            catch (IOException e) {
                Console.showError("File " + DATAFILE_NAME + " line " + ++lineCount + ":" + System.lineSeparator() + "  " + e.toString());
                datafileErrorCode = 9;
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                break block39;
            }
            catch (Exception e) {
                try {
                    Console.showError("File " + DATAFILE_NAME + " line " + lineCount + ":" + System.lineSeparator() + "  " + e.toString());
                    datafileErrorCode = 4;
                    break block39;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
            if (br == null) break block39;
            try {
                br.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (datafileErrorCode == 0) {
            if (lineCount == 0) {
                datafileErrorCode = 1;
                Console.showError("Geopack file " + DATAFILE_NAME + " of zero length");
            } else if (qty == 0) {
                Console.showError("Geopack file " + DATAFILE_NAME + " doesn't contain entries");
                datafileErrorCode = 7;
            } else if (qty == 1) {
                Console.showError("Geopack file " + DATAFILE_NAME + " contains only one entry");
                datafileErrorCode = 8;
            }
        }
        if (datafileErrorCode != 0 || softwareObsolete) {
            return;
        }
        if (!MAX_DATE.before(vTimes.lastElement())) {
            return;
        }
        TIMES = new TimeScale[qty];
        G10 = new double[qty];
        G11 = new double[qty];
        H11 = new double[qty];
        int i = 0;
        while (i < qty) {
            Geopack.TIMES[i] = (TimeScale)vTimes.elementAt(i);
            Geopack.G10[i] = (Double)vG10.elementAt(i);
            Geopack.G11[i] = (Double)vG11.elementAt(i);
            Geopack.H11[i] = (Double)vH11.elementAt(i);
            ++i;
        }
        datafileInUse = true;
        MIN_DATE = TIMES[0];
        MAX_DATE = new TimeScale(TIMES[TIMES.length - 1].getTimeInMinutes());
        MAX_DATE.add(14, -1);
        MIN_DATE_IN_MINUTES = MIN_DATE.getTimeInMinutes();
        MAX_DATE_IN_MINUTES = MAX_DATE.getTimeInMinutes();
    }

    public double[] getMagneticCoordinates(double[] coords, double altitude, TimeScale time) {
        double[] geoLatLong = new double[]{coords[0], coords[1], altitude};
        double[] magLatLong = new double[3];
        this.recalc(time);
        this.geomapToMagmap(geoLatLong, magLatLong);
        return new double[]{magLatLong[0], magLatLong[1]};
    }

    public double[] getMagneticCoordinates(double[] coords, TimeScale time) {
        return this.getMagneticCoordinates(coords, 0.0, time);
    }
}

