/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.format.Formatter;

public class GroundCoord {
    private static final int TO_MAGNETIC = 0;
    private static final int TO_GEOGRAPHICAL = 1;
    private double latitude = 0.0;
    private double longitude = 0.0;
    private double magLatitude;
    private double magLongitude;

    public GroundCoord(double latitude, double longitude) {
        this.setGeoCoord(latitude, longitude);
    }

    public void setGeoCoord(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.calc(0);
    }

    public void setMagCoord(double magLatitude, double magLongitude) {
        this.magLatitude = magLatitude;
        this.magLongitude = magLongitude;
        this.calc(1);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getMagLatitude() {
        return this.magLatitude;
    }

    public double getMagLongitude() {
        return this.magLongitude;
    }

    private void calc(int convertDirection) {
        double twoPI = Math.PI * 2;
        double cbg = Math.toRadians(11.4);
        double ci = Math.cos(cbg);
        double si = Math.sin(cbg);
        if (convertDirection == 0) {
            double ylg = this.longitude + 69.8;
            cbg = Math.cos(Math.toRadians(this.latitude));
            double sbg = Math.sin(Math.toRadians(this.latitude));
            double clg = Math.cos(Math.toRadians(ylg));
            double slg = Math.sin(Math.toRadians(ylg));
            double sbm = sbg * ci + cbg * clg * si;
            sbm = Math.max(Math.min(sbm, 1.0), -1.0);
            this.magLatitude = Math.asin(sbm);
            double cbm = Math.cos(this.magLatitude);
            double slm = cbg * slg / cbm;
            double clm = (-sbg * si + cbg * clg * ci) / cbm;
            clm = Math.max(Math.min(clm, 1.0), -1.0);
            this.magLongitude = Math.acos(clm);
            if (slm < 0.0) {
                this.magLongitude = twoPI - this.magLongitude;
            }
            this.magLatitude = Math.toDegrees(this.magLatitude);
            this.magLongitude = Math.toDegrees(this.magLongitude);
            return;
        }
        double cbm = Math.cos(Math.toRadians(this.magLatitude));
        double sbm = Math.sin(Math.toRadians(this.magLatitude));
        double clm = Math.cos(Math.toRadians(this.magLongitude));
        double slm = Math.sin(Math.toRadians(this.magLongitude));
        double sbg = sbm * ci - cbm * clm * si;
        sbg = Math.max(Math.min(sbg, 1.0), -1.0);
        this.latitude = Math.asin(sbg);
        cbg = Math.cos(this.latitude);
        double slg = cbm * slm / cbg;
        double clg = (sbm * si + cbm * clm * ci) / cbg;
        clg = Math.max(Math.min(clg, 1.0), -1.0);
        this.longitude = Math.acos(clg);
        if (slg < 0.0) {
            this.longitude = twoPI - this.longitude;
        }
        this.latitude = Math.toDegrees(this.latitude);
        this.longitude = Math.toDegrees(this.longitude);
        this.longitude -= 69.8;
        if (this.longitude < 0.0) {
            this.longitude += twoPI;
        }
    }

    public String toString(boolean special) {
        if (!special) {
            return this.toString();
        }
        return String.valueOf(Formatter.format("%4.1f", Math.abs(this.getLatitude())).trim()) + " " + (this.getLatitude() >= 0.0 ? (char)'N' : 'S') + "   " + (this.getLongitude() <= 180.0 ? String.valueOf(Formatter.format("%5.1f", Math.abs(this.getLongitude())).trim()) + " " + 'E' : String.valueOf(Formatter.format("%5.1f", Math.abs(360.0 - this.getLongitude())).trim()) + " " + 'W');
    }

    public String toString() {
        return String.valueOf(Formatter.format("%4.1f", Math.abs(this.getLatitude()))) + " " + (this.getLatitude() >= 0.0 ? (char)'N' : 'S') + "   " + Formatter.format("%5.1f", Math.abs(this.getLongitude())) + " E";
    }
}

