/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.geospace.SunSpots;
import edu.uml.lgdc.project.CommonConst;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.time.TimeScale;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;

public class IG12 {
    public static final String IG12_FILENAME = "ig_rz.dat";
    private static final String IG12_FILEPATH;
    private static final int MAX_NUMBER_OF_YEARS = 100;
    private static final String SPACES = "                                                                                          ";
    private static String fileName;
    private static boolean loaded;
    private static double[][] igValues;
    private static int firstYear;
    private static int firstMonth;
    private static int qtyOfYears;
    private static int lastDataYear;
    private static int lastDataMonth;
    private static TimeScale releaseDate;
    private static IG12 ig12;
    public static final double IG_UNKNOWN = -1000.0;
    public static final int IG_PREDICTED = 100;
    public static final int IG_ACTUAL = 101;
    public static final int IG_MISSING = 102;
    public static final int IG_SUNSPOT_ACTUAL = 103;
    public static final int IG_SUNSPOT_PREDICTED = 104;
    private int year;
    private int month;
    private double value;
    private int status;

    static {
        fileName = IG12_FILEPATH = new File(CommonConst.getShareResourcesDir(), IG12_FILENAME).getPath();
        loaded = false;
        igValues = null;
        firstYear = 0;
        firstMonth = 0;
        qtyOfYears = 0;
        lastDataYear = 0;
        lastDataMonth = 0;
        releaseDate = new TimeScale();
    }

    private IG12(int year, int month, double value, int status) {
        if (status != 100 && status != 101 && status != 102 && status != 103 && status != 104) {
            throw new IllegalArgumentException("Call to IG12 with illegal status " + status + ", should be " + 100 + ", " + 101 + ", " + 102 + ", " + 104 + ", or " + 104);
        }
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Call to IG12 with illegal month number: " + month);
        }
        if (year < 1 || year > 3000) {
            throw new IllegalArgumentException("Call to IG12 with illegal year: " + year);
        }
        if (status != 102 && value < -100.0 || value > 300.0) {
            throw new IllegalArgumentException("Call to IG12 with value out of bounds: " + value);
        }
        if (status == 102 && value != -1000.0 || value == -1000.0 && status != 102) {
            throw new IllegalArgumentException("incompatible values for status and number, " + status + " and " + value);
        }
        this.year = year;
        this.month = month;
        this.value = value;
        this.status = status;
    }

    public double getNumber() {
        return this.value;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isAvailable() {
        return this.status != 102;
    }

    public boolean isPredicted() {
        return this.status == 100;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public static IG12 get(TimeScale date) {
        return IG12.get(date.get(1), date.get(2) + 1);
    }

    public static synchronized IG12 get(int year, int month) {
        if (!loaded) {
            IG12.load();
        }
        if (ig12 != null && year == IG12.ig12.year && month == IG12.ig12.month) {
            return ig12;
        }
        ig12 = IG12.getValue(year, month);
        return ig12;
    }

    /*
     * Unable to fully structure code
     */
    private static synchronized void load() {
        block21: {
            block19: {
                block20: {
                    error = false;
                    in = null;
                    in = new BufferedReader(new FileReader(IG12.fileName));
                    IG12.initMemory();
                    if (IG12.loadHeader(in)) break block19;
                    if (in == null) break block20;
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                return;
            }
            try {
                try {
                    IG12.loaded = true;
                    currentYear = 0;
                    while (in.ready()) {
                        line = in.readLine();
                        if (line == null || line.length() == 0 || !Character.isDigit(line.charAt(2))) break;
                        if (line.length() < 72) {
                            line = String.valueOf(line) + "                                                                                          ".substring(0, 72 - line.length());
                        }
                        tokens = line.split(",");
                        i = 0;
                        while (i < tokens.length) {
                            IG12.igValues[currentYear][i] = new Double(tokens[i]);
                            ++i;
                        }
                        ++currentYear;
                    }
                    if (currentYear == IG12.lastDataYear - IG12.firstYear + 1) break block21;
                    Console.showError("Formatting error in IG12 file: number of data lines is less than expected number of years");
                }
                catch (Exception ex) {
                    System.out.println("Can't load IG12 iindex dataset:");
                    System.out.println(ex.toString());
                    error = true;
                    if (in == null) ** GOTO lbl62
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (Throwable var6_11) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                throw var6_11;
            }
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
lbl62:
        // 7 sources

        if (error) {
            IG12.igValues = null;
        }
    }

    private static void initMemory() {
        if (igValues == null) {
            igValues = new double[100][12];
        }
        int i = 0;
        while (i < igValues.length) {
            int j = 0;
            while (j < 12) {
                IG12.igValues[i][j] = -1000.0;
                ++j;
            }
            ++i;
        }
    }

    private static boolean loadHeader(BufferedReader in) throws IOException {
        String line = in.readLine();
        if (line == null) {
            return false;
        }
        String[] tokens = line.split(",");
        try {
            releaseDate.setTime(TimeScale.parseSmart(String.valueOf(tokens[2]) + "." + tokens[0] + "." + tokens[1]));
        }
        catch (ParseException e) {
            Console.showError("Error parsing release date in IG12 index file");
            return false;
        }
        line = in.readLine();
        if (line == null) {
            return false;
        }
        line = in.readLine();
        if (line == null) {
            return false;
        }
        tokens = line.split(",");
        firstYear = new Integer(tokens[1]);
        firstMonth = new Integer(tokens[0]);
        lastDataYear = new Integer(tokens[3]);
        lastDataMonth = new Integer(tokens[2]);
        qtyOfYears = lastDataYear - firstYear + 1;
        line = in.readLine();
        if (line == null) {
            return false;
        }
        return firstMonth != 1 || (line = in.readLine()) != null;
    }

    private static synchronized IG12 getValue(int year, int month) {
        double igValue = -1000.0;
        int status = 102;
        TimeScale timestamp = new TimeScale(year, month, 1, 0, 0, 0);
        if (igValues != null && year >= firstYear && year < firstYear + 100) {
            igValue = igValues[year - firstYear][month - 1];
        }
        if (igValue != -1000.0) {
            status = timestamp.after(releaseDate) ? 100 : 101;
        } else {
            SunSpots issn = SunSpots.get(timestamp);
            igValue = issn.getNumber();
            switch (issn.getStatus()) {
                case 1: {
                    status = 103;
                    break;
                }
                case 0: {
                    status = 104;
                    break;
                }
                default: {
                    status = 102;
                }
            }
        }
        return new IG12(year, month, igValue, status);
    }
}

