/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.fileio.FileUtils;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.format.IonexMap;
import edu.uml.lgdc.format.IonexRecordSet;
import edu.uml.lgdc.geospace.Geomap;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.time.TimeScale;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class IGSRealTimeVTECGetter {
    static final String PREF_REALTIME_VTEC = "https://igsiono.uwm.edu.pl/data/gambit/";
    private TimeScale currentTov = null;
    private int currentTovYear = -1;
    private int currentTovDOY = -1;
    private IonexRecordSet rtTec = new IonexRecordSet();
    private boolean oneDayFileFound = false;
    private String rootPath_RTTEC = null;

    public IGSRealTimeVTECGetter(String rootPath_RTTEC) {
        this.rootPath_RTTEC = new String(rootPath_RTTEC);
    }

    public IonexRecordSet downloadRTTEC(TimeScale tov) {
        if (this.currentTov != null && (this.oneDayFileFound ? this.currentTovYear == tov.get(1) && this.currentTovDOY == tov.get(6) : tov.equals(this.currentTov))) {
            return this.rtTec;
        }
        String filename = IGSRealTimeVTECGetter.makeRtTecFilenameDaily(tov);
        String path = String.valueOf(this.rootPath_RTTEC) + FC.IntegerToString(tov.get(1), 4, '0') + File.separator + FC.IntegerToString(tov.get(6), 3, '0') + File.separator;
        File localFile = new File(path, filename);
        if (!localFile.exists()) {
            URLConnection connection;
            block6: {
                File destinationDir = new File(path);
                destinationDir.mkdirs();
                String urlName = PREF_REALTIME_VTEC + FC.IntegerToString(tov.get(1), 4, '0') + "/" + filename;
                Console.showMsg("Starting download of Real-Time VTEC for " + tov.toHumanUT() + " from " + urlName + "...");
                try {
                    URL url = new URL(urlName);
                    connection = url.openConnection();
                    int contentLength = connection.getContentLength();
                    if (contentLength >= 300) break block6;
                    return null;
                }
                catch (IOException e) {
                    Console.showError("Error retrieving data from " + urlName);
                    return null;
                }
            }
            InputStream is = connection.getInputStream();
            FileUtils.streamToFile(is, localFile);
            Console.showMsg("done.");
        }
        if (this.readRtTec(localFile)) {
            this.currentTov = tov;
            this.oneDayFileFound = true;
            this.currentTovYear = tov.get(1);
            this.currentTovDOY = tov.get(6);
        }
        return this.rtTec;
    }

    public boolean dataAvailable() {
        return this.rtTec != null;
    }

    private boolean readRtTec(File localFile) {
        if (!localFile.exists()) {
            return false;
        }
        return IonexMap.read(this.rtTec, localFile.getAbsolutePath());
    }

    public static String makeRtTecFilename(TimeScale tov) {
        return "gmbt" + FC.IntegerToString(tov.get(6), 3, '0') + "_" + FC.IntegerToString(tov.get(11), 2, '0') + FC.IntegerToString(tov.get(12), 2, '0') + "." + FC.IntegerToString(tov.get(1) % 100, 2, '0') + "i";
    }

    public static String makeRtTecFilenameDaily(TimeScale tov) {
        return "gmrt" + FC.IntegerToString(tov.get(6), 3, '0') + "0." + FC.IntegerToString(tov.get(1) % 100, 2, '0') + "i";
    }

    public double[] getIonexMap(TimeScale time) {
        return this.rtTec.getMap(this.rtTec.getGrid().getIndex(time));
    }

    public boolean fillGambitMap(Geomap map, TimeScale time) {
        return map.setIonexMapValues(this.getIonexMap(time), this.rtTec.getGrid());
    }
}

