/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.fileio.FileUtils;
import edu.uml.lgdc.geospace.GeoMagIndexChoice;
import edu.uml.lgdc.geospace.Getter;
import edu.uml.lgdc.geospace.KyotoDSTParser;
import edu.uml.lgdc.project.commandlineparams.CommandLineParam;
import edu.uml.lgdc.time.TimeScale;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;

public class KyotoDSTGetter
extends Getter {
    public static final String[] KEYS = new String[]{"dst_path", "update_once", "numupdates"};
    public static final CommandLineParam.KeyType[] KEY_TYPES = new CommandLineParam.KeyType[]{CommandLineParam.KeyType.VALUE_ONLY, CommandLineParam.KeyType.KEY_ONLY, CommandLineParam.KeyType.VALUE_ONLY};
    public static final int NUMBER_UPDATES_PER_DAY = 4;
    static final String PREF_DST_FINAL = "http://wdc.kugi.kyoto-u.ac.jp/dst_final/";
    static final String PREF_DST_PROVISIONAL = "http://wdc.kugi.kyoto-u.ac.jp/dst_provisional/";
    static final String PREF_DST_REALTIME = "http://wdc.kugi.kyoto-u.ac.jp/dst_realtime/";
    static final String DOCUMENT = "index.html";
    static final int OLDEST_YEAR = 1957;
    private String rootPath_dst = null;
    private boolean update_once = false;
    private int updates_per_day = 4;

    static {
        if (KEYS.length != KEY_TYPES.length) {
            throw new RuntimeException("KEYS.length != KEY_TYPES.length");
        }
    }

    public KyotoDSTGetter(String rootPath_dst, boolean update_once, int updates_per_day) {
        this.rootPath_dst = new String(rootPath_dst);
        this.update_once = update_once;
        this.updates_per_day = updates_per_day;
    }

    private void updateData() {
        if (!this.update_once) {
            Timer processingTimer = new Timer();
            processingTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (KyotoDSTGetter.this.rootPath_dst != null) {
                        KyotoDSTGetter.this.getRecentData(KyotoDSTGetter.this.rootPath_dst);
                    }
                }
            }, 0L, (long)(86400000 / this.updates_per_day));
        }
    }

    @Override
    protected boolean getFile(File file, int year) {
        return KyotoDSTGetter.getYearDataNOAAFormat(file, year);
    }

    @Override
    protected GeoMagIndexChoice getIndexID() {
        return GeoMagIndexChoice.DST;
    }

    public static boolean getYearDataNOAAFormat(File file, int year) {
        if (file.exists()) {
            file.delete();
        }
        File[] docs = new File[12];
        Character[] category = new Character[12];
        int i = 0;
        while (i < 12) {
            docs[i] = new File(file.getParent(), "temp_" + KyotoDSTParser.getYearMonthID(year, i + 1) + ".txt");
            if (docs[i].exists()) {
                docs[i].delete();
            }
            category[i] = KyotoDSTGetter.getDocument(docs[i], year, i + 1);
            if (category[i] == null) {
                docs[i] = null;
                if (year != new TimeScale().get(1)) {
                    return false;
                }
            }
            ++i;
        }
        if (docs[0] == null) {
            return false;
        }
        KyotoDSTParser.kyotoDST2NOAAFormat(file.getAbsolutePath(), docs, category, year);
        return true;
    }

    private static Character getDocument(File file, int year, int month) {
        TimeScale now = new TimeScale();
        String name = null;
        String category = null;
        if (year < 1957 || year > now.get(1)) {
            System.out.println("Year must be from 1957 to " + now.get(1));
            return null;
        }
        if (year == now.get(1) && month - 1 > now.get(2)) {
            System.out.println("Month must not be greater than " + TimeScale.fullNameOfMonth(now.get(2) + 1));
            return null;
        }
        name = KyotoDSTParser.getYearMonthID(year, month);
        if (file.exists()) {
            file.delete();
        }
        if ((category = KyotoDSTGetter.findCategory(file, year, month)) == null) {
            return null;
        }
        System.out.println("[" + new TimeScale().toHumanUT() + "] Data requested for year = " + year + " and month = " + month + " are in " + category + " category");
        if (FileUtils.copyURLToFile(String.valueOf(category) + name + "/" + DOCUMENT, file)) {
            if (category.equals(PREF_DST_FINAL)) {
                return Character.valueOf('*');
            }
            if (category.equals(PREF_DST_PROVISIONAL)) {
                return Character.valueOf('P');
            }
            if (category.equals(PREF_DST_REALTIME)) {
                return Character.valueOf('Q');
            }
            return null;
        }
        return null;
    }

    private static String findCategory(File file, int year, int month) {
        File doc = new File(file.getParent(), "temp_catergory.txt");
        if (doc.exists()) {
            doc.delete();
        }
        FileUtils.copyURLToFile("http://wdc.kugi.kyoto-u.ac.jp/dst_realtime/index.html", doc);
        if (KyotoDSTParser.checkDataInCategory(doc.getAbsolutePath(), year, month)) {
            doc.delete();
            return PREF_DST_REALTIME;
        }
        FileUtils.copyURLToFile("http://wdc.kugi.kyoto-u.ac.jp/dst_provisional/index.html", doc);
        if (KyotoDSTParser.checkDataInCategory(doc.getAbsolutePath(), year, month)) {
            doc.delete();
            return PREF_DST_PROVISIONAL;
        }
        FileUtils.copyURLToFile("http://wdc.kugi.kyoto-u.ac.jp/dst_final/index.html", doc);
        if (KyotoDSTParser.checkDataInCategory(doc.getAbsolutePath(), year, month)) {
            doc.delete();
            return PREF_DST_FINAL;
        }
        System.out.println("Could not find data for specified year = " + year + " and month = " + month);
        return null;
    }

    public static void main(String[] args) {
        String dst_path = null;
        boolean update_once = false;
        int numUpdates = 0;
        CommandLineParam commandLineParam = new CommandLineParam(args);
        String errMsg = commandLineParam.checkParams(KEYS, KEY_TYPES, true);
        if (errMsg != null) {
            System.out.println(errMsg);
            System.exit(1);
        }
        if ((dst_path = KyotoDSTGetter.parseDstPath(commandLineParam, "")).equals("")) {
            System.out.println("Specify dst root path. Program will exit.");
            System.exit(1);
        }
        numUpdates = (numUpdates = KyotoDSTGetter.parseUpdatesPerDay(commandLineParam)) == 0 ? 4 : numUpdates;
        update_once = commandLineParam.isKeyExists("update_once");
        KyotoDSTGetter getter = new KyotoDSTGetter(dst_path, update_once, numUpdates);
        getter.updateData();
    }
}

