/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

public enum Layer {
    D("D-layer", "D", 0),
    E("E-layer", "E", 1),
    F1("F1-layer", "F1", 2),
    F2("F2-layer", "F2", 3),
    ES("Es-layer", "Es", 4),
    EA("Ea-layer", "Ea", 5),
    UNKNOWN("Unknown", "U", -1),
    ALL("All", "A", 99);

    private final String name;
    private final String symbol;
    private final int ident;

    private Layer(String name, String symbol, int ident) {
        this.name = name;
        this.symbol = symbol;
        this.ident = ident;
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public int getIdent() {
        return this.ident;
    }

    public static Layer getBySymbol(String s) {
        Layer layer = UNKNOWN;
        Layer[] layerArray = Layer.values();
        int n = layerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Layer l = layerArray[n2];
            if (l.symbol == s) {
                layer = l;
                break;
            }
            ++n2;
        }
        return layer;
    }

    public static Layer getByIdent(int ident) {
        Layer layer = UNKNOWN;
        Layer[] layerArray = Layer.values();
        int n = layerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Layer l = layerArray[n2];
            if (l.ident == ident) {
                layer = l;
                break;
            }
            ++n2;
        }
        return layer;
    }
}

