/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.geospace.IGRF;
import edu.uml.lgdc.time.TimeScale;

public class MagneticEquator {
    private final IGRF igrf = new IGRF();
    public static final int LON_STEPS = 180;
    public static final int LAT_STEPS = 180;
    public static final double LON_STEP_DEGREE = 2.0;
    public static final double LAT_STEP_DEGREE = 1.0;
    private double[][] magneticEquatorLine = new double[2][180];
    private double[][][] lShellLine = new double[2][2][180];
    private TimeScale referenceTime;

    public MagneticEquator() {
        int iLon = 0;
        while (iLon < 180) {
            this.magneticEquatorLine[1][iLon] = (double)iLon * 2.0;
            this.magneticEquatorLine[0][iLon] = 0.0;
            this.lShellLine[0][1][iLon] = (double)iLon * 2.0;
            this.lShellLine[0][0][iLon] = 0.0;
            this.lShellLine[1][1][iLon] = (double)iLon * 2.0;
            this.lShellLine[1][0][iLon] = 0.0;
            ++iLon;
        }
    }

    public double[][] getMagneticEquatorLine() {
        return this.magneticEquatorLine;
    }

    public double[][][] getLShellLine() {
        return this.lShellLine;
    }

    public void calculateMagneticEquatorLine(TimeScale time, double referenceAltitude_km) {
        if (this.referenceTime != null && this.referenceTime.get(1) == time.get(1)) {
            return;
        }
        this.referenceTime = (TimeScale)time.clone();
        double minHorField = Double.MAX_VALUE;
        int iLon = 0;
        while (iLon < 180) {
            minHorField = Double.MAX_VALUE;
            int iLat = 0;
            while (iLat < 180) {
                double lat = 90.0 - (double)iLat * 1.0;
                this.igrf.calc(time, lat, this.magneticEquatorLine[1][iLon], referenceAltitude_km);
                if (Math.abs(this.igrf.dip) < minHorField) {
                    minHorField = Math.abs(this.igrf.dip);
                    this.magneticEquatorLine[0][iLon] = lat;
                }
                ++iLat;
            }
            ++iLon;
        }
    }

    public void calculateLShellLine(TimeScale time, double lshell) {
        this.referenceTime = (TimeScale)time.clone();
        double latLshell = Math.acos(1.0 / Math.sqrt(4.0 * Math.abs(lshell) - 3.0)) * 180.0 / Math.PI;
        double closest1 = Double.MAX_VALUE;
        double closest2 = Double.MAX_VALUE;
        int iLon = 0;
        while (iLon < 180) {
            closest1 = Double.MAX_VALUE;
            closest2 = Double.MAX_VALUE;
            int iLat = 0;
            while (iLat < 180) {
                double lat = 90.0 - (double)iLat * 1.0;
                this.igrf.calc(time, lat, this.lShellLine[0][1][iLon], (lshell == 1.0 ? 0.0 : lshell) * 6371.2 / 4.0);
                if (Math.abs(this.igrf.dip - latLshell) < closest1) {
                    closest1 = Math.abs(this.igrf.dip - latLshell);
                    this.lShellLine[0][0][iLon] = lat;
                }
                this.igrf.calc(time, lat, this.lShellLine[1][1][iLon], (lshell == 1.0 ? 0.0 : lshell) * 6371.2 / 4.0);
                if (Math.abs(this.igrf.dip + latLshell) < closest2) {
                    closest2 = Math.abs(this.igrf.dip + latLshell);
                    this.lShellLine[1][0][iLon] = lat;
                }
                ++iLat;
            }
            ++iLon;
        }
    }
}

