/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.geospace.PlasmaMath;

public class ParabolicLayer {
    private double criticalFrequency_MHz;
    private double peakDensity_cm3;
    private double peakDensity_m3;
    private double peakHeight_km;
    private double halfThickness_km;

    public void init() {
        this.criticalFrequency_MHz = 999.9;
        this.peakDensity_cm3 = -1.0;
        this.peakDensity_m3 = -1.0;
        this.peakHeight_km = 9999.0;
        this.halfThickness_km = 9999.0;
    }

    public boolean isGood() {
        return this.criticalFrequency_MHz != 999.9 && this.peakHeight_km != 9999.0 && this.halfThickness_km != 9999.0;
    }

    public double getCriticalFrequency_MHz() {
        return this.criticalFrequency_MHz;
    }

    public void setCriticalFrequency_MHz(double criticalFrequency_MHz) {
        this.criticalFrequency_MHz = criticalFrequency_MHz;
        this.peakDensity_m3 = PlasmaMath.freq2density_m3(criticalFrequency_MHz);
        this.peakDensity_cm3 = PlasmaMath.freq2density(criticalFrequency_MHz);
    }

    public double getPeakHeight_km() {
        return this.peakHeight_km;
    }

    public void setPeakHeight_km(double peakHeight_km) {
        this.peakHeight_km = peakHeight_km;
    }

    public double getHalfThickness_km() {
        return this.halfThickness_km;
    }

    public void setHalfThickness_km(double halfThickness_km) {
        this.halfThickness_km = halfThickness_km;
    }

    public double getModelVirtualHeight_km(double freq_MHz) {
        if (!this.isGood()) {
            return 9999.0;
        }
        return this.peakHeight_km - this.halfThickness_km + 0.5 * this.halfThickness_km * (freq_MHz / this.criticalFrequency_MHz) * Math.log((this.criticalFrequency_MHz + freq_MHz) / (this.criticalFrequency_MHz - freq_MHz));
    }

    public double getModelHeight_km(double density_m3) {
        if (!this.isGood()) {
            return 9999.0;
        }
        double ratio = density_m3 / this.peakDensity_m3;
        if (ratio > 1.0) {
            return this.peakHeight_km;
        }
        double correction = this.halfThickness_km * Math.sqrt(1.0 - ratio);
        return this.peakHeight_km - correction;
    }

    public double getModelDensity_m3(double height_km) {
        if (!this.isGood()) {
            return -1.0;
        }
        double heightDiff = height_km - this.peakHeight_km;
        double ratio = heightDiff / this.halfThickness_km;
        double attenuation = 1.0 - ratio * ratio;
        return this.peakDensity_m3 * attenuation;
    }

    public void computeHalfThickness_km(double[] d_m3, double[] h_km) {
        int bestY = 0;
        double bestError2 = Double.MAX_VALUE;
        int Y = 5;
        while (Y < 200) {
            double error2 = 0.0;
            this.setHalfThickness_km(Y);
            int i = 0;
            while (i < d_m3.length) {
                double error = h_km[i] - this.getModelHeight_km(d_m3[i]);
                error2 += error * error;
                ++i;
            }
            if (error2 < bestError2) {
                bestY = Y;
                bestError2 = error2;
            }
            ++Y;
        }
        this.setHalfThickness_km(bestY);
    }

    public String output() {
        String output = "f(MHz)=" + this.criticalFrequency_MHz + ", hm(km)=" + this.peakHeight_km + ", y(km)=" + this.halfThickness_km;
        return output;
    }
}

