/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.geospace.ParabolicLayer;
import edu.uml.lgdc.geospace.TabulatedProfile;

public class ParabolicProfile {
    private ParabolicLayer parabolicE = new ParabolicLayer();
    private ParabolicLayer parabolicF1 = new ParabolicLayer();
    private ParabolicLayer parabolicF2 = new ParabolicLayer();

    public ParabolicLayer getParabolicE() {
        return this.parabolicE.getCriticalFrequency_MHz() == 999.9 ? null : this.parabolicE;
    }

    public void setParabolicE(ParabolicLayer parabolicE) {
        this.parabolicE = parabolicE;
    }

    public ParabolicLayer getParabolicF1() {
        return this.parabolicF1.getCriticalFrequency_MHz() == 999.9 ? null : this.parabolicF1;
    }

    public void setParabolicF1(ParabolicLayer parabolicF1) {
        this.parabolicF1 = parabolicF1;
    }

    public ParabolicLayer getParabolicF2() {
        return this.parabolicF2.getCriticalFrequency_MHz() == 999.9 ? null : this.parabolicF2;
    }

    public void setParabolicF2(ParabolicLayer parabolicF2) {
        this.parabolicF2 = parabolicF2;
    }

    public void compute(TabulatedProfile tp, double hmE, double hmF1, double hmF2) {
        int iPeak = tp.getIndexForHeight(hmE);
        this.parabolicE = ParabolicProfile.computeParabolic(tp, tp.start_E, iPeak);
        if (hmF1 != 9999.0) {
            iPeak = tp.getIndexForHeight(hmF1);
            this.parabolicF1 = ParabolicProfile.computeParabolic(tp, tp.start_F1, iPeak);
        } else {
            this.parabolicF1 = new ParabolicLayer();
            this.parabolicF1.init();
        }
        iPeak = tp.getIndexForHeight(hmF2);
        this.parabolicF2 = ParabolicProfile.computeParabolic(tp, tp.start_F2, iPeak);
    }

    public static ParabolicLayer computeParabolic(TabulatedProfile tp, int iStart, int iEnd) {
        ParabolicLayer layer = new ParabolicLayer();
        layer.init();
        if (iStart != -1 && iEnd != -1) {
            double hm = tp.getPeakHeight(iStart, iEnd);
            layer.setPeakHeight_km(hm);
            double fm = tp.frequency[iEnd];
            layer.setCriticalFrequency_MHz(fm);
            int iPeak = tp.getBottomsideIndexForFreq(fm);
            int iHalfPeak = Math.max(iPeak - 1, 0);
            double hThreshold = (hm + tp.height[iStart]) / 2.0;
            while (iHalfPeak > 0 && tp.height[iHalfPeak] > hThreshold) {
                --iHalfPeak;
            }
            double[] d = new double[iPeak - iHalfPeak + 1];
            double[] h = new double[iPeak - iHalfPeak + 1];
            int j = 0;
            int i = iHalfPeak;
            while (i <= iPeak) {
                d[j] = tp.getDensity_m3(i);
                h[j++] = tp.height[i];
                ++i;
            }
            layer.computeHalfThickness_km(d, h);
        }
        return layer;
    }

    public double getDensity_m3(double h) {
        if (this.parabolicE.isGood() && h <= this.parabolicE.getPeakHeight_km()) {
            return this.parabolicE.getModelDensity_m3(h);
        }
        if (this.parabolicF1.isGood() && h <= this.parabolicF1.getPeakHeight_km()) {
            return this.parabolicF1.getModelDensity_m3(h);
        }
        if (this.parabolicF2.isGood() && h <= this.parabolicF2.getPeakHeight_km()) {
            return this.parabolicF2.getModelDensity_m3(h);
        }
        return -1.0;
    }
}

