/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

public class PlasmaMath {
    private static final double coef2Ne = 12406.94789081886;
    private static final double coef2Ne_m3 = 1.240694789081886E10;
    private static final double coef2tec = 1.0E16;
    private static final double coef2tec_cm2 = 1.0E12;
    private static final double coefTau = 1.0E7;
    public static final double SPEED_OF_LIGHT_KM_PER_S = 299792.458;
    public static final double ROUNDED_SPEED_OF_LIGHT_KM_PER_S = 300000.0;

    public static double freq2density(double freq_MHz) {
        return 12406.94789081886 * freq_MHz * freq_MHz;
    }

    public static double density2freq(double density_cm3) {
        return Math.sqrt(density_cm3 / 12406.94789081886);
    }

    public static double freq2density_m3(double freq_MHz) {
        return freq_MHz * freq_MHz * 1.240694789081886E10;
    }

    public static double density2freq_m3(double density_m3) {
        return Math.sqrt(density_m3 / 1.240694789081886E10);
    }

    public static double tecu2tec_m2(double tec_units) {
        return tec_units * 1.0E16;
    }

    public static double tecu2tec_cm2(double tec_units) {
        return tec_units * 1.0E12;
    }

    public static double slabThickness_km(double tec_units, double NmF2_cm3) {
        return 1.0E7 * tec_units / NmF2_cm3;
    }

    public static double MUF3000(double foF2, double hmF2, double foE, double R12, double diplat_deg) {
        double f1 = 0.00232 * R12 + 0.222;
        double f2 = 1.2 - 0.0116 * Math.exp(0.0239 * R12);
        double f3 = 0.096 * (R12 - 25.0) / 150.0;
        double f4 = 1.0 - R12 / 150.0 * Math.exp(-diplat_deg * diplat_deg / 1600.0);
        double freqRatio = Math.max(foF2 / foE, 1.7);
        double deltaM = f1 * f4 / (freqRatio - f2) + f3;
        double m3000 = 1490.0 / (hmF2 + 176.0) - deltaM;
        double muf3000 = m3000 * foF2;
        return muf3000;
    }
}

