/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.geospace.RegulaFalsiSolvable;

public class RegulaFalsiSolver {
    private static final int MAX_ITERATIONS = 50;
    private static double leftBound;
    private static double rightBound;

    public static void setArgumentBounds(double left, double right) {
        leftBound = left;
        rightBound = right;
    }

    public static double solve(double valueToMatch, RegulaFalsiSolvable function) {
        double answer = 0.0;
        int iterations = 0;
        while (true) {
            double f0 = function.getDensity_m3(leftBound);
            double f1 = function.getDensity_m3(rightBound);
            answer = rightBound - (f1 - valueToMatch) * (rightBound - leftBound) / (f1 - f0);
            double outcome = function.getDensity_m3(answer);
            double diff = Math.abs(outcome - valueToMatch);
            if (diff < 0.001 || ++iterations > 50) break;
            if (outcome > valueToMatch && f0 > valueToMatch || outcome < valueToMatch && f0 < valueToMatch) {
                leftBound = answer;
                continue;
            }
            rightBound = answer;
        }
        return answer;
    }
}

