/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import java.util.HashMap;
import java.util.Map;

public class SpreadF {
    public static final double FREQUENCY_SPREAD_MINIMUM_MHZ = 0.15;

    public static enum SpreadLevelForAutoscaling {
        QUIET("Quiet", 0),
        MODERATE("Moderate", 1),
        SEVERE("Severe", 2),
        TOO_SEVERE("Too Severe", 3),
        UNKNOWN("Unknown", 9);

        private static final Map<String, SpreadLevelForAutoscaling> mapByName;
        private static final Map<Integer, SpreadLevelForAutoscaling> mapByCode;
        private final String name;
        private final int code;

        static {
            mapByName = new HashMap<String, SpreadLevelForAutoscaling>();
            mapByCode = new HashMap<Integer, SpreadLevelForAutoscaling>();
            SpreadLevelForAutoscaling[] spreadLevelForAutoscalingArray = SpreadLevelForAutoscaling.values();
            int n = spreadLevelForAutoscalingArray.length;
            int n2 = 0;
            while (n2 < n) {
                SpreadLevelForAutoscaling level = spreadLevelForAutoscalingArray[n2];
                if (mapByCode.put(level.getCode(), level) != null) {
                    throw new RuntimeException("SpreadLevelForAutoscaling design error: code duplication: " + level.getCode());
                }
                if (mapByName.put(level.getName(), level) != null) {
                    throw new RuntimeException("SpreadLevelForAutoscaling design error: name duplication: " + level.getName());
                }
                ++n2;
            }
        }

        private SpreadLevelForAutoscaling(String name, int code) {
            this.name = name;
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public int getCode() {
            return this.code;
        }

        public static SpreadLevelForAutoscaling getByCode(int code) {
            return mapByCode.get(code);
        }

        public static SpreadLevelForAutoscaling getByName(String name) {
            return mapByName.get(name);
        }
    }
}

