/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.geospace.Coefficients;
import edu.uml.lgdc.geospace.EarthGrid;
import edu.uml.lgdc.geospace.ExpansionBasis_SphericalCapHarmonicsK6;
import edu.uml.lgdc.geospace.TimeGrid;
import edu.uml.lgdc.time.TimeScale;

public class SynthesizerSCH {
    protected ExpansionBasis_SphericalCapHarmonicsK6 basis;
    protected Coefficients coeffs;

    public SynthesizerSCH(ExpansionBasis_SphericalCapHarmonicsK6 basis, Coefficients coeffs) {
        this.basis = basis;
        this.coeffs = coeffs;
    }

    public double synthesizeValue(double latitude_deg, double longitude_deg, int iTime) {
        ExpansionBasis_SphericalCapHarmonicsK6 basisSCH = this.basis;
        TimeScale ut = this.basis.getTimeGrid().getUTs()[iTime];
        double hoursSince00z = ut.getTimeSinceMidnightIn(11);
        double timeAdjustedLongitude = (int)(longitude_deg + 15.0 * hoursSince00z);
        if (timeAdjustedLongitude > 360.0) {
            timeAdjustedLongitude -= 360.0;
        }
        int iLon = basisSCH.getEarthGrid().getGridLonIndex(timeAdjustedLongitude);
        double referenceModip = basisSCH.getModip(latitude_deg, longitude_deg);
        int iLat = basisSCH.findModipIndex(referenceModip, iLon);
        double value = 0.0;
        int k = 0;
        while (k < basisSCH.getCompactSpatialBasisLength()) {
            double c = this.coeffs.get()[k / 2][k % 2];
            int[] odt = basisSCH.compactToOrderDegreeTerm(k);
            double basis = basisSCH.getSpatialBasisFunctionValue(k, iLat, iLon);
            value += c * basis;
            ++k;
        }
        return value;
    }

    public double[] synthesizeValueSeries(int iLat, int iLon) {
        double[] valueSeries = new double[this.basis.getTimeGrid().getNumDiurnalSteps()];
        double latitude_deg = this.basis.getEarthGrid().getGridLatDegree(iLat);
        double longitude_deg = this.basis.getEarthGrid().getGridLonDegree(iLon);
        int iTime = 0;
        while (iTime < this.basis.getTimeGrid().getNumDiurnalSteps()) {
            valueSeries[iTime] = this.synthesizeValue(latitude_deg, longitude_deg, iTime);
            ++iTime;
        }
        return valueSeries;
    }

    public double[][] synthesizeValueMap(int iTime) {
        double[][] valueGrid = new double[this.basis.getEarthGrid().getNumLatitudeNodes()][this.basis.getEarthGrid().getNumLongitudeNodes()];
        int iLat = 0;
        while (iLat < this.basis.getEarthGrid().getNumLatitudeNodes()) {
            double latitude_deg = this.basis.getEarthGrid().getGridLatDegree(iLat);
            int iLon = 0;
            while (iLon < this.basis.getEarthGrid().getNumLongitudeNodes()) {
                double longitude_deg = this.basis.getEarthGrid().getGridLonDegree(iLon);
                double[] dArray = valueGrid[iLat];
                int n = iLon++;
                dArray[n] = dArray[n] + this.synthesizeValue(latitude_deg, longitude_deg, iTime);
            }
            ++iLat;
        }
        return valueGrid;
    }

    public void setEarthGrid(EarthGrid earthGrid) {
        this.basis.setEarthGrid(earthGrid);
    }

    public void setTimeGrid(TimeGrid timeGrid) {
        this.basis.setTimeGrid(timeGrid);
    }
}

