/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.datatype.OrderedMetricable;
import edu.uml.lgdc.datatype.geom.R2;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.geospace.PlasmaMath;
import edu.uml.lgdc.math.ExtMath;
import edu.uml.lgdc.math.Search;
import edu.uml.lgdc.math.Statistic;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class TabulatedProfile {
    private static final int TENTATIVE_LENGTH = 100;
    public static DecimalFormat densityFormatter = new DecimalFormat("0.00000E00");
    public static DecimalFormat heightFormatter = new DecimalFormat("0000");
    public double[] height;
    public double[] frequency;
    private double[] density;
    public int start_D;
    public int end_D;
    public int start_E;
    public int end_E;
    public int start_F1;
    public int end_F1;
    public int start_F2;
    public int end_F2;

    public void init() {
        this.density = null;
        this.frequency = null;
        this.height = null;
        this.end_F2 = -1;
        this.start_F2 = -1;
        this.end_F1 = -1;
        this.start_F1 = -1;
        this.end_E = -1;
        this.start_E = -1;
        this.end_D = -1;
        this.start_D = -1;
    }

    public boolean isEmpty() {
        return this.height == null || this.frequency == null || this.density == null;
    }

    public void allocateMemory(int size) {
        this.height = new double[size];
        this.frequency = new double[size];
        this.density = new double[size];
    }

    public int getSize() {
        return this.height == null ? 0 : this.height.length;
    }

    public void set(int size, double[] height, double[] frequency, int start_E, int end_E, int start_F1, int end_F1, int start_F2, int end_F2) {
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        if (height == null) {
            throw new IllegalArgumentException("height == null");
        }
        if (frequency == null) {
            throw new IllegalArgumentException("frequency == null");
        }
        if (height.length < size) {
            throw new IllegalArgumentException("height.length < size");
        }
        if (frequency.length < size) {
            throw new IllegalArgumentException("frequency.length < size");
        }
        this.allocateMemory(size);
        int i = 0;
        while (i < size) {
            this.height[i] = height[i];
            this.frequency[i] = frequency[i];
            this.density[i] = PlasmaMath.freq2density(frequency[i]);
            ++i;
        }
        this.start_E = start_E;
        this.end_E = end_E;
        this.start_F1 = start_F1;
        this.end_F1 = end_F1;
        this.start_F2 = start_F2;
        this.end_F2 = end_F2;
    }

    public void set(double[] height, double[] frequency, int start_E, int end_E, int start_F1, int end_F1, int start_F2, int end_F2) {
        if (height == null) {
            throw new IllegalArgumentException("height == null");
        }
        if (frequency == null) {
            throw new IllegalArgumentException("frequency == null");
        }
        if (height.length != frequency.length) {
            throw new IllegalArgumentException("height.length != frequency.length");
        }
        this.set(height.length, height, frequency, start_E, end_E, start_F1, end_F1, start_F2, end_F2);
    }

    public void set(int size, double[] height, double[] frequency) {
        this.set(size, height, frequency, -1, -1, -1, -1, -1, -1);
    }

    public void set(double[] height, double[] frequency) {
        this.set(height, frequency, -1, -1, -1, -1, -1, -1);
    }

    public boolean updateOneHeight(double oneHeight, double newFrequency) {
        int i = 0;
        while (i < this.height.length) {
            if (Math.abs(this.height[i] - oneHeight) < 0.1) {
                this.frequency[i] = newFrequency;
                this.density[i] = PlasmaMath.freq2density(this.frequency[i]);
                return true;
            }
            ++i;
        }
        return false;
    }

    public TabulatedProfile makeCopy() {
        TabulatedProfile toFullProfile = new TabulatedProfile();
        if (!this.isEmpty()) {
            toFullProfile.set(this.height, this.frequency, this.start_E, this.end_E, this.start_F1, this.end_F1, this.start_F2, this.end_F2);
        }
        return toFullProfile;
    }

    public String getHeightsStr() {
        StringBuilder strBuf = new StringBuilder(800);
        int i = 0;
        while (i < this.height.length) {
            if (i > 0) {
                strBuf.append(' ');
            }
            strBuf.append(FC.doubleToString(this.height[i], 2, true));
            ++i;
        }
        return strBuf.toString();
    }

    public String getFreqsStr() {
        StringBuilder strBuf = new StringBuilder(600);
        int i = 0;
        while (i < this.height.length) {
            if (i > 0) {
                strBuf.append(' ');
            }
            strBuf.append(FC.doubleToString(this.frequency[i], 2, true));
            ++i;
        }
        return strBuf.toString();
    }

    public double getMaxFreq() {
        return Statistic.max(this.frequency, this.frequency.length);
    }

    public double getFirstHeightForExactFreq(double oneFreq) {
        return this.getFirstHeightForExactFreq(oneFreq, 0.01);
    }

    public double getFirstHeightForExactFreq(double oneFreq, double epsilon) {
        return this.getFirstHeightForExactFreq(oneFreq, 0.0, epsilon);
    }

    public double getFirstHeightForExactFreq(double oneFreq, double minHeight, double epsilon) {
        return this.getFirstHeightForExactFreq(oneFreq, minHeight, Double.MAX_VALUE, epsilon);
    }

    public double getFirstHeightForExactFreq(double oneFreq, double minHeight, double maxHeight, double epsilon) {
        int i = 0;
        while (i < this.frequency.length) {
            if (ExtMath.areClose(oneFreq, this.frequency[i], epsilon) && this.height[i] > minHeight && this.height[i] < maxHeight) {
                return this.height[i];
            }
            ++i;
        }
        return 9999.0;
    }

    public double getPeakHeight(int startIndex, int stopIndex) {
        int peakIndex = startIndex;
        int i = startIndex + 1;
        while (i <= stopIndex) {
            if (this.frequency[i] > this.frequency[peakIndex]) {
                peakIndex = i;
            }
            ++i;
        }
        return this.height[peakIndex];
    }

    public double getPeakHeight() {
        return this.getPeakHeight(0, this.frequency.length - 1);
    }

    public void putDensity(int index, double density_cm3) {
        this.density[index] = density_cm3;
    }

    public double getDensity(int index) {
        return this.density[index];
    }

    public double getDensity_m3(int index) {
        return this.density[index] * 1000000.0;
    }

    public double getBottomsideHeightForFreq(double oneFreq) {
        int i = 0;
        while (i < this.frequency.length && this.frequency[i] < oneFreq) {
            ++i;
        }
        if (i == this.frequency.length) {
            return 9999.0;
        }
        if (i == 0) {
            return this.height[0];
        }
        if (this.frequency[i] == oneFreq) {
            return this.height[i];
        }
        return this.height[i - 1] + (oneFreq - this.frequency[i - 1]) * (this.height[i] - this.height[i - 1]) / (this.frequency[i] - this.frequency[i - 1]);
    }

    public int getBottomsideIndexForFreq(double oneFreq) {
        int i = 0;
        while (i < this.frequency.length && this.frequency[i] < oneFreq) {
            ++i;
        }
        if (i == this.frequency.length) {
            return -1;
        }
        if (this.frequency[i] > oneFreq && i > 0) {
            --i;
        }
        return i;
    }

    /*
     * Unable to fully structure code
     */
    public double getBottomsideHeightForFreq_Upper(double oneFreq) {
        i = this.frequency.length - 1;
        if (!(this.frequency[i] < oneFreq)) ** GOTO lbl5
        return 9999.0;
lbl-1000:
        // 1 sources

        {
            --i;
lbl5:
            // 2 sources

            ** while (i >= 0 && this.frequency[i] > oneFreq)
        }
lbl6:
        // 1 sources

        if (i < 0) {
            return this.height[0];
        }
        if (this.frequency[i] == oneFreq) {
            return this.height[i];
        }
        return this.height[i] + (oneFreq - this.frequency[i]) * (this.height[i + 1] - this.height[i]) / (this.frequency[i + 1] - this.frequency[i]);
    }

    public double getTopsideHeightForFreq(double oneFreq) {
        int i = this.frequency.length - 1;
        while (i > 0 && this.frequency[i] < oneFreq) {
            --i;
        }
        if (i == 0) {
            return 9999.0;
        }
        if (i == this.frequency.length - 1) {
            return this.height[i];
        }
        if (this.frequency[i] == oneFreq) {
            return this.height[i];
        }
        return this.height[i + 1] - (oneFreq - this.frequency[i + 1]) * (this.height[i + 1] - this.height[i]) / (this.frequency[i] - this.frequency[i + 1]);
    }

    public void scaleFreqs(double coef) {
        int i = 0;
        while (i < this.frequency.length) {
            int n = i++;
            this.frequency[n] = this.frequency[n] * coef;
        }
    }

    public double getFreqForHeight(double oneHeight) {
        return R2.linearInter(oneHeight, this.height, this.frequency);
    }

    public double getMedianFreqAroundTheHeight(double oneHeight, double deltaHeight) {
        int newSize;
        double freq = 999.9;
        ArrayList<DoubleOrdered> vHeight = new ArrayList<DoubleOrdered>(1000);
        ArrayList<DoubleOrdered> vFreq = new ArrayList<DoubleOrdered>(1000);
        ArrayList<Integer> vCount = new ArrayList<Integer>(1000);
        int i = Search.rightNearest(this.height, oneHeight - deltaHeight);
        if (i < 0) {
            i = this.height.length;
        }
        while (i < this.height.length) {
            if (!(this.height[i] <= oneHeight + deltaHeight)) break;
            TabulatedProfile.addElement(vHeight, vFreq, vCount, this.height[i], this.frequency[i]);
            ++i;
        }
        if ((newSize = vHeight.size()) > 0) {
            double[] tmpFreqArray = new double[newSize];
            i = 0;
            while (i < newSize) {
                tmpFreqArray[i] = ((DoubleOrdered)vFreq.get(i)).doubleValue();
                ++i;
            }
            freq = Statistic.median(tmpFreqArray);
        }
        return freq;
    }

    public int getIndexForHeight(double height_km) {
        int index = Search.rightNearest(this.height, height_km);
        if (index >= 0) {
            return index;
        }
        return -1;
    }

    private static void addElement(List<DoubleOrdered> vHeight, List<DoubleOrdered> vFreq, List<Integer> vCount, double height, double freq) {
        int atOldElement = Search.closest(vHeight, new DoubleOrdered(height));
        if (atOldElement == -1) {
            vHeight.add(new DoubleOrdered(height));
            vFreq.add(new DoubleOrdered(freq));
            vCount.add(1);
        } else if (ExtMath.areClose(height, vHeight.get(atOldElement).doubleValue(), 0.2)) {
            double oldFreq = vFreq.get(atOldElement).doubleValue();
            int oldCount = vCount.get(atOldElement);
            vFreq.set(atOldElement, new DoubleOrdered((oldFreq * (double)oldCount + freq) / (double)(oldCount + 1)));
            vCount.set(atOldElement, oldCount + 1);
        } else {
            if (height > vHeight.get(atOldElement).doubleValue()) {
                atOldElement = atOldElement < vHeight.size() - 1 ? ++atOldElement : -1;
            }
            if (atOldElement >= 0) {
                vHeight.add(atOldElement, new DoubleOrdered(height));
                vFreq.add(atOldElement, new DoubleOrdered(freq));
                vCount.add(atOldElement, 1);
            } else {
                vHeight.add(new DoubleOrdered(height));
                vFreq.add(new DoubleOrdered(freq));
                vCount.add(1);
            }
        }
    }

    private static class DoubleOrdered
    implements OrderedMetricable<DoubleOrdered> {
        double value;

        DoubleOrdered(double value) {
            this.value = value;
        }

        double doubleValue() {
            return this.value;
        }

        @Override
        public int compareTo(DoubleOrdered doubleOrdered) {
            return (int)Math.signum(this.doubleValue() - doubleOrdered.doubleValue());
        }

        @Override
        public double dist(DoubleOrdered obj) {
            return Math.abs(this.doubleValue() - obj.doubleValue());
        }
    }
}

