/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.fileio.FileUtils;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.format.IonexMap;
import edu.uml.lgdc.format.IonexRecordSet;
import edu.uml.lgdc.geospace.Geomap;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.time.TimeScale;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class UWMRapidVTECGetter {
    static final String PREF_UPC_RAPID_VTEC = "https://igsiono.uwm.edu.pl/data/gambit/RT/";
    private TimeScale currentTov = new TimeScale();
    private IonexRecordSet uqrgTec = new IonexRecordSet();
    private String localRootPath = null;

    public UWMRapidVTECGetter(String localRootPath) {
        this.localRootPath = new String(localRootPath);
    }

    public IonexRecordSet downloadRapidTEC(TimeScale tov) {
        if (this.currentTov != null && tov.equals(this.currentTov)) {
            return this.uqrgTec;
        }
        String filename = UWMRapidVTECGetter.makeRapidTecFilenameInstantCAS(tov);
        String path = String.valueOf(this.localRootPath) + FC.IntegerToString(tov.get(1), 4, '0') + File.separator + FC.IntegerToString(tov.get(6), 3, '0') + File.separator;
        File localFile = new File(path, filename);
        if (!localFile.exists()) {
            File destinationDir = new File(path);
            destinationDir.mkdirs();
            String urlName = PREF_UPC_RAPID_VTEC + FC.IntegerToString(tov.get(1), 4, '0') + "/" + FC.IntegerToString(tov.get(6), 3, '0') + "/" + filename;
            Console.showMsg("Starting download of Real-Time VTEC for " + tov.toHumanUT() + " from " + urlName + "...");
            try {
                URL url = new URL(urlName);
                URLConnection connection = url.openConnection();
                int contentLength = connection.getContentLength();
                InputStream is = connection.getInputStream();
                FileUtils.streamToFile(is, localFile);
            }
            catch (IOException e) {
                Console.showError("Error retrieving data from " + urlName);
                return null;
            }
            Console.showMsg("done.");
        }
        if (this.readRapidTec(localFile)) {
            this.currentTov.setTimeInMillis(tov.getTimeInMillis());
        }
        return this.uqrgTec;
    }

    public boolean dataAvailable() {
        return this.uqrgTec != null;
    }

    private boolean readRapidTec(File localFile) {
        if (!localFile.exists()) {
            return false;
        }
        return IonexMap.read(this.uqrgTec, localFile.getAbsolutePath());
    }

    public static String makeRapidTecFilenameInstantCAS(TimeScale tov) {
        int minute = tov.get(12);
        minute = minute / 15 * 15;
        return "gmrt" + FC.IntegerToString(tov.get(6), 3, '0') + "_" + FC.IntegerToString(tov.get(11), 2, '0') + FC.IntegerToString(minute, 2, '0') + "." + FC.IntegerToString(tov.get(1) % 100, 2, '0') + "i";
    }

    public double[] getIonexMap(TimeScale time) {
        return this.uqrgTec.getMap(this.uqrgTec.getGrid().getIndex(time));
    }

    public boolean fillGambitMap(Geomap map, TimeScale time) {
        return map.setIonexMapValues(this.getIonexMap(time), this.uqrgTec.getGrid());
    }
}

