/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace.test;

import edu.uml.lgdc.appuserdb.api.ApplicationPassport;
import edu.uml.lgdc.appuserdb.api.LgdcRegistry;
import edu.uml.lgdc.appuserdb.api.UserRole;
import edu.uml.lgdc.appuserdb.constants.Application;
import edu.uml.lgdc.database.DBConnect;
import edu.uml.lgdc.database.DatabaseContents;
import edu.uml.lgdc.database.DatabaseFarm;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.geospace.EarthSphere;
import edu.uml.lgdc.geospace.GroundCoord;
import edu.uml.lgdc.geospace.test.DidbaseAppSettings;
import edu.uml.lgdc.instrument.StationLocation;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestMidpoint {
    public static Map<String, StationLocation> allDidbaseStations = new HashMap<String, StationLocation>();
    private static EarthSphere earthSphere;
    private static Application application;
    private static ApplicationPassport appPassport;
    private static final String DIDBASE_NAME = "DIDBase";

    static {
        application = Application.get("GambitExplorer_MasterApp");
        appPassport = null;
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        System.out.println("Opening connection to DIDBase...");
        DidbaseAppSettings settings = new DidbaseAppSettings("didbase.ini");
        appPassport = new ApplicationPassport(application, UserRole.BROWSER, true, 0, null);
        DBConnect didb = null;
        didb = new DBConnect(settings.getDatabaseConnectionSettings().getConnectionRequisites(DIDBASE_NAME), DatabaseContents.FASTCHAR_VI.getId(), 0);
        DatabaseFarm farm = new DatabaseFarm();
        farm.addConnect(didb);
        farm.activateDefaultConnections();
        LgdcRegistry.addDatabaseFarm(appPassport, farm);
        Statement statement = didb.createStatement();
        System.out.println("Querying station list...");
        Throwable throwable = null;
        Object var5_6 = null;
        try (ResultSet rs = statement.executeQuery("SELECT Ident,UrsiCode,Name,Lat,Lon FROM Location");){
            while (rs.next()) {
                String ursi = rs.getString(2).trim().toUpperCase();
                StationLocation sloc = new StationLocation(ursi, rs.getString(3).trim(), rs.getDouble(4), rs.getDouble(5), rs.getInt(1));
                allDidbaseStations.put(ursi, sloc);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        didb.close();
        didb = null;
        System.gc();
        earthSphere = new EarthSphere();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void getMidpoints() {
        this.getMidpoint("MHJ45", "KI939");
        this.getMidpoint("PQ052", "JR055");
        this.getMidpoint("DB049", "JR055");
        this.getMidpoint("DB049", "JR055");
        this.getMidpoint("DB049", "EB040");
        this.getMidpoint("DB049", "SO148");
        this.getMidpoint("PQ052", "SO148");
        this.getMidpoint("EB040", "AT138");
        this.getMidpoint("NI135", "AT138");
        this.getMidpoint("RO041", "GM037");
    }

    private void getMidpoint(String txCode, String rxCode) {
        StationLocation tx = allDidbaseStations.get(txCode);
        if (tx == null) {
            System.err.println("Station " + txCode + " not found in DIDBase");
            return;
        }
        StationLocation rx = allDidbaseStations.get(rxCode);
        if (rx == null) {
            System.err.println("Station " + rxCode + " not found in DIDBase");
            return;
        }
        double[] midpoint = earthSphere.midpointOnEarth(tx.getLat(), tx.getLon(), rx.getLat(), rx.getLon());
        System.out.println("Radio link " + tx.getUrsi() + " (" + new GroundCoord(tx.getLat(), tx.getLon()) + ") -- " + rx.getUrsi() + " (" + new GroundCoord(rx.getLat(), rx.getLon()) + "), ground distance " + FC.IntegerToString((int)earthSphere.distanceOnEarth_km(tx.getLat(), tx.getLon(), rx.getLat(), rx.getLon()), 4) + " km; midpoint at ( " + new GroundCoord(midpoint[0], midpoint[1]) + ")");
    }
}

