/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import edu.uml.lgdc.colorscale.ColorScale;
import edu.uml.lgdc.datatype.geom.R2;
import edu.uml.lgdc.graph.CheckConstants;
import edu.uml.lgdc.graph.ColorValueLegend;
import edu.uml.lgdc.graph.Draw;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class ColorScaleBar {
    private Graphics g;
    private ColorScale colorScale;
    private int direction = 1;
    private Point origin;
    private int length;
    private int width = 15;
    private int side = 0;
    private R2 mainDirectionVector;
    private R2 acrossDirectionVector;
    private Rectangle rectangle;

    public ColorScaleBar(ColorValueLegend colorValueLegend, ColorScale colorScale) {
        this(colorValueLegend, colorScale, 15);
    }

    public ColorScaleBar(ColorValueLegend colorValueLegend, ColorScale colorScale, int width) {
        this.initPar(colorValueLegend.gb.g, colorScale, colorValueLegend.direction, colorValueLegend.length, colorValueLegend.origin, width);
        colorValueLegend.setColorScaleBar(this);
    }

    public ColorScaleBar(Graphics g, ColorScale colorScale, int direction, int length) {
        this(g, colorScale, direction, length, new Point(0, 0));
    }

    public ColorScaleBar(Graphics g, ColorScale colorScale, int direction, int length, Point origin) {
        this(g, colorScale, direction, length, origin, 15);
    }

    public ColorScaleBar(Graphics g, ColorScale colorScale, int direction, int length, Point origin, int width) {
        this.initPar(g, colorScale, direction, length, origin, width);
    }

    private void initPar(Graphics g, ColorScale colorScale, int direction, int length, Point origin, int width) {
        this.g = g;
        this.colorScale = colorScale;
        this.direction = direction;
        this.origin = new Point(origin);
        this.length = length;
        this.width = width;
        this.setGeometry();
    }

    public void draw() {
        double step = 1.0 / (double)this.length;
        double color = 0.0;
        int i = 0;
        while (i < this.length) {
            this.drawSegment(i, this.colorScale.getColor(color));
            color += step;
            ++i;
        }
    }

    public double getValue(Point p) {
        Point start = this.getPoint(0, 0);
        Point end = this.getPoint(this.length, 0);
        double value = (end.y - start.y) / (end.y - p.y);
        if (value < 0.0 || value > 1.0) {
            value = 0.0;
        }
        return value;
    }

    public boolean inside(int x, int y) {
        if (this.width <= 0 || this.length <= 0) {
            return false;
        }
        return this.rectangle.contains(x, y);
    }

    public boolean inside(Point point) {
        if (this.width <= 0 || this.length <= 0) {
            return false;
        }
        return this.rectangle.contains(point);
    }

    public Dimension getSize() {
        return this.rectangle.getSize();
    }

    public ColorScale getColorScale() {
        return this.colorScale;
    }

    public void setColorScale(ColorScale colorScale) {
        this.colorScale = colorScale;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        if (this.direction != direction) {
            CheckConstants.validDirection(direction);
            this.direction = direction;
            this.setGeometry();
        }
    }

    public Point getOrigin() {
        return new Point(this.origin);
    }

    public void setOrigin(Point origin) {
        if (!this.origin.equals(origin)) {
            this.origin = new Point(origin);
            this.rectangle = this.getRectangle();
        }
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        if (this.length != length) {
            this.length = length;
            this.rectangle = this.getRectangle();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        if (this.width != width) {
            this.width = width;
            this.rectangle = this.getRectangle();
        }
    }

    int getSide() {
        return this.side;
    }

    void setSide(int side) {
        if (this.side != side) {
            CheckConstants.validSide(side);
            this.origin = this.getPoint(0, this.width - 1);
            this.acrossDirectionVector.inverse();
            this.side = side;
        }
    }

    Point getPoint(int offsetAlong, int offsetAcross) {
        R2 p1 = new R2(this.origin);
        R2 p2 = new R2(this.acrossDirectionVector);
        R2 p3 = new R2(this.mainDirectionVector);
        p2.scalar(offsetAcross);
        p3.scalar(offsetAlong);
        p1.add(p2).add(p3);
        return p1.getP();
    }

    private void setGeometry() {
        this.mainDirectionVector = new R2(Draw.getScrVectorDirection(this.direction));
        this.acrossDirectionVector = Draw.getScrSideVector(this.mainDirectionVector, this.side);
        this.rectangle = this.getRectangle();
    }

    private void drawSegment(int n, Color color) {
        R2 point1 = new R2(this.mainDirectionVector);
        R2 point2 = new R2(this.acrossDirectionVector);
        point1.scalar(n).add(this.origin);
        point2.scalar(this.width - 1).add(point1);
        this.g.setColor(color);
        Draw.drawLine(this.g, point1, point2);
    }

    private Rectangle getRectangle() {
        return R2.getRectangle(this.origin, this.mainDirectionVector, this.acrossDirectionVector, this.length, this.width);
    }
}

