/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import edu.uml.lgdc.datatype.geom.R2;
import edu.uml.lgdc.graph.CheckConstants;
import edu.uml.lgdc.graph.ColorScaleBar;
import edu.uml.lgdc.graph.Draw;
import edu.uml.lgdc.graph.GraphBase;
import edu.uml.lgdc.graph.NumericAxis;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class ColorValueLegend {
    GraphBase gb;
    int direction;
    int side;
    int length;
    Point origin;
    boolean axisInsideBar;
    private ColorScaleBar colorScaleBar;
    private NumericAxis axis;
    private R2 mainDirectionVector;
    private R2 acrossDirectionVector;
    private Rectangle rectangle;
    private int width;

    public ColorValueLegend(GraphBase gb, int direction, int side, int length) {
        this(gb, direction, side, length, new Point(0, 0));
    }

    public ColorValueLegend(GraphBase gb, int direction, int side, int length, int xOrigin, int yOrigin) {
        this(gb, direction, side, length, new Point(xOrigin, yOrigin));
    }

    public ColorValueLegend(GraphBase gb, int direction, int side, int length, Point origin) {
        this.initPar(gb, direction, side, length, origin, false);
    }

    public ColorValueLegend(GraphBase gb, int direction, int side, int length, int xOrigin, int yOrigin, boolean axisInsideBar) {
        this(gb, direction, side, length, new Point(xOrigin, yOrigin), axisInsideBar);
    }

    public ColorValueLegend(GraphBase gb, int direction, int side, int length, Point origin, boolean axisInsideBar) {
        this.initPar(gb, direction, side, length, origin, axisInsideBar);
    }

    private void initPar(GraphBase gb, int direction, int side, int length, Point origin, boolean axisInsideBar) {
        this.gb = gb;
        this.direction = direction;
        this.side = side;
        this.length = length;
        this.origin = origin;
        this.axisInsideBar = axisInsideBar;
        this.setGeometry();
    }

    public void draw() {
        if (this.colorScaleBar != null && this.axis != null) {
            this.colorScaleBar.draw();
            this.axis.draw();
        }
    }

    public double getValue(Point p) {
        double value = 0.0;
        if (this.colorScaleBar.inside(p)) {
            value = this.axis.offsetToValue(this.axis.getYOrigin() - p.y);
        }
        return value;
    }

    public boolean inside(int x, int y) {
        if (this.width <= 0 || this.length <= 0) {
            return false;
        }
        return this.rectangle.contains(x, y);
    }

    public boolean inside(Point point) {
        if (this.width <= 0 || this.length <= 0) {
            return false;
        }
        return this.rectangle.contains(point);
    }

    public Dimension getSize() {
        return this.rectangle.getSize();
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        if (this.direction != direction) {
            CheckConstants.validDirection(direction);
            this.direction = direction;
            this.resetBarLocation();
            this.resetAxisLocation();
        }
    }

    public int getSide() {
        return this.side;
    }

    public void setSide(int side) {
        if (this.side != side) {
            CheckConstants.validSide(side);
            this.side = side;
            if (this.colorScaleBar != null) {
                this.colorScaleBar.setSide(side);
            }
            this.resetAxisLocation();
        }
    }

    public Point getOrigin() {
        return new Point(this.origin);
    }

    public void setOrigin(Point origin) {
        if (!this.origin.equals(origin)) {
            this.origin = new Point(origin);
            this.resetBarLocation();
            this.resetAxisLocation();
        }
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        if (this.length != length) {
            this.length = length;
            this.resetBarLocation();
            this.resetAxisLocation();
        }
    }

    public void setAllStuff() {
        this.setGeometry();
        this.resetBarLocation();
        this.resetAxisLocation();
        this.setGeometry();
    }

    void setColorScaleBar(ColorScaleBar colorScaleBar) {
        this.colorScaleBar = colorScaleBar;
        colorScaleBar.setSide(this.side);
        this.resetAxisLocation();
    }

    void setAxis(NumericAxis axis) {
        if (this.axis != null) {
            this.axis.detachFromLegend();
        }
        this.axis = axis;
        axis.attachToLegend(this);
        this.resetAxisLocation();
    }

    private void resetAxisLocation() {
        if (this.axis != null) {
            this.axis.setAxisDirection(this.direction);
            this.axis.setAnnotSide(this.side);
            this.axis.setLength(this.length);
            this.resetAxisOrigin();
        }
    }

    private void resetAxisOrigin() {
        if (this.colorScaleBar != null && this.axis != null) {
            Point point = !this.axisInsideBar ? this.colorScaleBar.getPoint(0, this.colorScaleBar.getWidth()) : this.colorScaleBar.getPoint(0, 0);
            this.axis.setXOrigin(point.x);
            this.axis.setYOrigin(point.y);
        }
    }

    private void resetBarLocation() {
        if (this.colorScaleBar != null) {
            this.colorScaleBar.setDirection(this.direction);
            this.colorScaleBar.setLength(this.length);
            this.colorScaleBar.setOrigin(this.origin);
            this.resetAxisOrigin();
        }
    }

    private void setGeometry() {
        this.mainDirectionVector = new R2(Draw.getScrVectorDirection(this.direction));
        this.acrossDirectionVector = Draw.getScrSideVector(this.mainDirectionVector, this.side);
        this.setWidth();
        this.rectangle = this.getRectangle();
    }

    private void setWidth() {
        this.width = 0;
        if (!this.axisInsideBar) {
            if (this.colorScaleBar != null) {
                this.width += this.colorScaleBar.getWidth();
            }
            if (this.axis != null) {
                this.axis.setAllStuff();
                this.width += this.axis.getLengthAcross();
            }
        } else {
            if (this.colorScaleBar != null) {
                this.width = this.colorScaleBar.getWidth();
            }
            if (this.axis != null) {
                this.width = Math.max(this.width, this.axis.getLengthAcross());
            }
        }
    }

    private Rectangle getRectangle() {
        return R2.getRectangle(this.origin, this.mainDirectionVector, this.acrossDirectionVector, this.length, this.width);
    }
}

