/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import edu.uml.lgdc.graph.Draw;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class ComponentBorder {
    private static final int MIN_BORDER_WIDTH = 7;
    private Color bg;
    private Color fg;
    private JComponent container;
    private JComponent content;
    private TopBorder topBorder;
    private LeftBorder leftBorder;
    private BottomBorder bottomBorder;
    private RightBorder rightBorder;
    private transient boolean borderIsSet;

    public ComponentBorder(Color bg, Color fg) {
        this.bg = bg;
        this.fg = fg;
        this.topBorder = new TopBorder();
        this.leftBorder = new LeftBorder();
        this.bottomBorder = new BottomBorder();
        this.rightBorder = new RightBorder();
    }

    public void setContainer(JComponent container) {
        this.container = container;
        if (this.content != null) {
            this.layout();
        }
    }

    public void setContent(JComponent content) {
        this.content = content;
        if (this.container != null) {
            this.layout();
        }
    }

    private void layout() {
        this.container.setLayout(new BorderLayout(0, 0));
        this.container.add((Component)this.topBorder, "North");
        this.container.add((Component)this.leftBorder, "West");
        this.container.add((Component)this.bottomBorder, "South");
        this.container.add((Component)this.rightBorder, "East");
        this.container.add((Component)this.content, "Center");
        this.borderIsSet = true;
    }

    public void realeaseBorder() {
        if (this.container == null) {
            throw new RuntimeException("illegal call");
        }
        if (!this.borderIsSet) {
            return;
        }
        this.container.remove(this.topBorder);
        this.container.remove(this.leftBorder);
        this.container.remove(this.bottomBorder);
        this.container.remove(this.rightBorder);
        this.container.invalidate();
        this.borderIsSet = false;
    }

    public void addBorder() {
        if (this.container == null) {
            throw new RuntimeException("illegal call");
        }
        if (this.borderIsSet) {
            return;
        }
        this.container.add((Component)this.topBorder, "North");
        this.container.add((Component)this.leftBorder, "West");
        this.container.add((Component)this.bottomBorder, "South");
        this.container.add((Component)this.rightBorder, "East");
        this.container.invalidate();
        this.borderIsSet = true;
    }

    public JPanel getTop() {
        return this.topBorder.getContent();
    }

    public JPanel getLeft() {
        return this.leftBorder;
    }

    public JPanel getBottom() {
        return this.bottomBorder.getContent();
    }

    public JPanel getRight() {
        return this.rightBorder;
    }

    private class BottomBorder
    extends OneSideBorder {
        private JPanel left;
        private JPanel main;
        private JPanel right;

        BottomBorder() {
            this.left = new JPanel();
            this.main = new JPanel();
            this.right = new JPanel();
            this.left.setBorder(null);
            this.main.setBorder(null);
            this.right.setBorder(null);
            this.left.setOpaque(false);
            this.main.setOpaque(false);
            this.right.setOpaque(false);
            this.left.setMinimumSize(new Dimension(7, 7));
            this.right.setMinimumSize(new Dimension(7, 7));
            this.setLayout(new BorderLayout(0, 0));
            this.add((Component)this.left, "West");
            this.add((Component)this.main, "Center");
            this.add((Component)this.right, "East");
        }

        @Override
        protected void setMinimumSize() {
            this.setMinimumSize(new Dimension(14, 7));
        }

        @Override
        protected void drawLine(Graphics g) {
            int vertOffset = this.getSize().height / 2;
            int leftOffset = ((ComponentBorder)ComponentBorder.this).leftBorder.getSize().width / 2;
            int rightOffset = ((ComponentBorder)ComponentBorder.this).rightBorder.getSize().width / 2;
            g.drawLine(leftOffset, this.getSize().height - vertOffset, this.getSize().width - rightOffset, this.getSize().height - vertOffset);
            g.drawLine(leftOffset, this.getSize().height - vertOffset, leftOffset, 0);
            g.drawLine(this.getSize().width - rightOffset, this.getSize().height - vertOffset, this.getSize().width - rightOffset, 0);
        }

        public JPanel getContent() {
            return this.main;
        }
    }

    private class LeftBorder
    extends OneSideBorder {
        private LeftBorder() {
        }

        @Override
        protected void setMinimumSize() {
            this.setMinimumSize(new Dimension(7, 14));
        }

        @Override
        protected void drawLine(Graphics g) {
            int lineOffset = this.getSize().width / 2;
            g.drawLine(lineOffset, 0, lineOffset, this.getSize().height);
        }
    }

    private abstract class OneSideBorder
    extends JPanel {
        OneSideBorder() {
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.setMinimumSize();
        }

        protected abstract void setMinimumSize();

        @Override
        public void paintComponent(Graphics gMaster) {
            if (gMaster == null) {
                return;
            }
            Graphics g = gMaster.create();
            Draw.setQualityRendering(g, true);
            Color prevColor = g.getColor();
            g.setColor(ComponentBorder.this.bg);
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            g.setColor(ComponentBorder.this.fg);
            this.drawLine(g);
            g.setColor(prevColor);
            g.dispose();
        }

        protected abstract void drawLine(Graphics var1);

        @Override
        public void setBorder(Border border) {
        }
    }

    private class RightBorder
    extends OneSideBorder {
        private RightBorder() {
        }

        @Override
        protected void setMinimumSize() {
            this.setMinimumSize(new Dimension(7, 14));
        }

        @Override
        protected void drawLine(Graphics g) {
            int lineOffset = this.getSize().width / 2;
            g.drawLine(this.getSize().width - lineOffset, 0, this.getSize().width - lineOffset, this.getSize().height);
        }
    }

    private class TopBorder
    extends OneSideBorder {
        private JPanel left = new JPanel();
        private JPanel main = new JPanel();
        private JPanel right = new JPanel();

        TopBorder() {
            this.left.setBorder(null);
            this.main.setBorder(null);
            this.right.setBorder(null);
            this.left.setOpaque(false);
            this.main.setOpaque(false);
            this.right.setOpaque(false);
            this.left.setMinimumSize(new Dimension(7, 7));
            this.right.setMinimumSize(new Dimension(7, 7));
            this.setLayout(new BorderLayout(0, 0));
            this.add((Component)this.left, "West");
            this.add((Component)this.main, "Center");
            this.add((Component)this.right, "East");
        }

        @Override
        protected void setMinimumSize() {
            this.setMinimumSize(new Dimension(14, 7));
        }

        @Override
        protected void drawLine(Graphics g) {
            int vertOffset = this.getSize().height / 2;
            int leftOffset = ((ComponentBorder)ComponentBorder.this).leftBorder.getSize().width / 2;
            int rightOffset = ((ComponentBorder)ComponentBorder.this).rightBorder.getSize().width / 2;
            g.drawLine(leftOffset, vertOffset, this.getSize().width - rightOffset, vertOffset);
            g.drawLine(leftOffset, vertOffset, leftOffset, this.getSize().height);
            g.drawLine(this.getSize().width - rightOffset, vertOffset, this.getSize().width - rightOffset, this.getSize().height);
        }

        public JPanel getContent() {
            return this.main;
        }
    }
}

