/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import edu.uml.lgdc.datatype.DoubleArray;
import edu.uml.lgdc.datatype.WrapToDoubleArray;
import edu.uml.lgdc.graph.Annotation;
import edu.uml.lgdc.graph.ColorValueLegend;
import edu.uml.lgdc.graph.FrameGraph;
import edu.uml.lgdc.graph.GraphBase;
import edu.uml.lgdc.graph.NumericAxis;
import edu.uml.lgdc.graph.UniformDoubleArrayAxis;
import edu.uml.lgdc.math.ExtMath;

public class DiscreteAxis
extends NumericAxis {
    private static final double[][] factorControl = new double[][]{{1.0, 1.0, 1.0, 2.0}, {2.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 2.0, 5.0}, {5.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 2.0}, {10.0, 2.0, 1.0, 1.0}, {1.0, 2.0, 1.0, 1.0}};
    private UniformDoubleArrayAxis arrayAxis;
    private double currentValue;
    private double averageAnnotSize;
    private int factNo = 0;
    private int factQty = factorControl.length;
    private double step;
    private int indexNo = 0;
    private int bigTickStepInIndeces;
    private int annotStepInIndeces;
    private boolean endOfValues;
    private boolean forceThisLayout = false;

    public DiscreteAxis(FrameGraph frameGraph, int axisIndex, double[] data) {
        this(frameGraph, axisIndex, new WrapToDoubleArray(data));
    }

    public DiscreteAxis(FrameGraph frameGraph, int axisIndex, DoubleArray data) {
        this(frameGraph, axisIndex, data, "");
    }

    public DiscreteAxis(FrameGraph frameGraph, int axisIndex, double[] data, String label) {
        this(frameGraph, axisIndex, new WrapToDoubleArray(data), label);
    }

    public DiscreteAxis(ColorValueLegend colorValueLegend, double[] data) {
        this(colorValueLegend, (DoubleArray)new WrapToDoubleArray(data));
    }

    public DiscreteAxis(ColorValueLegend colorValueLegend, DoubleArray data) {
        this(colorValueLegend, data, "");
    }

    public DiscreteAxis(ColorValueLegend colorValueLegend, double[] data, String label) {
        this(colorValueLegend, new WrapToDoubleArray(data), label);
    }

    public DiscreteAxis(GraphBase gb, double[] data) {
        this(gb, (DoubleArray)new WrapToDoubleArray(data));
    }

    public DiscreteAxis(GraphBase gb, DoubleArray data) {
        this(gb, data, 0, 0);
    }

    public DiscreteAxis(GraphBase gb, double[] data, int direction, int annotSide) {
        this(gb, new WrapToDoubleArray(data), direction, annotSide);
    }

    public DiscreteAxis(GraphBase gb, DoubleArray data, int direction, int annotSide) {
        this(gb, data, direction, annotSide, "");
    }

    public DiscreteAxis(GraphBase gb, double[] data, int direction, int annotSide, String label) {
        this(gb, new WrapToDoubleArray(data), direction, annotSide, label);
    }

    public DiscreteAxis(GraphBase gb, DoubleArray data, int direction, int annotSide, String label) {
        this(gb, data, direction, annotSide, label, 0);
    }

    public DiscreteAxis(GraphBase gb, double[] data, int direction, int annotSide, String label, int borderMargin) {
        this(gb, new WrapToDoubleArray(data), direction, annotSide, label, borderMargin);
    }

    public DiscreteAxis(GraphBase gb, DoubleArray data, int direction, int annotSide, String label, int borderMargin) {
        super(gb, direction, annotSide, label, borderMargin);
        this.arrayAxis = new UniformDoubleArrayAxis(data, this.getLength());
        this.setStartValue(this.arrayAxis.element(0));
        this.setEndValue(this.arrayAxis.element(this.arrayAxis.size() - 1));
        this.setMaxValue(this.arrayAxis.getMaxData());
        this.setMinValue(this.arrayAxis.getMinData());
        this.clearDrawMarginValues();
    }

    public DiscreteAxis(GraphBase gb, double[] data, int direction, int annotSide, String label, int xStart, int yStart, int length) {
        this(gb, new WrapToDoubleArray(data), direction, annotSide, label, xStart, yStart, length);
    }

    public DiscreteAxis(GraphBase gb, DoubleArray data, int direction, int annotSide, String label, int xStart, int yStart, int length) {
        super(gb, direction, annotSide, label, xStart, yStart, length);
        this.arrayAxis = new UniformDoubleArrayAxis(data, this.getLength());
        this.setStartValue(this.arrayAxis.element(0));
        this.setEndValue(this.arrayAxis.element(this.arrayAxis.size() - 1));
        this.setMaxValue(this.arrayAxis.getMaxData());
        this.setMinValue(this.arrayAxis.getMinData());
        this.clearDrawMarginValues();
    }

    public DiscreteAxis(FrameGraph frameGraph, int axisIndex, DoubleArray data, String label) {
        super(frameGraph, axisIndex, label);
        this.arrayAxis = new UniformDoubleArrayAxis(data, this.getLength());
        this.setStartValue(this.arrayAxis.element(0));
        this.setEndValue(this.arrayAxis.element(this.arrayAxis.size() - 1));
        this.setMaxValue(this.arrayAxis.getMaxData());
        this.setMinValue(this.arrayAxis.getMinData());
        this.clearDrawMarginValues();
    }

    public DiscreteAxis(ColorValueLegend colorValueLegend, DoubleArray data, String label) {
        super(colorValueLegend, label);
        this.arrayAxis = new UniformDoubleArrayAxis(data, this.getLength());
        this.setStartValue(this.arrayAxis.element(0));
        this.setEndValue(this.arrayAxis.element(this.arrayAxis.size() - 1));
        this.setMaxValue(this.arrayAxis.getMaxData());
        this.setMinValue(this.arrayAxis.getMinData());
        this.clearDrawMarginValues();
    }

    @Override
    public Object clone() {
        DiscreteAxis cloned = null;
        cloned = (DiscreteAxis)super.clone();
        return cloned;
    }

    @Override
    public int offsetToIndex(int offset) {
        return this.arrayAxis.offsetToIndex(offset);
    }

    @Override
    public int indexToOffset(int index) {
        return this.arrayAxis.indexToOffset(index);
    }

    @Override
    public int indexToOffsetCenter(int index) {
        return this.arrayAxis.indexToOffsetCenter(index);
    }

    @Override
    public int indexToOffsetEnd(int index) {
        return this.arrayAxis.indexToOffsetEnd(index);
    }

    @Override
    public int indexToSegmentWidth(int index) {
        return this.arrayAxis.indexToSegmentWidth(index);
    }

    @Override
    public int indexToInsideOffset(int index) {
        return this.indexToOffset(index);
    }

    @Override
    public int indexToInsideOffsetCenter(int index) {
        return this.indexToOffsetCenter(index);
    }

    @Override
    public int indexToInsideOffsetEnd(int index) {
        return this.indexToOffsetEnd(index);
    }

    @Override
    public int indexToInsideSegmentWidth(int index) {
        return this.indexToSegmentWidth(index);
    }

    @Override
    public int indexToUnrestrictedOffset(int index) {
        return -1;
    }

    @Override
    public int indexToUnrestrictedOffsetCenter(int index) {
        return -1;
    }

    @Override
    public int indexToUnrestrictedOffsetEnd(int index) {
        return -1;
    }

    @Override
    public int indexToUnrestrictedSegmentWidth(int index) {
        return -1;
    }

    @Override
    public double offsetToValue(int offset) {
        return this.arrayAxis.offsetToValue(offset);
    }

    @Override
    public double unrestrictedOffsetToValue(int offset) {
        return -1.0;
    }

    @Override
    public void setLength(int length) {
        if (this.arrayAxis != null) {
            this.arrayAxis.setLength(length);
        }
        super.setLength(length);
    }

    @Override
    public int valueToOffset(double value) {
        return -1;
    }

    @Override
    public int valueToUnrestrictedOffset(double value) {
        return -1;
    }

    @Override
    protected void reFillHotValues() {
    }

    @Override
    protected void startFirstLayout() {
        this.averageAnnotSize = this.averageAnnotSizeAlongAxis();
        int maxAnnotSteps = (int)((double)this.length / (this.averageAnnotSize * 100.0 / this.getAnnotDensity()));
        maxAnnotSteps = Math.max(Math.min(maxAnnotSteps, this.arrayAxis.size()), 1);
        this.annotStepInIndeces = this.arrayAxis.size() / maxAnnotSteps;
        this.annotStepInIndeces = (int)Math.pow(10.0, Math.floor(Math.log10(this.annotStepInIndeces)));
        this.annotStepInIndeces = Math.max(this.annotStepInIndeces, 1);
        this.factNo = this.annotStepInIndeces < 10 ? 0 : 5;
        this.startAnnotationProcess();
        this.setBeforeStartAnyLayout();
    }

    @Override
    protected void startNextLayout() {
        this.annotStepInIndeces = (int)((double)this.annotStepInIndeces / factorControl[this.factNo][2] * factorControl[this.factNo][3]);
        ++this.factNo;
        if (this.factNo >= this.factQty) {
            this.factNo = 0;
        }
        this.startAnnotationProcess();
        this.setBeforeStartAnyLayout();
    }

    @Override
    protected boolean forceThisLayout() {
        return this.forceThisLayout;
    }

    @Override
    protected Annotation getNextAnnotation() {
        Annotation annotation = null;
        if (!this.endOfValues && (this.currentValue <= this.getEndValue() || ExtMath.areClose(this.currentValue, this.getEndValue()))) {
            boolean isSmallTick = true;
            boolean isBigTick = this.indexNo % this.bigTickStepInIndeces == 0;
            boolean isAnnotNumber = this.indexNo % this.annotStepInIndeces == 0;
            int offset = Math.round(this.indexToOffsetCenter(this.indexNo));
            if (isBigTick) {
                isSmallTick = false;
            }
            if (offset >= this.length || this.currentValue > this.getEndValue()) {
                this.endOfValues = true;
            }
            annotation = new Annotation(offset, this.currentValue, isAnnotNumber, isSmallTick, isBigTick);
            this.nextAnnotNumber();
        }
        return annotation;
    }

    private void nextAnnotNumber() {
        this.indexNo = (int)((double)this.indexNo + this.step);
        if (this.indexNo < this.arrayAxis.size()) {
            this.currentValue = this.arrayAxis.element(this.indexNo);
        } else {
            this.endOfValues = true;
        }
    }

    private void setBeforeStartAnyLayout() {
        this.step = (double)this.annotStepInIndeces / factorControl[this.factNo][0];
        this.bigTickStepInIndeces = (int)((double)this.annotStepInIndeces / factorControl[this.factNo][1]);
        this.currentValue = this.arrayAxis.element(0);
        this.indexNo = 0;
        this.endOfValues = false;
    }
}

