/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import edu.uml.lgdc.datatype.IncreasingDoubleArray;
import edu.uml.lgdc.datatype.WrapToIncreasingDoubleArray;
import edu.uml.lgdc.graph.ColorValueLegend;
import edu.uml.lgdc.graph.FrameGraph;
import edu.uml.lgdc.graph.GraphBase;
import edu.uml.lgdc.graph.LinearAxis;

public class DiscreteLinearAxis
extends LinearAxis {
    private IncreasingDoubleArray data;

    public DiscreteLinearAxis(FrameGraph frameGraph, int axisIndex, double[] data) {
        this(frameGraph, axisIndex, new WrapToIncreasingDoubleArray(data));
    }

    public DiscreteLinearAxis(FrameGraph frameGraph, int axisIndex, IncreasingDoubleArray data) {
        this(frameGraph, axisIndex, data, "");
    }

    public DiscreteLinearAxis(FrameGraph frameGraph, int axisIndex, double[] data, String label) {
        this(frameGraph, axisIndex, new WrapToIncreasingDoubleArray(data), label);
    }

    public DiscreteLinearAxis(ColorValueLegend colorValueLegend, double[] data) {
        this(colorValueLegend, (IncreasingDoubleArray)new WrapToIncreasingDoubleArray(data));
    }

    public DiscreteLinearAxis(ColorValueLegend colorValueLegend, IncreasingDoubleArray data) {
        this(colorValueLegend, data, "");
    }

    public DiscreteLinearAxis(ColorValueLegend colorValueLegend, double[] data, String label) {
        this(colorValueLegend, new WrapToIncreasingDoubleArray(data), label);
    }

    public DiscreteLinearAxis(GraphBase gb, double[] data) {
        this(gb, (IncreasingDoubleArray)new WrapToIncreasingDoubleArray(data));
    }

    public DiscreteLinearAxis(GraphBase gb, IncreasingDoubleArray data) {
        this(gb, data, 0, 0);
    }

    public DiscreteLinearAxis(GraphBase gb, double[] data, int direction, int annotSide) {
        this(gb, new WrapToIncreasingDoubleArray(data), direction, annotSide);
    }

    public DiscreteLinearAxis(GraphBase gb, IncreasingDoubleArray data, int direction, int annotSide) {
        this(gb, data, direction, annotSide, "");
    }

    public DiscreteLinearAxis(GraphBase gb, double[] data, int direction, int annotSide, String label) {
        this(gb, new WrapToIncreasingDoubleArray(data), direction, annotSide, label);
    }

    public DiscreteLinearAxis(GraphBase gb, IncreasingDoubleArray data, int direction, int annotSide, String label) {
        this(gb, data, direction, annotSide, label, 0);
    }

    public DiscreteLinearAxis(GraphBase gb, double[] data, int direction, int annotSide, String label, int borderMargin) {
        this(gb, new WrapToIncreasingDoubleArray(data), direction, annotSide, label, borderMargin);
    }

    public DiscreteLinearAxis(GraphBase gb, IncreasingDoubleArray data, int direction, int annotSide, String label, int borderMargin) {
        super(gb, data.element(0), data.element(data.size() - 1), direction, annotSide, label, borderMargin);
        this.data = data;
    }

    public DiscreteLinearAxis(GraphBase gb, double[] data, int direction, int annotSide, String label, int xStart, int yStart, int length) {
        this(gb, new WrapToIncreasingDoubleArray(data), direction, annotSide, label, xStart, yStart, length);
    }

    public DiscreteLinearAxis(GraphBase gb, IncreasingDoubleArray data, int direction, int annotSide, String label, int xStart, int yStart, int length) {
        super(gb, data.element(0), data.element(data.size() - 1), direction, annotSide, label, xStart, yStart, length);
        this.data = data;
    }

    public DiscreteLinearAxis(FrameGraph frameGraph, int axisIndex, IncreasingDoubleArray data, String label) {
        super(frameGraph, axisIndex, data.element(0), data.element(data.size() - 1), label);
        this.data = data;
    }

    public DiscreteLinearAxis(ColorValueLegend colorValueLegend, IncreasingDoubleArray data, String label) {
        super(colorValueLegend, data.element(0), data.element(data.size() - 1), label);
        this.data = data;
    }

    @Override
    public Object clone() {
        DiscreteLinearAxis cloned = null;
        cloned = (DiscreteLinearAxis)super.clone();
        return cloned;
    }

    @Override
    public int offsetToIndex(int offset) {
        int index = this.data.valueToIndex(this.offsetToValue(offset));
        if (index == -1) {
            if (offset >= this.indexToInsideOffset(0) && offset <= this.indexToInsideOffsetEnd(this.data.size() - 1)) {
                index = offset <= this.indexToInsideOffsetCenter(0) ? 0 : this.data.size() - 1;
            }
        } else if (offset >= this.indexToInsideOffset(0) && offset <= this.indexToInsideOffsetEnd(this.data.size() - 1)) {
            if (offset < this.indexToInsideOffset(index)) {
                --index;
            } else if (offset > this.indexToInsideOffsetEnd(index)) {
                ++index;
            }
        } else {
            index = -1;
        }
        return index;
    }

    @Override
    public int indexToOffset(int index) {
        double value = this.data.element(index);
        if (index > 0) {
            value = (value + this.data.element(index - 1)) / 2.0;
        }
        return this.valueToOffset(value);
    }

    @Override
    public int indexToOffsetCenter(int index) {
        return this.valueToOffset(this.data.element(index));
    }

    @Override
    public int indexToOffsetEnd(int index) {
        if (index < this.data.size() - 1) {
            return this.indexToOffset(index + 1);
        }
        return this.indexToOffsetCenter(index);
    }

    @Override
    public int indexToUnrestrictedOffset(int index) {
        int offset;
        if (this.data.size() == 1) {
            offset = 0;
        } else if (index > 0) {
            int offset1 = this.valueToUnrestrictedOffset(this.data.element(index));
            int offset2 = this.valueToUnrestrictedOffset(this.data.element(index - 1));
            offset = (offset1 + offset2) / 2;
        } else {
            int offset1 = this.valueToUnrestrictedOffset(this.data.element(index));
            int offset2 = this.valueToUnrestrictedOffset(this.data.element(index + 1));
            offset = offset1 - (offset2 - offset1) / 2;
        }
        return offset;
    }

    @Override
    public int indexToUnrestrictedOffsetCenter(int index) {
        return this.valueToUnrestrictedOffset(this.data.element(index));
    }

    @Override
    public int indexToUnrestrictedOffsetEnd(int index) {
        int offset;
        if (this.data.size() == 1) {
            offset = this.length - 1;
        } else if (index < this.data.size() - 1) {
            int offset1 = this.valueToUnrestrictedOffset(this.data.element(index));
            int offset2 = this.valueToUnrestrictedOffset(this.data.element(index + 1));
            offset = (offset1 + offset2) / 2;
        } else {
            int offset1 = this.valueToUnrestrictedOffset(this.data.element(index));
            int offset2 = this.valueToUnrestrictedOffset(this.data.element(index - 1));
            offset = offset1 + (offset1 - offset2) / 2;
        }
        return offset;
    }

    @Override
    public int indexToInsideOffset(int index) {
        int offset = this.indexToUnrestrictedOffset(index);
        if (this.data.size() == 1 && offset >= 0 && offset < this.length) {
            offset = 0;
        }
        if (offset < 0) {
            offset = 0;
        }
        if (offset > this.length - 1) {
            offset = this.length - 1;
        }
        return offset;
    }

    @Override
    public int indexToInsideOffsetCenter(int index) {
        int offset = this.indexToUnrestrictedOffsetCenter(index);
        if (this.data.size() == 1 && offset >= 0 && offset < this.length) {
            offset = this.length / 2;
        }
        if (offset < 0) {
            offset = 0;
        }
        if (offset > this.length - 1) {
            offset = this.length - 1;
        }
        return offset;
    }

    @Override
    public int indexToInsideOffsetEnd(int index) {
        int offset = this.indexToUnrestrictedOffsetEnd(index);
        if (this.data.size() == 1 && offset >= 0 && offset < this.length) {
            offset = this.length - 1;
        }
        if (offset < 0) {
            offset = 0;
        }
        if (offset > this.length - 1) {
            offset = this.length - 1;
        }
        return offset;
    }

    @Override
    public int indexToSegmentWidth(int index) {
        return this.indexToOffsetEnd(index) - this.indexToOffset(index);
    }

    @Override
    public int indexToUnrestrictedSegmentWidth(int index) {
        return this.indexToUnrestrictedOffsetEnd(index) - this.indexToUnrestrictedOffset(index);
    }

    @Override
    public int indexToInsideSegmentWidth(int index) {
        return this.indexToInsideOffsetEnd(index) - this.indexToInsideOffset(index);
    }

    public void setData(IncreasingDoubleArray data) {
        this.data = data;
        super.setStartValue(data.element(0));
        super.setEndValue(data.element(data.size() - 1));
    }

    @Override
    public void setStartValue(double startValue) {
        super.setStartValue(startValue);
    }

    @Override
    public void setEndValue(double endValue) {
        super.setEndValue(endValue);
    }
}

