/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import edu.uml.lgdc.datatype.geom.R2;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.graph.CheckConstants;
import edu.uml.lgdc.graph.QualityRenderingEvent;
import edu.uml.lgdc.graph.QualityRenderingListener;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JTextArea;

public final class Draw {
    protected static boolean qualityRendering = true;
    private static Vector<QualityRenderingListener> qualityRenderingListeners = new Vector();

    public static boolean getQualityRendering() {
        return qualityRendering;
    }

    public static void setQualityRendering(boolean value) {
        if (value != qualityRendering) {
            qualityRendering = value;
            Draw.fireQualityRenderingEvent(new QualityRenderingEvent(Draw.class, qualityRendering));
        }
    }

    public static void setQualityRendering(Graphics g) {
        Draw.setQualityRendering(g, qualityRendering);
    }

    public static void setQualityRendering(Graphics g, boolean quality) {
        if (g == null) {
            return;
        }
        Graphics2D g2D = (Graphics2D)g;
        if (quality) {
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }

    public static void addQualityRenderingListener(QualityRenderingListener listener) {
        qualityRenderingListeners.add(listener);
    }

    public static void removeQualityRenderingListener(QualityRenderingListener listener) {
        qualityRenderingListeners.remove(listener);
    }

    private static void fireQualityRenderingEvent(QualityRenderingEvent event) {
        for (QualityRenderingListener listener : qualityRenderingListeners) {
            listener.stateChanged(event);
        }
    }

    public static void drawLine(Graphics g, R2 point1, R2 point2) {
        g.drawLine((int)Math.round(point1.getX()), (int)Math.round(point1.getY()), (int)Math.round(point2.getX()), (int)Math.round(point2.getY()));
    }

    public static Point getScrVectorDirection(int direction) {
        int x = 0;
        int y = 0;
        CheckConstants.validDirection(direction);
        switch (direction) {
            case 0: {
                x = 1;
                y = 0;
                break;
            }
            case 1: {
                x = 0;
                y = -1;
                break;
            }
            case 2: {
                x = -1;
                y = 0;
                break;
            }
            case 3: {
                x = 0;
                y = 1;
            }
        }
        return new Point(x, y);
    }

    public static R2 getScrSideVector(Point vector, int side) {
        return Draw.getScrSideVector(new R2(vector), side);
    }

    public static R2 getScrSideVector(R2 vector, int side) {
        return Draw.getSideVector(vector, side, true);
    }

    public static R2 getSideVector(Point vector, int side) {
        return Draw.getSideVector(new R2(vector), side);
    }

    public static R2 getSideVector(R2 vector, int side) {
        return Draw.getSideVector(vector, side, false);
    }

    public static R2 getSideVector(R2 vector, int side, boolean leftHanded) {
        double rotateAngle;
        CheckConstants.validSide(side);
        vector = new R2(vector);
        double d = rotateAngle = side == 1 ? 1.5707963267948966 : -1.5707963267948966;
        if (leftHanded) {
            rotateAngle = -rotateAngle;
        }
        vector.rotate(rotateAngle);
        return vector;
    }

    public static void centerPosition(Component comp) {
        Draw.centerPosition(comp, null);
    }

    public static void centerPosition(Component comp1, Component comp2) {
        Dimension comp2Size;
        Point comp2Loc;
        Dimension comp1Size = comp1.getSize();
        if (comp2 == null) {
            comp2Loc = new Point(0, 0);
            comp2Size = Toolkit.getDefaultToolkit().getScreenSize();
        } else {
            comp2Loc = comp2.getLocation();
            comp2Size = comp2.getSize();
        }
        int xLoc = (comp2Size.width - comp1Size.width) / 2 + comp2Loc.x;
        int yLoc = (comp2Size.height - comp1Size.height) / 2 + comp2Loc.y;
        if (xLoc < 0) {
            xLoc = 0;
        }
        if (yLoc < 0) {
            yLoc = 0;
        }
        comp1.setLocation(xLoc, yLoc);
    }

    public static void drawSparseLine(Graphics g, int x1, int y1, int x2, int y2) {
        Draw.drawSparseLine(g, x1, y1, x2, y2, null);
    }

    public static void drawSparseLine(Graphics g, int x1, int y1, int x2, int y2, Color background) {
        block11: {
            block8: {
                block9: {
                    int along;
                    double tang;
                    block10: {
                        int step = 2;
                        if (background != null) {
                            Color prevColor = g.getColor();
                            g.setColor(background);
                            g.drawLine(x1, y1, x2, y2);
                            g.setColor(prevColor);
                        }
                        if (Math.abs(x2 - x1) < Math.abs(y2 - y1)) break block8;
                        if (x1 == x2) break block9;
                        tang = (double)(y2 - y1) / (double)(x2 - x1);
                        along = x1;
                        if (x1 >= x2) break block10;
                        while (along <= x2) {
                            int other = (int)Math.round((double)y1 + (double)(along - x1) * tang);
                            g.drawLine(along, other, along, other);
                            along += 2;
                        }
                        break block11;
                    }
                    if (x1 <= x2) break block11;
                    while (along >= x2) {
                        int other = (int)Math.round((double)y1 + (double)(along - x1) * tang);
                        g.drawLine(along, other, along, other);
                        along -= 2;
                    }
                    break block11;
                }
                g.drawLine(x1, y1, x1, y1);
                break block11;
            }
            double tang = (double)(x2 - x1) / (double)(y2 - y1);
            int along = y1;
            if (y1 < y2) {
                while (along <= y2) {
                    int other = (int)Math.round((double)x1 + (double)(along - y1) * tang);
                    g.drawLine(other, along, other, along);
                    along += 2;
                }
            } else if (y1 > y2) {
                while (along >= y2) {
                    int other = (int)Math.round((double)x1 + (double)(along - y1) * tang);
                    g.drawLine(other, along, other, along);
                    along -= 2;
                }
            }
        }
    }

    public static void drawThinLine(Graphics g, int x1, int y1, int x2, int y2) {
        Graphics2D g1 = (Graphics2D)g;
        Stroke s = g1.getStroke();
        g1.setStroke(new BasicStroke(0.5f));
        g1.drawLine(x1, y1, x2, y2);
        g1.setStroke(s);
    }

    public static void connectCircles(Graphics g, int x1, int y1, int x2, int y2, int d, int origin) {
        int eI;
        int sI;
        int otherEnd;
        int otherStart;
        int end;
        int start;
        boolean step = true;
        double halfOfPixel = 0.5;
        int along1 = Integer.MIN_VALUE;
        int other1 = Integer.MIN_VALUE;
        int along2 = Integer.MIN_VALUE;
        int other2 = Integer.MIN_VALUE;
        boolean outOfFirst = false;
        int[] x = new int[]{x1, x2};
        int[] y = new int[]{y1, y2};
        double[] cx = new double[]{x1, x2};
        double[] cy = new double[]{y1, y2};
        boolean alongX = true;
        if (origin != 2 && origin != 3 && origin != 0 && origin != 1) {
            origin = -1;
        }
        if (d % 2 == 1) {
            origin = -1;
        }
        if (origin == -1 && d % 2 == 0) {
            ++d;
        }
        double radiusSquare = (double)d / 2.0 * ((double)d / 2.0);
        if (origin != -1) {
            if (origin == 2) {
                cx[0] = cx[0] - 0.5;
                cx[1] = cx[1] - 0.5;
                cy[0] = cy[0] - 0.5;
                cy[1] = cy[1] - 0.5;
            } else if (origin == 3) {
                cx[0] = cx[0] + 0.5;
                cx[1] = cx[1] + 0.5;
                cy[0] = cy[0] - 0.5;
                cy[1] = cy[1] - 0.5;
            } else if (origin == 0) {
                cx[0] = cx[0] - 0.5;
                cx[1] = cx[1] - 0.5;
                cy[0] = cy[0] + 0.5;
                cy[1] = cy[1] + 0.5;
            } else if (origin == 1) {
                cx[0] = cx[0] + 0.5;
                cx[1] = cx[1] + 0.5;
                cy[0] = cy[0] + 0.5;
                cy[1] = cy[1] + 0.5;
            }
        }
        if (Math.abs(x2 - x1) < Math.abs(y2 - y1)) {
            double dTmp = cx[0];
            cx[0] = cy[0];
            cy[0] = dTmp;
            dTmp = cx[1];
            cx[1] = cy[1];
            cy[1] = dTmp;
            int iTmp = x[0];
            x[0] = y[0];
            y[0] = iTmp;
            iTmp = x[1];
            x[1] = y[1];
            y[1] = iTmp;
            alongX = false;
        }
        if (x[0] != x[1]) {
            if (x[0] < x[1]) {
                start = x[0];
                end = x[1];
                otherStart = y[0];
                otherEnd = y[1];
                sI = 0;
                eI = 1;
            } else {
                start = x[1];
                end = x[0];
                otherStart = y[1];
                otherEnd = y[0];
                sI = 1;
                eI = 0;
            }
        } else {
            return;
        }
        double tang = (double)(otherEnd - otherStart) / (double)(end - start);
        int along = start + 1;
        while (along <= end) {
            int other = (int)Math.round((double)otherStart + (double)(along - start) * tang);
            if (!outOfFirst && ((double)along - cx[sI]) * ((double)along - cx[sI]) + ((double)other - cy[sI]) * ((double)other - cy[sI]) > radiusSquare) {
                along1 = along;
                other1 = other;
                outOfFirst = true;
            }
            if (outOfFirst) {
                if (((double)along - cx[eI]) * ((double)along - cx[eI]) + ((double)other - cy[eI]) * ((double)other - cy[eI]) <= radiusSquare) {
                    if (along2 == Integer.MIN_VALUE) break;
                    if (alongX) {
                        g.drawLine(along1, other1, along2, other2);
                        break;
                    }
                    g.drawLine(other1, along1, other2, along2);
                    break;
                }
                along2 = along;
                other2 = other;
            }
            ++along;
        }
    }

    public static void setEnabled(Component comp, boolean flag) {
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            Component[] components = cont.getComponents();
            int i = 0;
            while (i < components.length) {
                Draw.setEnabled(components[i], flag);
                ++i;
            }
            comp.setEnabled(flag);
        } else {
            comp.setEnabled(flag);
        }
    }

    public static void setForeground(Component comp, Color color) {
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            Component[] components = cont.getComponents();
            int i = 0;
            while (i < components.length) {
                Draw.setForeground(components[i], color);
                ++i;
            }
            comp.setForeground(color);
        } else {
            comp.setForeground(color);
        }
    }

    public static void setBackground(Component comp, Color color) {
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            Component[] components = cont.getComponents();
            int i = 0;
            while (i < components.length) {
                Draw.setBackground(components[i], color);
                ++i;
            }
            if (!(comp instanceof JComboBox)) {
                comp.setBackground(color);
            } else {
                ((JComboBox)comp).setEditable(false);
            }
        } else {
            comp.setBackground(color);
        }
    }

    public static Dimension rebuildTextArea(JTextArea ta) {
        String[] adjustedLines;
        boolean changed = true;
        String[] lines = FC.str2LinesArray(ta.getText());
        if (lines.length < 100) {
            adjustedLines = new String[lines.length + 2];
            int i = 0;
            while (i < lines.length) {
                adjustedLines[i + 1] = "    " + lines[i] + "    ";
                ++i;
            }
            adjustedLines[0] = "";
            adjustedLines[lines.length + 1] = "";
        } else {
            adjustedLines = lines;
            changed = false;
        }
        FontMetrics fm = ta.getFontMetrics(ta.getFont());
        int width = 0;
        int i = 0;
        while (i < adjustedLines.length) {
            int len = fm.stringWidth(adjustedLines[i]);
            if (width < len) {
                width = len;
            }
            ++i;
        }
        width += Math.max((int)((double)width * 0.1), 5);
        if (changed) {
            ta.setText("");
            i = 0;
            while (i < adjustedLines.length) {
                ta.append(adjustedLines[i]);
                if (i != adjustedLines.length - 1) {
                    ta.append("\n");
                }
                ++i;
            }
        }
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        width = Math.min(width, (int)((double)scrSize.width * 0.75));
        int height = adjustedLines.length * (int)(1.4 * (double)fm.getHeight());
        height = Math.min(height, (int)((double)scrSize.height * 0.75));
        return new Dimension(width, height);
    }

    public static AlphaComposite makeComposite(float alpha) {
        return AlphaComposite.getInstance(3, alpha);
    }
}

