/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import edu.uml.lgdc.gui.icons.IconsDir;
import edu.uml.lgdc.project.settings.ContentType;
import edu.uml.lgdc.project.settings.OptionDesc;
import edu.uml.lgdc.project.settings.OptionsIO;
import edu.uml.lgdc.project.settings.SectionDescriptor;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class ImageSettings
extends SectionDescriptor<ImageSettings> {
    private static final String DEFAULT_SECTION_NAME = "General Image Settings";
    private static final String PAR_CANVAS_WIDTH = "CanvasWidth";
    private static final String PAR_CANVAS_HEIGHT = "CanvasHeight";
    private static final String PAR_PRINTER_COLOR_SCHEME = "PrinterColorScheme";
    private static final String PAR_APPLICATION_INFO = "ApplicationInfo";
    private static final String PAR_LOGO_FILENAME_EXT = "LogoFilenameExternal";
    private static final String PAR_DISABLED = "Disabled";
    private static final String PAR_IMAGE_FORMAT = "ImageFormat";
    private static final String PAR_FILENAME_TYPE_SUFFIX = "FilenameTypeSuffix";
    private static final String PAR_QUALITY_RENDERING = "QualityRendering";
    protected final String secName;
    private int canvasWidth = 700;
    private int canvasHeight = 600;
    private boolean printerColorScheme = true;
    private String applicationInfo = "";
    protected ImageIcon iconLogo = null;
    protected URL iconResource = null;
    private String iconLogoFilenameExternal = "";
    protected ImageIcon iconLogoExternal = null;
    private boolean disabled = false;
    private String imageFormat = "png";
    private String filenameTypeSuffix = "";
    private boolean qualityRendering = true;
    protected final Map<String, OptionDesc> descriptor;

    public ImageSettings() {
        this(DEFAULT_SECTION_NAME);
    }

    public ImageSettings(String secName) {
        this.secName = secName;
        this.descriptor = new HashMap<String, OptionDesc>();
        this.setDefaults();
        this.fillDescriptor();
    }

    protected void setDefaults() {
        this.canvasWidth = 700;
        this.canvasHeight = 600;
        this.printerColorScheme = true;
        this.applicationInfo = "";
        this.iconLogoFilenameExternal = "";
        this.setDefaultLogo();
        this.disabled = false;
        this.imageFormat = "png";
        this.filenameTypeSuffix = "";
        this.qualityRendering = true;
    }

    public void setDefaultLogo() {
        this.iconResource = this.printerColorScheme ? IconsDir.class.getResource("/edu/uml/lgdc/gui/icons/LGDC-logo-v3-light-200.png") : IconsDir.class.getResource("/edu/uml/lgdc/gui/icons/LGDC-logo-v3-dark-200.png");
        this.iconLogo = new ImageIcon(this.iconResource);
    }

    @Override
    protected void fillDescriptor() {
        this.descriptor.put(PAR_CANVAS_WIDTH, new OptionDesc((Object)this.canvasWidth, ContentType.DISPLAY));
        this.descriptor.put(PAR_CANVAS_HEIGHT, new OptionDesc((Object)this.canvasHeight, ContentType.DISPLAY));
        this.descriptor.put(PAR_PRINTER_COLOR_SCHEME, new OptionDesc((Object)this.printerColorScheme, ContentType.DISPLAY));
        this.descriptor.put(PAR_APPLICATION_INFO, new OptionDesc((Object)this.applicationInfo, ContentType.DISPLAY));
        this.descriptor.put(PAR_LOGO_FILENAME_EXT, new OptionDesc((Object)this.iconLogoFilenameExternal, ContentType.DISPLAY));
        this.descriptor.put(PAR_DISABLED, new OptionDesc((Object)this.disabled, ContentType.DISPLAY));
        this.descriptor.put(PAR_IMAGE_FORMAT, new OptionDesc((Object)this.imageFormat, ContentType.DISPLAY));
        this.descriptor.put(PAR_FILENAME_TYPE_SUFFIX, new OptionDesc((Object)this.filenameTypeSuffix, ContentType.DISPLAY));
        this.descriptor.put(PAR_QUALITY_RENDERING, new OptionDesc((Object)this.qualityRendering, ContentType.DISPLAY));
    }

    @Override
    public void getFrom(OptionsIO optionsIO) {
        this.canvasWidth = Integer.parseInt(optionsIO.get(this.secName, PAR_CANVAS_WIDTH));
        this.canvasHeight = Integer.parseInt(optionsIO.get(this.secName, PAR_CANVAS_HEIGHT));
        this.printerColorScheme = Boolean.valueOf(optionsIO.get(this.secName, PAR_PRINTER_COLOR_SCHEME));
        this.applicationInfo = optionsIO.get(this.secName, PAR_APPLICATION_INFO);
        this.iconLogoFilenameExternal = optionsIO.get(this.secName, PAR_LOGO_FILENAME_EXT);
        this.loadExternalIconImage();
        this.disabled = Boolean.valueOf(optionsIO.get(this.secName, PAR_DISABLED));
        this.imageFormat = optionsIO.get(this.secName, PAR_IMAGE_FORMAT);
        this.filenameTypeSuffix = optionsIO.get(this.secName, PAR_FILENAME_TYPE_SUFFIX);
        this.qualityRendering = Boolean.valueOf(optionsIO.get(this.secName, PAR_QUALITY_RENDERING));
    }

    protected void loadExternalIconImage() {
        this.iconLogoExternal = this.getLogoFilenameExternal() != null && this.getLogoFilenameExternal().length() > 3 && new File(this.getLogoFilenameExternal()).exists() ? new ImageIcon(this.getLogoFilenameExternal()) : null;
    }

    @Override
    public void putTo(OptionsIO optionsIO) {
        optionsIO.put(this.secName, PAR_CANVAS_WIDTH, String.valueOf(this.canvasWidth));
        optionsIO.put(this.secName, PAR_CANVAS_HEIGHT, String.valueOf(this.canvasHeight));
        optionsIO.put(this.secName, PAR_PRINTER_COLOR_SCHEME, String.valueOf(this.printerColorScheme));
        optionsIO.put(this.secName, PAR_APPLICATION_INFO, this.applicationInfo);
        optionsIO.put(this.secName, PAR_LOGO_FILENAME_EXT, this.iconLogoFilenameExternal);
        optionsIO.put(this.secName, PAR_DISABLED, String.valueOf(this.disabled));
        optionsIO.put(this.secName, PAR_IMAGE_FORMAT, this.imageFormat);
        optionsIO.put(this.secName, PAR_FILENAME_TYPE_SUFFIX, this.filenameTypeSuffix);
        optionsIO.put(this.secName, PAR_QUALITY_RENDERING, String.valueOf(this.qualityRendering));
    }

    @Override
    public ImageSettings getThis() {
        return this;
    }

    @Override
    public String getName() {
        return this.secName;
    }

    @Override
    public Map<String, OptionDesc> getOptionsDescriptor() {
        return this.descriptor;
    }

    public boolean isExternalLogoAvailable() {
        return this.iconLogoExternal != null;
    }

    public String getLogoFilenameExternal() {
        return this.iconLogoFilenameExternal;
    }

    public void setIconLogoFilenameExternal(String value) {
        this.iconLogoFilenameExternal = value;
    }

    public ImageIcon getLogoIcon() {
        return this.iconLogo;
    }

    public void setLogoIcon(ImageIcon i) {
        this.iconLogo = i;
    }

    public void resetLogoIcon() {
        this.iconLogo = this.iconLogoExternal;
    }

    public int getCanvasWidth() {
        return this.canvasWidth;
    }

    public void setCanvasWidth(int value) {
        this.canvasWidth = value;
    }

    public int getCanvasHeight() {
        return this.canvasHeight;
    }

    public void setCanvasHeight(int value) {
        this.canvasHeight = value;
    }

    public boolean isPrinterColorScheme() {
        return this.printerColorScheme;
    }

    public void setPrinterColorScheme(boolean printerColorScheme) {
        this.printerColorScheme = printerColorScheme;
        this.setDefaultLogo();
    }

    public boolean isEnabled() {
        return !this.disabled;
    }

    public void setEnabled(boolean value) {
        this.disabled = !value;
    }

    public void setDisabled(boolean value) {
        this.disabled = value;
    }

    public void setApplicationInfo(String applicationInfo) {
        this.applicationInfo = applicationInfo;
    }

    public String getApplicationInfo() {
        return this.applicationInfo;
    }

    public String getImageFormat() {
        return this.imageFormat;
    }

    public void setImageFormat(String imageFormat) {
        this.imageFormat = imageFormat;
    }

    public String getFilenameTypeSuffix() {
        return this.filenameTypeSuffix;
    }

    public void setFilenameTypeSuffix(String filenameTypeSuffix) {
        this.filenameTypeSuffix = filenameTypeSuffix;
    }

    public boolean getQualityRendering() {
        return this.qualityRendering;
    }

    public void setQualityRendering(boolean quality) {
        this.qualityRendering = quality;
    }
}

