/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import edu.uml.lgdc.graph.Annotation;
import edu.uml.lgdc.graph.ColorValueLegend;
import edu.uml.lgdc.graph.FrameGraph;
import edu.uml.lgdc.graph.GraphBase;
import edu.uml.lgdc.graph.LogarithmicScale;
import edu.uml.lgdc.graph.MonotonicAxis;
import edu.uml.lgdc.math.ExtMath;

public class LogarithmicAxis
extends MonotonicAxis {
    private LogarithmicScale logarithmicScale;
    private double minLogValue;
    private double maxLogValue;
    private double firstAnnotValue;
    private double factor;
    private double currentValue;
    private double step;
    private int stepNo;
    private int bigStepInSteps;
    private int annotStepInSteps;
    private boolean endOfValues;
    private boolean forceThisLayout = false;

    public LogarithmicAxis(FrameGraph frameGraph, int axisIndex, double startValue, double endValue) {
        this(frameGraph, axisIndex, startValue, endValue, "");
    }

    public LogarithmicAxis(ColorValueLegend colorValueLegend, double startValue, double endValue) {
        this(colorValueLegend, startValue, endValue, "");
    }

    public LogarithmicAxis(GraphBase gb, double startValue, double endValue) {
        this(gb, startValue, endValue, 0, 0);
    }

    public LogarithmicAxis(GraphBase gb, double startValue, double endValue, int direction, int annotSide) {
        this(gb, startValue, endValue, direction, annotSide, "");
    }

    public LogarithmicAxis(GraphBase gb, double startValue, double endValue, int direction, int annotSide, String label) {
        this(gb, startValue, endValue, direction, annotSide, label, 0);
    }

    public LogarithmicAxis(GraphBase gb, double startValue, double endValue, int direction, int annotSide, String label, int borderMargin) {
        super(gb, startValue, endValue, direction, annotSide, label, borderMargin);
        this.logarithmicScale = new LogarithmicScale(startValue, endValue, this.length);
        this.minLogValue = Math.log10(this.getMinValue());
        this.maxLogValue = Math.log10(this.getMaxValue());
    }

    public LogarithmicAxis(GraphBase gb, double startValue, double endValue, int direction, int annotSide, String label, int xStart, int yStart, int length) {
        super(gb, startValue, endValue, direction, annotSide, label, xStart, yStart, length);
        this.logarithmicScale = new LogarithmicScale(startValue, endValue, length);
        this.minLogValue = Math.log10(this.getMinValue());
        this.maxLogValue = Math.log10(this.getMaxValue());
    }

    public LogarithmicAxis(FrameGraph frameGraph, int axisIndex, double startValue, double endValue, String label) {
        super(frameGraph, axisIndex, startValue, endValue, label);
        this.logarithmicScale = new LogarithmicScale(startValue, endValue, this.length);
        this.minLogValue = Math.log10(this.getMinValue());
        this.maxLogValue = Math.log10(this.getMaxValue());
    }

    public LogarithmicAxis(ColorValueLegend colorValueLegend, double startValue, double endValue, String label) {
        super(colorValueLegend, startValue, endValue, label);
        this.logarithmicScale = new LogarithmicScale(startValue, endValue, this.length);
        this.minLogValue = Math.log10(this.getMinValue());
        this.maxLogValue = Math.log10(this.getMaxValue());
    }

    @Override
    public Object clone() {
        LogarithmicAxis cloned = null;
        cloned = (LogarithmicAxis)super.clone();
        cloned.logarithmicScale = new LogarithmicScale(this.logarithmicScale);
        return cloned;
    }

    @Override
    public int offsetToIndex(int offset) {
        return -1;
    }

    @Override
    public int indexToOffset(int index) {
        return -1;
    }

    @Override
    public int indexToOffsetCenter(int index) {
        return -1;
    }

    @Override
    public int indexToOffsetEnd(int index) {
        return -1;
    }

    @Override
    public int indexToSegmentWidth(int index) {
        return -1;
    }

    @Override
    public int indexToInsideOffset(int index) {
        return -1;
    }

    @Override
    public int indexToInsideOffsetCenter(int index) {
        return -1;
    }

    @Override
    public int indexToInsideOffsetEnd(int index) {
        return -1;
    }

    @Override
    public int indexToInsideSegmentWidth(int index) {
        return -1;
    }

    @Override
    public int indexToUnrestrictedOffset(int index) {
        return -1;
    }

    @Override
    public int indexToUnrestrictedOffsetCenter(int index) {
        return -1;
    }

    @Override
    public int indexToUnrestrictedOffsetEnd(int index) {
        return -1;
    }

    @Override
    public int indexToUnrestrictedSegmentWidth(int index) {
        return -1;
    }

    @Override
    public int valueToOffset(double value) {
        return this.logarithmicScale.valueToOffset(value);
    }

    @Override
    public int valueToUnrestrictedOffset(double value) {
        return this.logarithmicScale.valueToUnrestrictedOffset(value);
    }

    @Override
    public double offsetToValue(int offset) {
        return this.logarithmicScale.offsetToValue(offset);
    }

    @Override
    public double unrestrictedOffsetToValue(int offset) {
        return this.logarithmicScale.unrestrictedOffsetToValue(offset);
    }

    @Override
    public void setLength(int length) {
        if (this.logarithmicScale != null) {
            this.logarithmicScale.setLength(length);
        }
        super.setLength(length);
    }

    @Override
    public void setStartValue(double startValue) {
        this.logarithmicScale.setStartValue(startValue);
        super.setStartValue(startValue);
    }

    @Override
    public void setEndValue(double endValue) {
        this.logarithmicScale.setEndValue(endValue);
        super.setEndValue(endValue);
    }

    @Override
    protected void startFirstLayout() {
        this.factor = 10.0;
        this.firstAnnotValue = Math.pow(this.factor, Math.ceil(this.minLogValue));
        this.startAnnotationProcess();
        this.setBeforeStartAnyLayout();
    }

    @Override
    protected void startNextLayout() {
        this.factor *= 10.0;
        this.firstAnnotValue *= 10.0;
        this.startAnnotationProcess();
        this.setBeforeStartAnyLayout();
    }

    @Override
    protected boolean forceThisLayout() {
        return this.forceThisLayout;
    }

    @Override
    protected Annotation getNextAnnotation() {
        Annotation annotation = null;
        if (!this.endOfValues && this.currentValue <= this.getEndValue() || ExtMath.areClose(this.currentValue, this.getEndValue())) {
            int offset;
            boolean isAnnotNumber;
            boolean isSmallTick = true;
            boolean isBigTick = this.stepNo % this.bigStepInSteps == 0;
            boolean bl = isAnnotNumber = this.stepNo % this.annotStepInSteps == 0;
            if (isBigTick) {
                isSmallTick = false;
            }
            if ((offset = Math.round(this.valueToOffset(this.currentValue))) >= this.length || this.currentValue > this.getEndValue()) {
                this.endOfValues = true;
            }
            annotation = new Annotation(offset, this.currentValue, isAnnotNumber, isSmallTick, isBigTick);
            this.nextAnnotNumber();
        }
        return annotation;
    }

    private void nextAnnotNumber() {
        if (this.stepNo % 10 == 0) {
            this.step *= this.factor;
            ++this.stepNo;
        }
        ++this.stepNo;
        this.currentValue += this.step;
    }

    private void setBeforeStartAnyLayout() {
        if (this.getIntegerValuesFlag()) {
            this.firstAnnotValue = Math.max(this.firstAnnotValue, 10.0);
        }
        this.currentValue = 2.0 * (this.firstAnnotValue / this.factor);
        this.step = this.firstAnnotValue / 10.0;
        this.stepNo = 2;
        this.bigStepInSteps = 5;
        this.annotStepInSteps = 10;
        this.endOfValues = false;
    }
}

