/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import edu.uml.lgdc.graph.Scale;
import edu.uml.lgdc.math.ExtMath;

public class LogarithmicScale
extends Scale {
    private double startLogValue;
    private double endLogValue;

    public LogarithmicScale(LogarithmicScale logarithmicScale) {
        super(logarithmicScale);
        this.startLogValue = Math.log10(logarithmicScale.startValue);
        this.endLogValue = Math.log10(logarithmicScale.endValue);
    }

    public LogarithmicScale(double startValue, double endValue, int length) {
        super(startValue, endValue, length);
        this.startLogValue = Math.log10(startValue);
        this.endLogValue = Math.log10(endValue);
    }

    @Override
    public int valueToOffset(double value) {
        return this.valueToOffset(value, false);
    }

    public int valueToUnrestrictedOffset(double value) {
        return this.valueToOffset(value, true);
    }

    @Override
    public double unrestrictedOffsetToValue(int offset) {
        double value = offset == 0 ? this.startValue : (offset == this.length - 1 ? this.endValue : Math.pow(10.0, this.startLogValue + ((double)offset + 0.5) * ((this.endLogValue - this.startLogValue) / (double)this.length)));
        return value;
    }

    @Override
    public void setStartValue(double startValue) {
        this.startLogValue = Math.log10(startValue);
        super.setStartValue(startValue);
    }

    @Override
    public void setEndValue(double endValue) {
        this.endLogValue = Math.log10(endValue);
        super.setEndValue(endValue);
    }

    private int valueToOffset(double value, boolean unRestricted) {
        int offset = -1;
        if (unRestricted || value >= this.startValue && value <= this.endValue || ExtMath.areClose(value, this.startValue) || ExtMath.areClose(value, this.endValue)) {
            offset = (int)Math.round((double)(this.length - 1) * (Math.log10(value) - this.startLogValue) / (this.endLogValue - this.startLogValue));
        }
        return offset;
    }
}

