/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import edu.uml.lgdc.colorscale.ColorScale;
import edu.uml.lgdc.colorscale.NASA;
import edu.uml.lgdc.graph.C16;
import edu.uml.lgdc.graph.FrameGraph;
import java.awt.Color;
import java.awt.Graphics;

public class Optifont {
    private static final Color noValueColor = Color.GRAY;
    private static final int BOTTOM_LEFT = 0;
    private static final int BOTTOM_RIGHT = 10;
    private static final int TOP_LEFT = 20;
    private static final int TOP_RIGHT = 30;
    private static final int BOTTOM_LEFT_A = 1;
    private static final int BOTTOM_RIGHT_A = 11;
    private static final int TOP_LEFT_A = 21;
    private static final int TOP_RIGHT_A = 31;
    private static final int FONT_WIDTH = 5;
    private static final int FONT_HEIGHT = 4;
    private static final byte[][] OFC;
    private static final int NUMBER_OF_OPTI_FONTS = 15;
    private double noValue;
    private double maxAmp1;
    private ColorScale colorScale;
    private transient Graphics g;
    private transient int variant;
    private transient int xOrigin;
    private transient int yOrigin;
    private transient int x;
    private transient int y;
    private transient int width;
    private transient int height;
    private transient Color color;

    static {
        byte[][] byArrayArray = new byte[22][];
        byte[] byArray = new byte[4];
        byArray[1] = 10;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[4];
        byArray2[1] = 31;
        byArrayArray[1] = byArray2;
        byte[] byArray3 = new byte[4];
        byArray3[1] = 29;
        byArray3[2] = 18;
        byArrayArray[2] = byArray3;
        byte[] byArray4 = new byte[4];
        byArray4[1] = 21;
        byArray4[2] = 27;
        byArrayArray[3] = byArray4;
        byte[] byArray5 = new byte[4];
        byArray5[0] = 7;
        byArray5[1] = 4;
        byArray5[2] = 30;
        byArrayArray[4] = byArray5;
        byte[] byArray6 = new byte[4];
        byArray6[0] = 23;
        byArray6[1] = 21;
        byArray6[2] = 24;
        byArrayArray[5] = byArray6;
        byte[] byArray7 = new byte[4];
        byArray7[0] = 31;
        byArray7[1] = 20;
        byArray7[2] = 28;
        byArrayArray[6] = byArray7;
        byte[] byArray8 = new byte[4];
        byArray8[0] = 29;
        byArray8[1] = 31;
        byArray8[2] = 3;
        byArrayArray[7] = byArray8;
        byte[] byArray9 = new byte[4];
        byArray9[0] = 31;
        byArray9[1] = 21;
        byArray9[2] = 15;
        byArrayArray[8] = byArray9;
        byte[] byArray10 = new byte[4];
        byArray10[0] = 23;
        byArray10[1] = 29;
        byArray10[2] = 31;
        byArrayArray[9] = byArray10;
        byte[] byArray11 = new byte[4];
        byArray11[0] = 31;
        byArray11[1] = 27;
        byArray11[2] = 31;
        byArrayArray[10] = byArray11;
        byArrayArray[11] = new byte[]{31, 31, 30, 16};
        byArrayArray[12] = new byte[]{31, 31, 29, 18};
        byArrayArray[13] = new byte[]{31, 31, 21, 27};
        byArrayArray[14] = new byte[]{31, 31, 31, 14};
        byArrayArray[15] = new byte[]{31, 31, 31, 29};
        byte[] byArray12 = new byte[4];
        byArray12[1] = 12;
        byArrayArray[16] = byArray12;
        byte[] byArray13 = new byte[4];
        byArray13[0] = 19;
        byArray13[1] = 21;
        byArray13[2] = 25;
        byArrayArray[17] = byArray13;
        byArrayArray[18] = new byte[]{31, 21, 21, 21};
        byArrayArray[19] = new byte[]{31, 5, 5, 5};
        byte[] byArray14 = new byte[4];
        byArray14[0] = 1;
        byArray14[1] = 30;
        byArray14[2] = 1;
        byArrayArray[20] = byArray14;
        byte[] byArray15 = new byte[4];
        byArray15[0] = 31;
        byArray15[1] = 31;
        byArray15[2] = 31;
        byArrayArray[21] = byArray15;
        OFC = byArrayArray;
    }

    public Optifont(double noValue) {
        this(noValue, new NASA());
    }

    public Optifont(double noValue, ColorScale colorScale) {
        this.noValue = noValue;
        this.colorScale = colorScale;
    }

    public void drawRectFont(Graphics g0, int x, int y, float amp, float ampMin, float ampDiapason, float colorValue, float colorValueMin, float colorValueDiapason, double widthInPixels, double heightInPixels) {
        this.prepareRectFont(x, y, amp, ampMin, ampDiapason, colorValue, colorValueMin, colorValueDiapason, widthInPixels, heightInPixels);
        g0.setColor(this.color);
        g0.fillRect(this.x, this.y, this.width, this.height);
    }

    public void drawRectFont(int x, int y, float amp, float ampMin, float ampDiapason, float colorValue, float colorValueMin, float colorValueDiapason, double widthInPixels, double heightInPixels) {
        this.prepareRectFont(x, y, amp, ampMin, ampDiapason, colorValue, colorValueMin, colorValueDiapason, widthInPixels, heightInPixels);
        this.drawUsingGraph();
    }

    public void drawRectFont(int x, int y, float amp, float ampMin, float ampDiapason, Color color, double widthInPixels, double heightInPixels) {
        this.prepareRectFont(x, y, amp, ampMin, ampDiapason, color, widthInPixels, heightInPixels);
        this.drawUsingGraph();
    }

    private void drawUsingGraph() {
        this.g.setColor(this.color);
        switch (this.variant) {
            case 0: {
                this.g.fillRect(this.xOrigin + this.x, this.yOrigin - (this.y + this.height - 1), this.width, this.height);
                break;
            }
            case 10: {
                this.g.fillRect(this.xOrigin - (this.y + this.height - 1), this.yOrigin - (this.x + this.width - 1), this.height, this.width);
                break;
            }
            case 20: {
                this.g.fillRect(this.xOrigin + this.y, this.yOrigin + this.x, this.height, this.width);
                break;
            }
            case 30: {
                this.g.fillRect(this.xOrigin - (this.x + this.width - 1), this.yOrigin + this.y, this.width, this.height);
                break;
            }
            case 1: {
                this.g.fillRect(this.xOrigin + this.y, this.yOrigin - (this.x + this.width - 1), this.height, this.width);
                break;
            }
            case 11: {
                this.g.fillRect(this.xOrigin - (this.x + this.width - 1), this.yOrigin - (this.y + this.height - 1), this.width, this.height);
                break;
            }
            case 21: {
                this.g.fillRect(this.xOrigin + this.x, this.yOrigin + this.y, this.width, this.height);
                break;
            }
            case 31: {
                this.g.fillRect(this.xOrigin - (this.y + this.height - 1), this.yOrigin + this.x, this.height, this.width);
            }
        }
    }

    private void prepareRectFont(int x, int y, float amp, float ampMin, float ampDiapason, float colorValue, float colorValueMin, float colorValueDiapason, double widthInPixels, double heightInPixels) {
        double value;
        if ((double)amp == this.noValue || (double)colorValue == this.noValue) {
            value = 1.0;
            this.color = noValueColor;
        } else {
            value = (double)(amp - ampMin) / (double)ampDiapason;
            this.color = this.colorScale.getColor((double)(colorValue - colorValueMin) / (double)colorValueDiapason);
        }
        this.width = (int)Math.round(value * widthInPixels + 0.5);
        this.height = (int)Math.round(value * heightInPixels + 0.5);
        this.x = x + (int)(widthInPixels - (double)this.width) / 2;
        this.y = y + (int)(heightInPixels - (double)this.height) / 2;
    }

    private void prepareRectFont(int x, int y, float amp, float ampMin, float ampDiapason, Color color, double widthInPixels, double heightInPixels) {
        double value;
        if ((double)amp == this.noValue) {
            value = 1.0;
            this.color = noValueColor;
        } else {
            value = amp <= ampMin ? 0.0 : (amp >= ampMin + ampDiapason ? 1.0 : (double)((amp - ampMin) / ampDiapason));
            this.color = color;
        }
        this.width = (int)Math.round(value * widthInPixels);
        this.height = (int)Math.round(value * heightInPixels);
        this.x = x + (int)(widthInPixels - (double)this.width) / 2;
        this.y = y + (int)(heightInPixels - (double)this.height) / 2;
    }

    public void setFrameGraphParam(FrameGraph frameGraph) {
        this.g = frameGraph.getGraphics();
        this.variant = 10 * frameGraph.getOriginType() + frameGraph.getOrientation();
        this.xOrigin = frameGraph.getXAxis().getXOrigin();
        this.yOrigin = frameGraph.getXAxis().getYOrigin();
    }

    public void setGraphics(Graphics graphics) {
        this.g = graphics;
    }

    public ColorScale getColorScale() {
        return this.colorScale;
    }

    public void setColorScale(ColorScale cs) {
        this.colorScale = cs;
    }

    public void setMaxAmplitude(double maxAmp) {
        this.maxAmp1 = maxAmp + 1.0;
    }

    public void drawRectFont(Graphics g0, int x, int y, int value, int colorIndex, double stepWidth, double stepHeight) {
        g0.setColor(C16.get(colorIndex));
        g0.fillRect(x + (int)Math.round((this.maxAmp1 - (double)value) / 2.0 * (stepWidth /= this.maxAmp1)), y + (int)Math.round((this.maxAmp1 - (double)value) / 2.0 * (stepHeight /= this.maxAmp1)), (int)Math.round(stepWidth * (double)value + 0.5), (int)Math.round(stepHeight * (double)value + 0.5));
    }

    public void drawNumberFont(Graphics g0, int x, int y, int value, int colorIndex, int backColor, double stepWidth, double stepHeight, int number) {
        g0.setColor(C16.get(colorIndex));
        int xStart = x + (int)Math.round((this.maxAmp1 - (double)value) / 2.0 * (stepWidth /= this.maxAmp1));
        int yStart = y + (int)Math.round((this.maxAmp1 - (double)value) / 2.0 * (stepHeight /= this.maxAmp1));
        int xWidth = (int)Math.round(stepWidth * (double)value + 0.5);
        int yHeight = (int)Math.round(stepHeight * (double)value + 0.5);
        g0.fillRect(xStart, yStart, xWidth, yHeight);
        if (stepWidth > 1.6 && stepHeight > 0.7 && number != Integer.MAX_VALUE) {
            if (backColor == 15) {
                g0.setColor(Color.black);
            } else if (colorIndex == 10 || colorIndex == 11 || colorIndex == 8) {
                g0.setColor(C16.get(13));
            } else {
                g0.setColor(C16.get(15));
            }
            String padding = "";
            if (number < 100) {
                padding = " ";
            }
            if (number < 10) {
                padding = "  ";
            }
            g0.drawString(String.valueOf(padding) + number, x + (int)Math.round((this.maxAmp1 - (double)value) / 2.0 * stepWidth) + (int)Math.round(0.5 * (stepWidth * (double)value + 0.5) - 10.0), y + (int)Math.round((this.maxAmp1 - (double)value) / 2.0 * stepHeight) + (int)Math.round(0.5 * (stepHeight * (double)value + 0.5) + 5.0));
        }
    }

    public void drawPixel(Graphics g0, int x, int y, int value, int colorValue, double stepWidth, double stepHeight) {
        g0.setColor(C16.get(colorValue));
        int index = Math.min((int)Math.round((double)value / (this.maxAmp1 - 1.0) * 15.0), 15);
        byte[] of = OFC[index];
        double pixelWidth = stepWidth / 6.0;
        double pixelHeight = stepHeight / 5.0;
        int pixWidth = (int)Math.round(pixelWidth + 0.5);
        int pixHeight = (int)Math.round(pixelHeight + 0.5);
        double pixelWidth2 = pixelWidth / 2.0;
        double pixelHeight2 = pixelHeight / 2.0;
        int i = 0;
        while (i < 4) {
            byte line = of[3 - i];
            int mask = 16;
            int j = 4;
            while (j >= 0) {
                if ((line & mask) > 0) {
                    g0.fillRect((int)Math.round((double)x + (double)j * pixelWidth + pixelWidth2), (int)Math.round((double)y + (double)i * pixelHeight + pixelHeight2), pixWidth, pixHeight);
                }
                mask = (byte)(mask >> 1);
                --j;
            }
            ++i;
        }
    }
}

