/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.TableCellRenderer;

public class TableUtils {
    public static void mouseMovedOverTable(MouseEvent e) {
        JTable table = (JTable)e.getSource();
        int col = table.columnAtPoint(e.getPoint());
        int row = table.rowAtPoint(e.getPoint());
        if (col == -1 || row == -1) {
            return;
        }
        Rectangle rect = table.getCellRect(row, col, false);
        TableCellRenderer renderer = table.getCellRenderer(row, col);
        Component component = table.prepareRenderer(renderer, row, col);
        if (component != null && component instanceof JLabel) {
            JLabel label = (JLabel)component;
            String val = label.getText();
            if (val != null && (double)label.getFontMetrics(label.getFont()).stringWidth(val) > rect.getWidth() - 2.0) {
                label.setToolTipText(val);
            } else {
                label.setToolTipText(null);
            }
        }
    }

    public static void keepRowVisible(int index, JViewport viewport, JTable table) {
        int yPosOffset = 0;
        Rectangle rectangle = viewport.getViewRect();
        int viewY = rectangle.y;
        int viewHeight = rectangle.height;
        int rowY = index * table.getRowHeight();
        if (rowY < viewY) {
            yPosOffset = rowY - viewY;
        } else if (rowY + table.getRowHeight() >= viewY + viewHeight) {
            yPosOffset = rowY - (viewY + viewHeight - table.getRowHeight());
        }
        if (yPosOffset != 0) {
            viewport.scrollRectToVisible(new Rectangle(0, yPosOffset, 0, viewHeight));
        }
    }

    public static void movePageUp(JViewport viewport, JTable table) {
        Rectangle rectangle = viewport.getViewRect();
        int viewY = rectangle.y;
        int viewHeight = rectangle.height;
        int rowToSelect = (viewY - viewHeight + table.getRowHeight() - 1) / table.getRowHeight();
        if (rowToSelect < 0) {
            rowToSelect = 0;
        }
        int rowY = rowToSelect * table.getRowHeight();
        viewport.scrollRectToVisible(new Rectangle(0, rowY - viewY, 0, viewHeight));
        table.setRowSelectionInterval(rowToSelect, rowToSelect);
    }

    public static void movePageDown(JViewport viewport, JTable table) {
        Rectangle rectangle = viewport.getViewRect();
        int viewY = rectangle.y;
        int viewHeight = rectangle.height;
        int rowToSelect = (viewY + viewHeight) / table.getRowHeight();
        if (rowToSelect > table.getRowCount() - 1) {
            rowToSelect = table.getRowCount() - 1;
        }
        int rowY = rowToSelect * table.getRowHeight();
        viewport.scrollRectToVisible(new Rectangle(0, rowY - viewY, 0, viewHeight));
        table.setRowSelectionInterval(rowToSelect, rowToSelect);
    }
}

