/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import edu.uml.lgdc.datatype.DoubleArray;
import edu.uml.lgdc.graph.DoubleArrayAxis;

public class UniformDoubleArrayAxis
extends DoubleArrayAxis {
    public UniformDoubleArrayAxis(DoubleArray data, int length) {
        super(data, length);
    }

    @Override
    public int offsetToIndex(int offset) {
        int index = -1;
        if (offset >= 0 && offset < this.length) {
            index = (int)((double)offset / ((double)this.length / (double)this.data.size()));
        }
        return index;
    }

    @Override
    public int indexToOffset(int index) {
        int offset = -1;
        if (index >= 0 && index < this.data.size()) {
            offset = (int)((double)index * ((double)this.length / (double)this.data.size()));
        }
        return offset;
    }

    public int indexToOffsetCenter(int index) {
        int offset = this.indexToOffset(index);
        if (offset == -1) {
            return offset;
        }
        return offset + this.indexToSegmentWidth(index) / 2;
    }

    public int indexToOffsetEnd(int index) {
        int offset = this.indexToOffset(index);
        if (offset == -1) {
            return offset;
        }
        return offset + this.indexToSegmentWidth(index);
    }

    public int indexToSegmentWidth(int index) {
        return (int)Math.round((double)this.length / (double)this.data.size());
    }
}

