/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import edu.uml.lgdc.graph.GraphConstants;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class VerticalStr {
    private Graphics g;
    private Color color;
    private Font font = GraphConstants.BASIC_FONT;
    private FontMetrics fontMetrics;
    private int height;

    public VerticalStr(Graphics g) {
        this(g, Color.black);
    }

    public VerticalStr(Graphics g, Color color) {
        this.g = g;
        this.color = color;
        this.setFont(this.font);
    }

    public void setFont(Font font) {
        this.font = font;
        this.fontMetrics = this.g.getFontMetrics(font);
        this.height = this.fontMetrics.getHeight() - this.fontMetrics.getLeading();
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void drawString(String str, int x, int y) {
        Graphics2D g2d = (Graphics2D)this.g;
        Font prevFont = g2d.getFont();
        Color prevColor = g2d.getColor();
        int width = this.fontMetrics.stringWidth(str);
        g2d.translate(x, y);
        g2d.rotate(-1.5707963267948966);
        g2d.setFont(this.font);
        g2d.setColor(this.color);
        g2d.drawString(str, -width, this.height);
        g2d.rotate(1.5707963267948966);
        g2d.translate(-x, -y);
        g2d.setFont(prevFont);
        g2d.setColor(prevColor);
    }
}

