/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class WindowDisposerProcess
extends Thread {
    private static final int SHORT_WAIT_IN_MILLISECONDS = 200;
    private static final int NUMBER_OF_SHORTS_IN_SECOND = 5;
    private Window mw;
    private int durationMS;
    private boolean stop = false;
    private int totalMS = 0;
    private int timeLeftInSec;
    private int currentShortInSec = 0;
    private String title;

    public WindowDisposerProcess(Window mw, int durationSec) {
        this.mw = mw;
        this.durationMS = durationSec * 1000;
        this.timeLeftInSec = durationSec;
        if (mw instanceof JDialog) {
            this.title = ((JDialog)mw).getTitle();
        } else if (mw instanceof JFrame) {
            this.title = ((JFrame)mw).getTitle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.stop || this.totalMS < this.durationMS) {
            if (this.title != null) {
                if (this.currentShortInSec == 0) {
                    this.setTimeLeft();
                }
                ++this.currentShortInSec;
                if (this.currentShortInSec == 5) {
                    this.currentShortInSec = 0;
                    --this.timeLeftInSec;
                }
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.totalMS += 200;
        }
        WindowDisposerProcess windowDisposerProcess = this;
        synchronized (windowDisposerProcess) {
            if (!this.stop) {
                this.mw.setVisible(false);
                this.mw.dispose();
            }
        }
    }

    public synchronized void stopIt() {
        this.stop = true;
    }

    private void setTimeLeft() {
        final int time = this.timeLeftInSec;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (WindowDisposerProcess.this.mw instanceof JDialog) {
                    ((JDialog)WindowDisposerProcess.this.mw).setTitle(String.valueOf(WindowDisposerProcess.this.title) + "  ...closed in " + time + "s");
                } else {
                    ((JFrame)WindowDisposerProcess.this.mw).setTitle(String.valueOf(WindowDisposerProcess.this.title) + "  ...closed in " + time + "s");
                }
            }
        });
    }
}

